/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal.comm;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.redmine.ta.RedmineException;
import org.redmine.ta.RedmineTransportException;
import org.redmine.ta.internal.comm.BasicHttpResponse;
import org.redmine.ta.internal.comm.ContentHandler;
import org.redmine.ta.internal.comm.HttpUtil;

final class TransportDecoder
implements ContentHandler<HttpResponse, BasicHttpResponse> {
    TransportDecoder() {
    }

    @Override
    public BasicHttpResponse processContent(HttpResponse content) throws RedmineException {
        HttpEntity entity = content.getEntity();
        String charset = HttpUtil.getCharset(entity);
        String encoding = HttpUtil.getEntityEncoding(entity);
        try {
            InputStream initialStream = entity.getContent();
            return new BasicHttpResponse(content.getStatusLine().getStatusCode(), this.decodeStream(encoding, initialStream), charset);
        }
        catch (IOException e) {
            throw new RedmineTransportException(e);
        }
    }

    private InputStream decodeStream(String encoding, InputStream initialStream) throws IOException {
        if (encoding == null) {
            return initialStream;
        }
        if ("gzip".equals(encoding)) {
            return new GZIPInputStream(initialStream);
        }
        if ("deflate".equals(encoding)) {
            return new InflaterInputStream(initialStream);
        }
        throw new IOException("Unsupported transport encoding " + encoding);
    }
}

