/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal.logging;

import java.util.Date;
import org.redmine.ta.internal.logging.LogLevel;
import org.redmine.ta.internal.logging.Logger;

public final class DefaultLogger
implements Logger {
    private final String identifier;
    private LogLevel logLevel = LogLevel.INFO;

    public DefaultLogger(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLogger logger = (DefaultLogger)o;
        return !(this.identifier != null ? !this.identifier.equals(logger.identifier) : logger.identifier != null);
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    @Override
    public void debug(String message) {
        if (LogLevel.DEBUG.equals((Object)this.logLevel)) {
            this.log(message, LogLevel.DEBUG);
        }
    }

    @Override
    public void info(String message) {
        switch (this.logLevel) {
            case INFO: 
            case DEBUG: {
                this.log(message, LogLevel.INFO);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void warn(String message) {
        switch (this.logLevel) {
            case INFO: 
            case DEBUG: 
            case WARN: {
                this.log(message, LogLevel.WARN);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void error(String message) {
        this.log(message, LogLevel.ERROR);
    }

    @Override
    public void error(Throwable throwable, String message) {
        if (LogLevel.ERROR.equals((Object)this.logLevel)) {
            this.log(throwable, message, LogLevel.ERROR);
        }
    }

    private void log(String message, LogLevel level) {
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append(new Date());
        logBuilder.append(" - [");
        logBuilder.append((Object)level);
        logBuilder.append("] - ");
        logBuilder.append(this.getIdentifier());
        logBuilder.append(" - ");
        logBuilder.append(message);
        System.out.println(logBuilder.toString());
    }

    private void log(Throwable throwable, String message, LogLevel level) {
        this.log(message, level);
        throwable.printStackTrace();
    }
}

