/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineFormatException;
import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.RedmineOptions;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.IssueStatus;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.News;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.SavedQuery;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import com.taskadapter.redmineapi.internal.RedmineJSONBuilder;
import com.taskadapter.redmineapi.internal.RedmineJSONParser;
import com.taskadapter.redmineapi.internal.URIConfigurator;
import com.taskadapter.redmineapi.internal.comm.BaseCommunicator;
import com.taskadapter.redmineapi.internal.comm.BasicHttpResponse;
import com.taskadapter.redmineapi.internal.comm.Communicator;
import com.taskadapter.redmineapi.internal.comm.Communicators;
import com.taskadapter.redmineapi.internal.comm.ContentHandler;
import com.taskadapter.redmineapi.internal.comm.SimpleCommunicator;
import com.taskadapter.redmineapi.internal.comm.redmine.RedmineAuthenticator;
import com.taskadapter.redmineapi.internal.comm.redmine.RedmineErrorHandler;
import com.taskadapter.redmineapi.internal.json.JsonInput;
import com.taskadapter.redmineapi.internal.json.JsonObjectParser;
import com.taskadapter.redmineapi.internal.json.JsonObjectWriter;
import com.taskadapter.redmineapi.internal.logging.Logger;
import com.taskadapter.redmineapi.internal.logging.LoggerFactory;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public final class Transport {
    private static final Map<Class<?>, EntityConfig<?>> OBJECT_CONFIGS = new HashMap();
    private static final String CONTENT_TYPE = "application/json; charset=utf-8";
    private static final int DEFAULT_OBJECTS_PER_PAGE = 25;
    private static final String KEY_TOTAL_COUNT = "total_count";
    private final Logger logger = LoggerFactory.getLogger(RedmineManager.class);
    private SimpleCommunicator<String> communicator;
    private final Communicator<BasicHttpResponse> errorCheckingCommunicator;
    private final BaseCommunicator baseCommunicator;
    private final RedmineAuthenticator<HttpResponse> authenticator;
    private final Communicator<String> coreCommunicator;
    private final URIConfigurator configurator;
    private String login;
    private String password;
    private int objectsPerPage = 25;
    private static final String CHARSET = "UTF-8";

    public Transport(URIConfigurator configurator, RedmineOptions options) {
        this.configurator = configurator;
        this.baseCommunicator = new BaseCommunicator(options);
        this.authenticator = new RedmineAuthenticator<HttpResponse>(this.baseCommunicator, CHARSET);
        RedmineErrorHandler errorProcessor = new RedmineErrorHandler();
        this.errorCheckingCommunicator = Communicators.fmap(this.authenticator, Communicators.compose(errorProcessor, Communicators.transportDecoder()));
        this.coreCommunicator = Communicators.fmap(this.errorCheckingCommunicator, Communicators.contentReader());
        this.communicator = Communicators.simplify(this.coreCommunicator, Communicators.identityHandler());
    }

    public User getCurrentUser(NameValuePair ... params) throws RedmineException {
        URI uri = this.getURIConfigurator().createURI("users/current.json", params);
        HttpGet http = new HttpGet(uri);
        String response = this.getCommunicator().sendRequest((HttpRequest)http);
        return Transport.parseResponse(response, "user", RedmineJSONParser.USER_PARSER);
    }

    public <T> T addObject(T object, NameValuePair ... params) throws RedmineException {
        EntityConfig<T> config = this.getConfig(object.getClass());
        URI uri = this.getURIConfigurator().getObjectsURI(object.getClass(), params);
        HttpPost httpPost = new HttpPost(uri);
        String body = RedmineJSONBuilder.toSimpleJSON(config.singleObjectName, object, config.writer);
        this.setEntity((HttpEntityEnclosingRequest)httpPost, body);
        String response = this.getCommunicator().sendRequest((HttpRequest)httpPost);
        this.logger.debug(response);
        return Transport.parseResponse(response, config.singleObjectName, config.parser);
    }

    public <T> T addChildEntry(Class<?> parentClass, String parentId, T object, NameValuePair ... params) throws RedmineException {
        EntityConfig<T> config = this.getConfig(object.getClass());
        URI uri = this.getURIConfigurator().getChildObjectsURI(parentClass, parentId, object.getClass(), params);
        HttpPost httpPost = new HttpPost(uri);
        String body = RedmineJSONBuilder.toSimpleJSON(config.singleObjectName, object, config.writer);
        this.setEntity((HttpEntityEnclosingRequest)httpPost, body);
        String response = this.getCommunicator().sendRequest((HttpRequest)httpPost);
        this.logger.debug(response);
        return Transport.parseResponse(response, config.singleObjectName, config.parser);
    }

    public <T extends Identifiable> void updateObject(T obj, NameValuePair ... params) throws RedmineException {
        EntityConfig<T> config = this.getConfig(obj.getClass());
        URI uri = this.getURIConfigurator().getObjectURI(obj.getClass(), Integer.toString(obj.getId()), new NameValuePair[0]);
        HttpPut http = new HttpPut(uri);
        String body = RedmineJSONBuilder.toSimpleJSON(config.singleObjectName, obj, config.writer);
        this.setEntity((HttpEntityEnclosingRequest)http, body);
        this.getCommunicator().sendRequest((HttpRequest)http);
    }

    public <T extends Identifiable> void deleteObject(Class<T> classs, String id) throws RedmineException {
        URI uri = this.getURIConfigurator().getObjectURI(classs, id, new NameValuePair[0]);
        HttpDelete http = new HttpDelete(uri);
        this.getCommunicator().sendRequest((HttpRequest)http);
    }

    public <T> T getObject(Class<T> classs, String key, NameValuePair ... args) throws RedmineException {
        EntityConfig<T> config = this.getConfig(classs);
        URI uri = this.getURIConfigurator().getObjectURI(classs, key, args);
        HttpGet http = new HttpGet(uri);
        String response = this.getCommunicator().sendRequest((HttpRequest)http);
        this.logger.debug(response);
        return Transport.parseResponse(response, config.singleObjectName, config.parser);
    }

    public <R> R download(String uri, ContentHandler<BasicHttpResponse, R> handler) throws RedmineException {
        HttpGet request = new HttpGet(uri);
        return this.errorCheckingCommunicator.sendRequest((HttpRequest)request, handler);
    }

    public String upload(InputStream content) throws RedmineException {
        URI uploadURI = this.getURIConfigurator().getUploadURI();
        HttpPost request = new HttpPost(uploadURI);
        InputStreamEntity entity = new InputStreamEntity(content, -1L);
        entity.setContentType("application/octet-stream");
        request.setEntity((HttpEntity)entity);
        String result = this.getCommunicator().sendRequest((HttpRequest)request);
        return Transport.parseResponse(result, "upload", RedmineJSONParser.UPLOAD_TOKEN_PARSER);
    }

    public <T> T getObject(Class<T> classs, Integer key, NameValuePair ... args) throws RedmineException {
        return this.getObject(classs, key.toString(), args);
    }

    public <T> List<T> getObjectsList(Class<T> objectClass, NameValuePair ... params) throws RedmineException {
        return this.getObjectsList(objectClass, Arrays.asList(params));
    }

    public <T> List<T> getObjectsList(Class<T> objectClass, Collection<? extends NameValuePair> params) throws RedmineException {
        int totalObjectsFoundOnServer;
        List foundItems;
        EntityConfig<T> config = this.getConfig(objectClass);
        ArrayList result = new ArrayList();
        ArrayList<? extends NameValuePair> newParams = new ArrayList<NameValuePair>(params);
        newParams.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(this.objectsPerPage)));
        int offset = 0;
        do {
            ArrayList<? extends NameValuePair> paramsList = new ArrayList<NameValuePair>(newParams);
            paramsList.add((NameValuePair)new BasicNameValuePair("offset", String.valueOf(offset)));
            URI uri = this.getURIConfigurator().getObjectsURI(objectClass, paramsList);
            this.logger.debug(uri.toString());
            HttpGet http = new HttpGet(uri);
            String response = this.getCommunicator().sendRequest((HttpRequest)http);
            this.logger.debug("received: " + response);
            try {
                JSONObject responseObject = RedmineJSONParser.getResponse(response);
                foundItems = JsonInput.getListOrNull(responseObject, config.multiObjectName, config.parser);
                result.addAll(foundItems);
                if (!responseObject.has(KEY_TOTAL_COUNT)) break;
                totalObjectsFoundOnServer = JsonInput.getInt(responseObject, KEY_TOTAL_COUNT);
            }
            catch (JSONException e) {
                throw new RedmineFormatException(e);
            }
        } while (foundItems.size() != 0 && (offset += foundItems.size()) < totalObjectsFoundOnServer);
        return result;
    }

    public int getObjectsPerPage() {
        return this.objectsPerPage;
    }

    public <T> List<T> getChildEntries(Class<?> parentClass, String parentId, Class<T> classs) throws RedmineException {
        EntityConfig<T> config = this.getConfig(classs);
        URI uri = this.getURIConfigurator().getChildObjectsURI(parentClass, parentId, classs, new NameValuePair[0]);
        HttpGet http = new HttpGet(uri);
        String response = this.getCommunicator().sendRequest((HttpRequest)http);
        try {
            JSONObject responseObject = RedmineJSONParser.getResponse(response);
            return JsonInput.getListNotNull(responseObject, config.multiObjectName, config.parser);
        }
        catch (JSONException e) {
            throw new RedmineFormatException("Bad categories response " + response, e);
        }
    }

    public void setObjectsPerPage(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page size must be >= 0. You provided: " + pageSize);
        }
        this.objectsPerPage = pageSize;
    }

    private SimpleCommunicator<String> getCommunicator() throws RedmineException {
        return this.communicator;
    }

    private static <T> T parseResponse(String response, String tag, JsonObjectParser<T> parser) throws RedmineFormatException {
        try {
            return parser.parse(RedmineJSONParser.getResponseSingleObject(response, tag));
        }
        catch (JSONException e) {
            throw new RedmineFormatException(e);
        }
    }

    private void setEntity(HttpEntityEnclosingRequest request, String body) {
        StringEntity entity;
        try {
            entity = new StringEntity(body, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RedmineInternalError("Required charset UTF-8 is not supported", e);
        }
        entity.setContentType(CONTENT_TYPE);
        request.setEntity((HttpEntity)entity);
    }

    private <T> EntityConfig<T> getConfig(Class<?> class1) {
        EntityConfig<?> guess = OBJECT_CONFIGS.get(class1);
        if (guess == null) {
            throw new RedmineInternalError("Unsupported class " + class1);
        }
        return guess;
    }

    private URIConfigurator getURIConfigurator() {
        return this.configurator;
    }

    private static <T> EntityConfig<T> config(String objectField, String urlPrefix, JsonObjectWriter<T> writer, JsonObjectParser<T> parser) {
        return new EntityConfig<T>(objectField, urlPrefix, writer, parser);
    }

    public void setCredentials(String login, String password) {
        this.login = login;
        this.password = password;
        this.authenticator.setCredentials(login, password);
    }

    public void shutdown() {
        this.baseCommunicator.shutdown();
    }

    public void setPassword(String password) {
        this.setCredentials(this.login, password);
    }

    public void setLogin(String login) {
        this.setCredentials(login, this.password);
    }

    static {
        OBJECT_CONFIGS.put(Project.class, Transport.config("project", "projects", RedmineJSONBuilder.PROJECT_WRITER, RedmineJSONParser.PROJECT_PARSER));
        OBJECT_CONFIGS.put(Issue.class, Transport.config("issue", "issues", RedmineJSONBuilder.ISSUE_WRITER, RedmineJSONParser.ISSUE_PARSER));
        OBJECT_CONFIGS.put(User.class, Transport.config("user", "users", RedmineJSONBuilder.USER_WRITER, RedmineJSONParser.USER_PARSER));
        OBJECT_CONFIGS.put(IssueCategory.class, Transport.config("issue_category", "issue_categories", RedmineJSONBuilder.CATEGORY_WRITER, RedmineJSONParser.CATEGORY_PARSER));
        OBJECT_CONFIGS.put(Version.class, Transport.config("version", "versions", RedmineJSONBuilder.VERSION_WRITER, RedmineJSONParser.VERSION_PARSER));
        OBJECT_CONFIGS.put(TimeEntry.class, Transport.config("time_entry", "time_entries", RedmineJSONBuilder.TIME_ENTRY_WRITER, RedmineJSONParser.TIME_ENTRY_PARSER));
        OBJECT_CONFIGS.put(News.class, Transport.config("news", "news", null, RedmineJSONParser.NEWS_PARSER));
        OBJECT_CONFIGS.put(IssueRelation.class, Transport.config("relation", "relations", RedmineJSONBuilder.RELATION_WRITER, RedmineJSONParser.RELATION_PARSER));
        OBJECT_CONFIGS.put(Tracker.class, Transport.config("tracker", "trackers", null, RedmineJSONParser.TRACKER_PARSER));
        OBJECT_CONFIGS.put(IssueStatus.class, Transport.config("status", "issue_statuses", null, RedmineJSONParser.STATUS_PARSER));
        OBJECT_CONFIGS.put(SavedQuery.class, Transport.config("query", "queries", null, RedmineJSONParser.QUERY_PARSER));
        OBJECT_CONFIGS.put(Role.class, Transport.config("role", "roles", null, RedmineJSONParser.ROLE_PARSER));
        OBJECT_CONFIGS.put(Membership.class, Transport.config("membership", "memberships", RedmineJSONBuilder.MEMBERSHIP_WRITER, RedmineJSONParser.MEMBERSHIP_PARSER));
    }

    static class EntityConfig<T> {
        final String singleObjectName;
        final String multiObjectName;
        final JsonObjectWriter<T> writer;
        final JsonObjectParser<T> parser;

        public EntityConfig(String objectField, String urlPrefix, JsonObjectWriter<T> writer, JsonObjectParser<T> parser) {
            this.singleObjectName = objectField;
            this.multiObjectName = urlPrefix;
            this.writer = writer;
            this.parser = parser;
        }
    }
}

