/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.impl.http;

import com.julienvey.trello.TrelloHttpClient;
import com.julienvey.trello.exception.TrelloHttpException;
import java.net.URI;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RestTemplateHttpClient
implements TrelloHttpClient {
    private RestTemplate restTemplate = new RestTemplate();

    @Override
    public <T> T postForObject(String url, T object, Class<T> objectClass, String ... params) {
        try {
            return (T)this.restTemplate.postForObject(url, object, objectClass, (Object[])params);
        }
        catch (RestClientException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public URI postForLocation(String url, Object object, String ... params) {
        try {
            return this.restTemplate.postForLocation(url, object, (Object[])params);
        }
        catch (RestClientException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public <T> T get(String url, Class<T> objectClass, String ... params) {
        try {
            return (T)this.restTemplate.getForObject(url, objectClass, (Object[])params);
        }
        catch (RestClientException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public <T> T putForObject(String url, T object, Class<T> objectClass, String ... params) {
        try {
            return (T)this.restTemplate.exchange(url, HttpMethod.PUT, new HttpEntity(object), objectClass, (Object[])params).getBody();
        }
        catch (RestClientException e) {
            throw new TrelloHttpException(e);
        }
    }
}

