/*
 * Decompiled with CFR 0.152.
 */
package com.testsigma.sdk;

import com.testsigma.sdk.Logger;
import com.testsigma.sdk.Result;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.NoSuchElementException;

public abstract class Action {
    private static final int MESSAGE_MAX_SIZE = 500;
    protected String errorMessage;
    protected String successMessage;
    private StringBuffer loggedMessages = new StringBuffer();
    protected Logger logger = new Logger(new StringBuilder(""));

    protected abstract Result execute() throws NoSuchElementException;

    protected void setErrorMessage(String errorMessage) {
        this.errorMessage = StringUtils.abbreviate((String)errorMessage, (int)500);
    }

    protected void setSuccessMessage(String successMessage) {
        this.successMessage = StringUtils.abbreviate((String)successMessage, (int)500);
    }

    protected void log(Object message) {
        this.loggedMessages.append(message.toString()).append("<br>");
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public StringBuffer getLoggedMessages() {
        return this.loggedMessages;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLoggedMessages(StringBuffer loggedMessages) {
        this.loggedMessages = loggedMessages;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action other = (Action)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$successMessage = this.getSuccessMessage();
        String other$successMessage = other.getSuccessMessage();
        if (this$successMessage == null ? other$successMessage != null : !this$successMessage.equals(other$successMessage)) {
            return false;
        }
        StringBuffer this$loggedMessages = this.getLoggedMessages();
        StringBuffer other$loggedMessages = other.getLoggedMessages();
        if (this$loggedMessages == null ? other$loggedMessages != null : !this$loggedMessages.equals(other$loggedMessages)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        return !(this$logger == null ? other$logger != null : !((Object)this$logger).equals(other$logger));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Action;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $successMessage = this.getSuccessMessage();
        result = result * 59 + ($successMessage == null ? 43 : $successMessage.hashCode());
        StringBuffer $loggedMessages = this.getLoggedMessages();
        result = result * 59 + ($loggedMessages == null ? 43 : $loggedMessages.hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : ((Object)$logger).hashCode());
        return result;
    }

    public String toString() {
        return "Action(errorMessage=" + this.getErrorMessage() + ", successMessage=" + this.getSuccessMessage() + ", loggedMessages=" + this.getLoggedMessages() + ", logger=" + this.getLogger() + ")";
    }
}

