/*
 * Decompiled with CFR 0.152.
 */
package com.testsigma.sdk;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MailboxMessage {
    private String subject;
    private String sentTo;
    private String textMessage;
    private String htmlMessage;
    private String receivedFrom;
    private Map<String, String> attachmentUrls;
    private Timestamp receivedAt;
    private String headers;

    public String getOTP(String regex) throws Exception {
        String parsedOTP = null;
        if (this.getHtmlMessage() != null) {
            parsedOTP = this.parseOTP(regex, this.getTextMessage());
        }
        return parsedOTP;
    }

    public String urlWithText(String text) throws Exception {
        String url = this.getLinkWithTextFromHtml(text);
        if (url != null) {
            return url;
        }
        throw new Exception("No Url found");
    }

    public String urlWhichContains(String substring) throws Exception {
        List<String> allLinks = this.getLinksFromContent(null);
        for (String url : allLinks) {
            if (!url.contains(substring)) continue;
            return url;
        }
        throw new Exception("No Url found");
    }

    private String parseOTP(String regex, String message) throws Exception {
        if (regex == null) {
            regex = "\\d{4,8}";
        }
        try {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(message);
            if (matcher.find()) {
                return matcher.group(0);
            }
            throw new Exception("OTP parsing failed with given regex.");
        }
        catch (Exception e) {
            throw new Exception("OTP parsing failed - " + e.getMessage());
        }
    }

    private String getLinkWithTextFromHtml(String text) throws Exception {
        String parsedLink = null;
        if (this.getHtmlMessage() != null) {
            parsedLink = this.parseLinkWithTextFromHtml(this.getHtmlMessage(), text);
        }
        assert (parsedLink != null);
        return parsedLink;
    }

    private String parseLinkWithTextFromHtml(String htmlMessage, String text) throws Exception {
        String aTagRegex = "<a\\s+[^>]*href=\"([^\"]*)\"[^>]*>(?:<a[^>]*>)*" + text + "(?:</a>)*</a>";
        String urlRegex = "(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        try {
            Matcher aTagMatcher = Pattern.compile(aTagRegex).matcher(htmlMessage);
            if (aTagMatcher.find()) {
                Matcher urlMatcher = Pattern.compile(urlRegex).matcher(aTagMatcher.group(1));
                if (urlMatcher.find()) {
                    return aTagMatcher.group(1).substring(urlMatcher.start(0), urlMatcher.end(0));
                }
                throw new Exception("No Url exists for link with Text " + text);
            }
        }
        catch (Exception e) {
            throw new Exception("URL Parsing Failed - " + e.getMessage());
        }
        return null;
    }

    private List<String> getLinksFromContent(String regex) throws Exception {
        List<String> parsedLink = null;
        if (this.getHtmlMessage() != null) {
            parsedLink = this.extractLinks(regex, this.getHtmlMessage());
        }
        assert (parsedLink != null);
        return parsedLink;
    }

    private List<String> extractLinks(String regex, String message) throws Exception {
        if (regex == null) {
            regex = "\\b(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        }
        try {
            Pattern pattern = Pattern.compile(regex, 2);
            Matcher matcher = pattern.matcher(message);
            ArrayList<String> parsedURLs = new ArrayList<String>();
            while (matcher.find()) {
                parsedURLs.add(message.substring(matcher.start(0), matcher.end(0)));
            }
            if (parsedURLs.size() <= 0) {
                throw new Exception(" No URL found with matching condition in the email message.");
            }
            return parsedURLs;
        }
        catch (Exception e) {
            throw new Exception(" : URLs extraction failed - " + e.getMessage());
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSentTo() {
        return this.sentTo;
    }

    public String getTextMessage() {
        return this.textMessage;
    }

    public String getHtmlMessage() {
        return this.htmlMessage;
    }

    public String getReceivedFrom() {
        return this.receivedFrom;
    }

    public Map<String, String> getAttachmentUrls() {
        return this.attachmentUrls;
    }

    public Timestamp getReceivedAt() {
        return this.receivedAt;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setSentTo(String sentTo) {
        this.sentTo = sentTo;
    }

    public void setTextMessage(String textMessage) {
        this.textMessage = textMessage;
    }

    public void setHtmlMessage(String htmlMessage) {
        this.htmlMessage = htmlMessage;
    }

    public void setReceivedFrom(String receivedFrom) {
        this.receivedFrom = receivedFrom;
    }

    public void setAttachmentUrls(Map<String, String> attachmentUrls) {
        this.attachmentUrls = attachmentUrls;
    }

    public void setReceivedAt(Timestamp receivedAt) {
        this.receivedAt = receivedAt;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailboxMessage)) {
            return false;
        }
        MailboxMessage other = (MailboxMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$sentTo = this.getSentTo();
        String other$sentTo = other.getSentTo();
        if (this$sentTo == null ? other$sentTo != null : !this$sentTo.equals(other$sentTo)) {
            return false;
        }
        String this$textMessage = this.getTextMessage();
        String other$textMessage = other.getTextMessage();
        if (this$textMessage == null ? other$textMessage != null : !this$textMessage.equals(other$textMessage)) {
            return false;
        }
        String this$htmlMessage = this.getHtmlMessage();
        String other$htmlMessage = other.getHtmlMessage();
        if (this$htmlMessage == null ? other$htmlMessage != null : !this$htmlMessage.equals(other$htmlMessage)) {
            return false;
        }
        String this$receivedFrom = this.getReceivedFrom();
        String other$receivedFrom = other.getReceivedFrom();
        if (this$receivedFrom == null ? other$receivedFrom != null : !this$receivedFrom.equals(other$receivedFrom)) {
            return false;
        }
        Map<String, String> this$attachmentUrls = this.getAttachmentUrls();
        Map<String, String> other$attachmentUrls = other.getAttachmentUrls();
        if (this$attachmentUrls == null ? other$attachmentUrls != null : !((Object)this$attachmentUrls).equals(other$attachmentUrls)) {
            return false;
        }
        Timestamp this$receivedAt = this.getReceivedAt();
        Timestamp other$receivedAt = other.getReceivedAt();
        if (this$receivedAt == null ? other$receivedAt != null : !((Object)this$receivedAt).equals(other$receivedAt)) {
            return false;
        }
        String this$headers = this.getHeaders();
        String other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MailboxMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $sentTo = this.getSentTo();
        result = result * 59 + ($sentTo == null ? 43 : $sentTo.hashCode());
        String $textMessage = this.getTextMessage();
        result = result * 59 + ($textMessage == null ? 43 : $textMessage.hashCode());
        String $htmlMessage = this.getHtmlMessage();
        result = result * 59 + ($htmlMessage == null ? 43 : $htmlMessage.hashCode());
        String $receivedFrom = this.getReceivedFrom();
        result = result * 59 + ($receivedFrom == null ? 43 : $receivedFrom.hashCode());
        Map<String, String> $attachmentUrls = this.getAttachmentUrls();
        result = result * 59 + ($attachmentUrls == null ? 43 : ((Object)$attachmentUrls).hashCode());
        Timestamp $receivedAt = this.getReceivedAt();
        result = result * 59 + ($receivedAt == null ? 43 : ((Object)$receivedAt).hashCode());
        String $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        return result;
    }

    public String toString() {
        return "MailboxMessage(subject=" + this.getSubject() + ", sentTo=" + this.getSentTo() + ", textMessage=" + this.getTextMessage() + ", htmlMessage=" + this.getHtmlMessage() + ", receivedFrom=" + this.getReceivedFrom() + ", attachmentUrls=" + String.valueOf(this.getAttachmentUrls()) + ", receivedAt=" + String.valueOf(this.getReceivedAt()) + ", headers=" + this.getHeaders() + ")";
    }
}

