/*
 * Decompiled with CFR 0.152.
 */
package com.testsigma.sdk;

import com.testsigma.sdk.Logger;
import com.testsigma.sdk.TestData;
import org.apache.commons.lang3.StringUtils;

public abstract class TestDataFunction {
    private static final int MESSAGE_MAX_SIZE = 500;
    protected String errorMessage;
    protected String successMessage;
    protected Logger logger = new Logger(new StringBuilder());
    private StringBuffer loggedMessages = new StringBuffer();

    protected void setErrorMessage(String errorMessage) {
        this.errorMessage = StringUtils.abbreviate((String)errorMessage, (int)500);
    }

    protected void setSuccessMessage(String successMessage) {
        this.successMessage = StringUtils.abbreviate((String)successMessage, (int)500);
    }

    protected void log(Object message) {
        this.loggedMessages.append(message.toString()).append("<br>");
    }

    protected abstract TestData generate() throws Exception;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public StringBuffer getLoggedMessages() {
        return this.loggedMessages;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLoggedMessages(StringBuffer loggedMessages) {
        this.loggedMessages = loggedMessages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestDataFunction)) {
            return false;
        }
        TestDataFunction other = (TestDataFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$successMessage = this.getSuccessMessage();
        String other$successMessage = other.getSuccessMessage();
        if (this$successMessage == null ? other$successMessage != null : !this$successMessage.equals(other$successMessage)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !((Object)this$logger).equals(other$logger)) {
            return false;
        }
        StringBuffer this$loggedMessages = this.getLoggedMessages();
        StringBuffer other$loggedMessages = other.getLoggedMessages();
        return !(this$loggedMessages == null ? other$loggedMessages != null : !this$loggedMessages.equals(other$loggedMessages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestDataFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $successMessage = this.getSuccessMessage();
        result = result * 59 + ($successMessage == null ? 43 : $successMessage.hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : ((Object)$logger).hashCode());
        StringBuffer $loggedMessages = this.getLoggedMessages();
        result = result * 59 + ($loggedMessages == null ? 43 : $loggedMessages.hashCode());
        return result;
    }

    public String toString() {
        return "TestDataFunction(errorMessage=" + this.getErrorMessage() + ", successMessage=" + this.getSuccessMessage() + ", logger=" + String.valueOf(this.getLogger()) + ", loggedMessages=" + String.valueOf(this.getLoggedMessages()) + ")";
    }
}

