/*
 * Decompiled with CFR 0.152.
 */
package com.testsigma.sdk;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class Logger {
    private final StringBuilder value;
    private static final String DEBUG = "DEBUG";
    private static final String INFO = "INFO";
    private static final String WARN = "WARN";
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");

    public void debug(String message) {
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[2];
        this.setLogMessage(DEBUG, message, traceElement);
    }

    public void info(String message) {
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[2];
        this.setLogMessage(INFO, message, traceElement);
    }

    public void warn(String message) {
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[2];
        this.setLogMessage(WARN, message, traceElement);
    }

    public void setLogMessage(String methodName, String message, StackTraceElement traceElement) {
        String className = traceElement.toString().split("\\(")[0];
        int lineNo = traceElement.getLineNumber();
        LocalDateTime currentTime = LocalDateTime.now();
        this.value.append(dtf.format(currentTime)).append(" ");
        this.value.append(methodName).append(" ");
        this.value.append(className).append(":").append(lineNo).append(" ");
        this.value.append(message).append("\n");
    }

    public Logger(StringBuilder value) {
        this.value = value;
    }

    public StringBuilder getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Logger)) {
            return false;
        }
        Logger other = (Logger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringBuilder this$value = this.getValue();
        StringBuilder other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Logger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringBuilder $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Logger(value=" + this.getValue() + ")";
    }
}

