/*
 * Decompiled with CFR 0.152.
 */
package com.testsigma.sdk.runners;

import com.testsigma.sdk.Action;
import com.testsigma.sdk.DriverAction;
import com.testsigma.sdk.Element;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.openqa.selenium.WebDriver;

public class ActionRunner {
    private final WebDriver driver;

    public ActionRunner(WebDriver driver) throws Exception {
        if (driver == null) {
            throw new Exception("Please provide a valid WebDriver object");
        }
        this.driver = driver;
    }

    public void run(DriverAction actionObject) throws Exception {
        Field[] declaredFields;
        actionObject.setDriver(this.driver);
        ArrayList<Field> elementFields = new ArrayList<Field>();
        for (Field declaredField : declaredFields = actionObject.getClass().getDeclaredFields()) {
            if (!declaredField.isAnnotationPresent(com.testsigma.sdk.annotation.Element.class)) continue;
            declaredField.setAccessible(true);
            elementFields.add(declaredField);
        }
        this.setDriverToElement(actionObject, elementFields);
        Method execute = actionObject.getClass().getMethod("execute", new Class[0]);
        execute.setAccessible(true);
        execute.invoke((Object)actionObject, new Object[0]);
    }

    private void setDriverToElement(Action actionObject, List<Field> elementFields) throws Exception {
        for (Field elementField : elementFields) {
            Element elementObj = (Element)elementField.get(actionObject);
            elementObj.setDriver(this.driver);
            FieldUtils.writeField((Field)elementField, (Object)actionObject, (Object)elementObj, (boolean)true);
        }
    }

    public void quit() {
        this.driver.quit();
    }
}

