/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.auth;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;

import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.AccessTokenRequestParams;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.pkce.PKCE;

import org.apache.commons.lang3.StringUtils;


public class TwitterOAuth20Service extends OAuth20Service {

  public TwitterOAuth20Service(
    String apiKey,
    String apiSecret,
    String callback,
    String defaultScope
  ) {
    super(TwitterOAuth20Api.instance(), apiKey, apiSecret, callback, defaultScope, "code", null, null,
        null, null);
  }

  public TwitterOAuth20Service(String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
    super(TwitterOAuth20Api.instance(), apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
  }

  public TwitterOAuth20Service createService(String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
    return new TwitterOAuth20Service(apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
  }

  public String getAuthorizationUrl(PKCE pkce, String state) {
    checkApiKeyAndSecret();
    if(StringUtils.isEmpty(this.getCallback())) {
      throw new IllegalArgumentException("The callback cannot be null or empty");
    }
    if(StringUtils.isEmpty(this.getDefaultScope())) {
      throw new IllegalArgumentException("The scope cannot be null or empty");
    }
    return this.createAuthorizationUrlBuilder().pkce(pkce).state(state).build();
  }

  public OAuth2AccessToken getAccessToken(
        PKCE pkce, String code
  ) throws IOException, ExecutionException, InterruptedException {
    checkApiKeyAndSecret();
    AccessTokenRequestParams params = AccessTokenRequestParams.create(code);
    params = params.pkceCodeVerifier(pkce.getCodeVerifier());
    return getAccessToken(params);
  }

  private void checkApiKeyAndSecret() {
    if(StringUtils.isEmpty(this.getApiKey())) {
      throw new IllegalArgumentException("The TWITTER_OAUTH2_CLIENT_ID cannot be null or empty");
    }
    if(StringUtils.isEmpty(this.getApiSecret())) {
      throw new IllegalArgumentException("The TWITTER_OAUTH2_CLIENT_SECRET cannot be null or empty");
    }
  }
}
