/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.model.ClientDisconnectedProblem;
import com.twitter.clientlib.model.ClientForbiddenProblem;
import com.twitter.clientlib.model.ConflictProblem;
import com.twitter.clientlib.model.ConnectionExceptionProblem;
import com.twitter.clientlib.model.DisallowedResourceProblem;
import com.twitter.clientlib.model.DuplicateRuleProblem;
import com.twitter.clientlib.model.FieldUnauthorizedProblem;
import com.twitter.clientlib.model.GenericProblem;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.InvalidRuleProblem;
import com.twitter.clientlib.model.NonCompliantRulesProblem;
import com.twitter.clientlib.model.OperationalDisconnectProblem;
import com.twitter.clientlib.model.OperationalDisconnectProblemAllOf;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.ResourceNotFoundProblem;
import com.twitter.clientlib.model.ResourceUnauthorizedProblem;
import com.twitter.clientlib.model.ResourceUnavailableProblem;
import com.twitter.clientlib.model.RulesCapProblem;
import com.twitter.clientlib.model.UnsupportedAuthenticationProblem;
import com.twitter.clientlib.model.UsageCapExceededProblem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.twitter.clientlib.JSON;

/**
 * You have been disconnected for operational reasons.
 */
@ApiModel(description = "You have been disconnected for operational reasons.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class OperationalDisconnectProblem extends Problem {
  /**
   * Gets or Sets disconnectType
   */
  @JsonAdapter(DisconnectTypeEnum.Adapter.class)
  public enum DisconnectTypeEnum {
    OPERATIONALDISCONNECT("OperationalDisconnect"),
    
    UPSTREAMOPERATIONALDISCONNECT("UpstreamOperationalDisconnect"),
    
    FORCEDISCONNECT("ForceDisconnect"),
    
    UPSTREAMUNCLEANDISCONNECT("UpstreamUncleanDisconnect"),
    
    SLOWREADER("SlowReader"),
    
    INTERNALERROR("InternalError"),
    
    CLIENTAPPLICATIONSTATEDEGRADED("ClientApplicationStateDegraded"),
    
    INVALIDRULES("InvalidRules");

    private String value;

    DisconnectTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DisconnectTypeEnum fromValue(String value) {
      for (DisconnectTypeEnum b : DisconnectTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DisconnectTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DisconnectTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DisconnectTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DisconnectTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DISCONNECT_TYPE = "disconnect_type";
  @SerializedName(SERIALIZED_NAME_DISCONNECT_TYPE)
  private DisconnectTypeEnum disconnectType;

  public OperationalDisconnectProblem() { 
    this.type = this.getClass().getSimpleName();
  }

  public OperationalDisconnectProblem disconnectType(DisconnectTypeEnum disconnectType) {
    
    this.disconnectType = disconnectType;
    return this;
  }

   /**
   * Get disconnectType
   * @return disconnectType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public DisconnectTypeEnum getDisconnectType() {
    return disconnectType;
  }


  public void setDisconnectType(DisconnectTypeEnum disconnectType) {
    this.disconnectType = disconnectType;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationalDisconnectProblem operationalDisconnectProblem = (OperationalDisconnectProblem) o;
    return Objects.equals(this.disconnectType, operationalDisconnectProblem.disconnectType) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(disconnectType, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationalDisconnectProblem {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    disconnectType: ").append(toIndentedString(disconnectType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("detail");
    openapiFields.add("status");
    openapiFields.add("title");
    openapiFields.add("type");
    openapiFields.add("disconnect_type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("title");
    openapiRequiredFields.add("type");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to OperationalDisconnectProblem
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
     // if (jsonObj == null) {
     //   if (OperationalDisconnectProblem.openapiRequiredFields.isEmpty()) {
     //     return;
     //   } else { // has required fields
     //     throw new IllegalArgumentException(String.format("The required field(s) %s in OperationalDisconnectProblem is not found in the empty JSON string", OperationalDisconnectProblem.openapiRequiredFields.toString()));
     //   }
     // }


      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : OperationalDisconnectProblem.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!OperationalDisconnectProblem.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'OperationalDisconnectProblem' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<OperationalDisconnectProblem> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(OperationalDisconnectProblem.class));

       return (TypeAdapter<T>) new TypeAdapter<OperationalDisconnectProblem>() {
           @Override
           public void write(JsonWriter out, OperationalDisconnectProblem value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public OperationalDisconnectProblem read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of OperationalDisconnectProblem given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of OperationalDisconnectProblem
  * @throws IOException if the JSON string is invalid with respect to OperationalDisconnectProblem
  */
  public static OperationalDisconnectProblem fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, OperationalDisconnectProblem.class);
  }

 /**
  * Convert an instance of OperationalDisconnectProblem to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

