/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.integration.ApiTester;
import com.twitter.clientlib.model.CreateComplianceJobRequest;
import com.twitter.clientlib.model.CreateComplianceJobResponse;
import com.twitter.clientlib.model.Get2ComplianceJobsIdResponse;
import com.twitter.clientlib.model.InvalidRequestProblem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ApiComplianceTester
extends ApiTester {
    String complianceJobByID = "1537616980307456001";
    String complianceJobByIDNotFound = "998837616980307456099";

    @BeforeAll
    public void init() {
        this.initApiInstanceBearer();
    }

    public CreateComplianceJobResponse createCompliance() throws ApiException {
        CreateComplianceJobRequest req = new CreateComplianceJobRequest();
        req.setType(CreateComplianceJobRequest.TypeEnum.TWEETS);
        return this.apiInstance.compliance().createBatchComplianceJob(req).execute();
    }

    @Test
    public void getBatchComplianceJobJobTest() throws ApiException {
        String id = this.createCompliance().getData().getId();
        Get2ComplianceJobsIdResponse result = this.apiInstance.compliance().getBatchComplianceJob(id).execute();
        this.checkErrors(false, result.getErrors());
        this.checkComplianceJobData(result.getData());
    }

    @Test
    public void getBatchComplianceJobErrorTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> {
            Get2ComplianceJobsIdResponse result = this.apiInstance.compliance().getBatchComplianceJob(this.complianceJobByIDNotFound).execute();
        });
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [" + this.complianceJobByIDNotFound + "] does not match ^[0-9]{1,19}$", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listBatchComplianceJobsErrorTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.compliance().listBatchComplianceJobs("DUMMY").execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `type` query parameter value [DUMMY] is not one of [tweets,users]", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void createBatchComplianceJobTest() throws ApiException {
        CreateComplianceJobResponse result = this.createCompliance();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertNotNull((Object)result.getData().getId());
        Assertions.assertNotNull((Object)result.getData().getType());
    }
}

