/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.integration.ApiTester;
import com.twitter.clientlib.model.Get2ListsIdMembersResponse;
import com.twitter.clientlib.model.Get2ListsIdResponse;
import com.twitter.clientlib.model.Get2ListsIdTweetsResponse;
import com.twitter.clientlib.model.Get2UsersIdFollowedListsResponse;
import com.twitter.clientlib.model.Get2UsersIdFollowersResponse;
import com.twitter.clientlib.model.Get2UsersIdListMembershipsResponse;
import com.twitter.clientlib.model.Get2UsersIdOwnedListsResponse;
import com.twitter.clientlib.model.Get2UsersIdPinnedListsResponse;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.ListAddUserRequest;
import com.twitter.clientlib.model.ListCreateRequest;
import com.twitter.clientlib.model.ListCreateResponse;
import com.twitter.clientlib.model.ListDeleteResponse;
import com.twitter.clientlib.model.ListFollowedRequest;
import com.twitter.clientlib.model.ListFollowedResponse;
import com.twitter.clientlib.model.ListMutateResponse;
import com.twitter.clientlib.model.ListPinnedRequest;
import com.twitter.clientlib.model.ListPinnedResponse;
import com.twitter.clientlib.model.ListUnpinResponse;
import com.twitter.clientlib.model.ListUpdateRequest;
import com.twitter.clientlib.model.ListUpdateResponse;
import com.twitter.clientlib.model.ModelList;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.Tweet;
import com.twitter.clientlib.model.User;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ApiListsTester
extends ApiTester {
    private final String listId = "84839422";
    private final String listIdNotFound = "11111112";
    private final String listOwnerUserId = "2244994945";
    private final Set<String> listFields = new HashSet<String>(Arrays.asList("owner_id", "follower_count", "created_at", "description"));
    private final Set<String> listsExpansions = new HashSet<String>(Collections.singletonList("owner_id"));
    private final Set<String> expansionsPinnedTweetId = new HashSet<String>(Collections.singletonList("pinned_tweet_id"));

    public ListCreateResponse listIdCreate() throws ApiException {
        ListCreateRequest request = new ListCreateRequest();
        request.setName("MyList");
        request.setPrivate(Boolean.valueOf(true));
        request.setDescription("MyList description");
        return this.apiInstance.lists().listIdCreate().listCreateRequest(request).execute();
    }

    private ListDeleteResponse deleteList(String id) throws ApiException {
        return this.apiInstance.lists().listIdDelete(id).execute();
    }

    @BeforeAll
    public void init() {
        this.initApiInstance();
    }

    @Test
    public void listIdGetTest() throws ApiException {
        Get2ListsIdResponse result = this.apiInstance.lists().listIdGet("84839422").listFields(this.listFields).expansions(this.listsExpansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        this.checkListData(result.getData());
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
        this.checkUserData((User)result.getIncludes().getUsers().get(0));
    }

    @Test
    public void listIdGetListNotFoundTest() throws ApiException {
        Get2ListsIdResponse result = this.apiInstance.lists().listIdGet("11111112").listFields(this.listFields).expansions(this.listsExpansions).userFields(this.userFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "11111112", "Not Found Error", "id");
    }

    @Test
    public void listUserOwnedListsTest() throws ApiException {
        Get2UsersIdOwnedListsResponse result = this.apiInstance.lists().listUserOwnedLists("2244994945").maxResults(this.maxResults).paginationToken(null).listFields(this.listFields).expansions(this.listsExpansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkListData((ModelList)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
        this.checkUserData((User)result.getIncludes().getUsers().get(0));
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void listUserOwnedListsListNotFoundTest() throws ApiException {
        Get2UsersIdOwnedListsResponse result = this.apiInstance.lists().listUserOwnedLists("9999999999999").maxResults(this.maxResults).paginationToken(null).listFields(this.listFields).expansions(this.listsExpansions).userFields(this.userFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void listIdCreateTest() throws ApiException {
        ListCreateResponse result = null;
        try {
            result = this.listIdCreate();
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertNotNull((Object)result.getData().getId());
            Assertions.assertNotNull((Object)result.getData().getName());
        }
        finally {
            if (result != null) {
                this.deleteList(result.getData().getId());
            }
        }
    }

    @Test
    public void listIdCreateEmptyValuesTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listIdCreate().listCreateRequest(null).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `name` field in the request body can not be empty", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listIdUpdateTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListUpdateRequest request = new ListUpdateRequest();
            request.setName("MyNewList Updated");
            request.setDescription("updated description");
            ListUpdateResponse result = this.apiInstance.lists().listIdUpdate(list.getData().getId()).listUpdateRequest(request).execute();
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertTrue((boolean)result.getData().getUpdated());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    @Test
    public void listIdUpdateListNotFoundTest() throws ApiException {
        ListUpdateRequest request = new ListUpdateRequest();
        request.setName("MyNewList Updated");
        request.setDescription("updated description");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listIdUpdate("11111112").listUpdateRequest(request).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot update a List that does not exist.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listIdUpdateNullValuesTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListUpdateResponse result = this.apiInstance.lists().listIdUpdate(list.getData().getId()).listUpdateRequest(null).execute();
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertTrue((boolean)result.getData().getUpdated());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    @Test
    public void listIdUpdateListNullTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListUpdateResponse result = this.apiInstance.lists().listIdUpdate(list.getData().getId()).listUpdateRequest(null).execute();
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertTrue((boolean)result.getData().getUpdated());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    @Test
    public void listIdDeleteTest() throws ApiException {
        ListCreateResponse list = this.listIdCreate();
        ListDeleteResponse result = this.deleteList(list.getData().getId());
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getDeleted());
    }

    @Test
    public void listIdDeleteListNotFoundTest() throws ApiException {
        ListDeleteResponse result = this.deleteList("11111112");
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getDeleted());
    }

    @Test
    public void listIdDeleteListNotMineTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.deleteList("84839422"));
        this.checkGenericProblem(exception.getErrorObject().getProblem(), "You are not allowed to delete this List.", "Forbidden", 403);
    }

    @Test
    public void listsIdTweetsTest() throws ApiException {
        Get2ListsIdTweetsResponse result = this.apiInstance.tweets().listsIdTweets("84839422").maxResults(this.maxResults).paginationToken(null).tweetFields(this.tweetFields).expansions(this.expansions).mediaFields(null).pollFields(null).userFields(this.userFields).placeFields(null).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkTweetData((Tweet)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
        this.checkUserData((User)result.getIncludes().getUsers().get(0));
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void listsIdTweetsListNotFoundTest() throws ApiException {
        Get2ListsIdTweetsResponse result = this.apiInstance.tweets().listsIdTweets("11111112").maxResults(this.maxResults).paginationToken(null).tweetFields(this.tweetFields).expansions(this.expansions).mediaFields(null).pollFields(null).userFields(this.userFields).placeFields(null).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "11111112", "Not Found Error", "id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listAddMemberTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListAddUserRequest request = new ListAddUserRequest();
            request.setUserId(this.userId);
            ListMutateResponse result = this.apiInstance.lists().listAddMember(list.getData().getId()).listAddUserRequest(request).execute();
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertTrue((boolean)result.getData().getIsMember());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listAddMemberMemberNotFoundTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            String id = list.getData().getId();
            ListAddUserRequest request = new ListAddUserRequest();
            request.setUserId("9999999999999");
            ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listAddMember(id).listAddUserRequest(request).execute());
            this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot add a member that does not exist.", "Invalid Request", "One or more parameters to your request was invalid.");
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listRemoveMemberTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListAddUserRequest addRrequest = new ListAddUserRequest();
            addRrequest.setUserId(this.userId);
            this.apiInstance.lists().listAddMember(list.getData().getId()).listAddUserRequest(addRrequest).execute();
            ListMutateResponse result = this.apiInstance.lists().listRemoveMember(list.getData().getId(), this.userId).execute();
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertFalse((boolean)result.getData().getIsMember());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listRemoveMemberMemberNotFoundTest() throws ApiException {
        ListCreateResponse list = null;
        try {
            list = this.listIdCreate();
            ListAddUserRequest addRrequest = new ListAddUserRequest();
            addRrequest.setUserId(this.userId);
            this.apiInstance.lists().listAddMember(list.getData().getId()).listAddUserRequest(addRrequest).execute();
            ListMutateResponse result = this.apiInstance.lists().listRemoveMember(list.getData().getId(), "9999999999999").execute();
            this.checkErrors(false, result.getErrors());
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertFalse((boolean)result.getData().getIsMember());
        }
        finally {
            if (list != null) {
                this.deleteList(list.getData().getId());
            }
        }
    }

    @Test
    public void listGetMembersTest() throws ApiException {
        Get2ListsIdMembersResponse result = this.apiInstance.users().listGetMembers("84839422").maxResults(this.maxResults).paginationToken(null).userFields(this.userFields).expansions(this.expansionsPinnedTweetId).tweetFields(this.tweetFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getTweets());
        this.checkTweetData((Tweet)result.getIncludes().getTweets().get(0));
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void listGetMembersListNotFoundTest() throws ApiException {
        Get2ListsIdMembersResponse result = this.apiInstance.users().listGetMembers("11111112").maxResults(this.maxResults).paginationToken(null).userFields(this.userFields).expansions(this.expansionsPinnedTweetId).tweetFields(this.tweetFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "11111112", "Not Found Error", "id");
    }

    @Test
    public void getUserListMembershipsTest() throws ApiException {
        Get2UsersIdListMembershipsResponse result = this.apiInstance.lists().getUserListMemberships("2244994945").maxResults(this.maxResults).paginationToken(null).listFields(this.listFields).expansions(this.listsExpansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkListData((ModelList)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
        this.checkUserData((User)result.getIncludes().getUsers().get(0));
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getUserListMembershipsListNotFoundTest() throws ApiException {
        Get2UsersIdListMembershipsResponse result = this.apiInstance.lists().getUserListMemberships("9999999999999").maxResults(this.maxResults).paginationToken(null).listFields(this.listFields).expansions(this.listsExpansions).userFields(this.userFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void usersIdFollowersTest() throws ApiException {
        Get2UsersIdFollowersResponse result = this.apiInstance.users().usersIdFollowers("250831586").maxResults(this.maxResults).paginationToken(null).userFields(null).expansions(null).tweetFields(null).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void usersIdFollowersUserNotExistsTest() throws ApiException {
        Get2UsersIdFollowersResponse result = this.apiInstance.users().usersIdFollowers("9999999999999").maxResults(this.maxResults).paginationToken(null).userFields(null).expansions(null).tweetFields(null).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void userFollowedListsTest() throws ApiException {
        Get2UsersIdFollowedListsResponse result = this.apiInstance.lists().userFollowedLists("250831586").maxResults(this.maxResults).paginationToken(null).listFields(this.listFields).expansions(this.listsExpansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkListData((ModelList)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
        this.checkUserData((User)result.getIncludes().getUsers().get(0));
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void userFollowedListsUserNotFoundTest() throws ApiException {
        Get2UsersIdFollowedListsResponse result = this.apiInstance.lists().userFollowedLists("9999999999999").maxResults(this.maxResults).paginationToken(null).listFields(this.listFields).expansions(this.listsExpansions).userFields(this.userFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNull((Object)result.getMeta());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void listUserFollowTest() throws ApiException {
        ListFollowedRequest request = new ListFollowedRequest();
        request.setListId("84839422");
        ListFollowedResponse result = this.apiInstance.lists().listUserFollow(this.userId).listFollowedRequest(request).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getFollowing());
    }

    @Test
    public void listUserFollowListNotFoundTest() throws ApiException {
        ListFollowedRequest request = new ListFollowedRequest();
        request.setListId("11111112");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserFollow(this.userId).listFollowedRequest(request).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot follow a List that does not exist.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listUserFollowUserNotExistsTest() throws ApiException {
        ListFollowedRequest request = new ListFollowedRequest();
        request.setListId("84839422");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserFollow("9999999999999").listFollowedRequest(request).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listUserPinTest() throws ApiException {
        this.listUserFollowTest();
        ListPinnedRequest request = new ListPinnedRequest();
        request.setListId("84839422");
        ListPinnedResponse result = this.apiInstance.lists().listUserPin(request, this.userId).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getPinned());
        this.listUserUnfollowTest();
    }

    @Test
    public void listUserPinListNotFoundTest() throws ApiException {
        ListPinnedRequest request = new ListPinnedRequest();
        request.setListId("11111112");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserPin(request, this.userId).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot pin a List that does not exist.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listUserPinUserNotExistsTest() throws ApiException {
        ListPinnedRequest request = new ListPinnedRequest();
        request.setListId("84839422");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserPin(request, "9999999999999").execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listUserUnpinTest() throws ApiException {
        ListUnpinResponse result = this.apiInstance.lists().listUserUnpin(this.userId, "84839422").execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getPinned());
    }

    @Test
    public void listUserUnpinListNotFoundTest() throws ApiException {
        ListUnpinResponse result = this.apiInstance.lists().listUserUnpin(this.userId, "11111112").execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getPinned());
    }

    @Test
    public void listUserUnpinUserNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserUnpin("9999999999999", "84839422").execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listUserPinnedListsTest() throws ApiException {
        Get2UsersIdPinnedListsResponse result = this.apiInstance.lists().listUserPinnedLists(this.userId).userFields(this.userFields).listFields(this.listFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkModelListData((ModelList)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void listUserPinnedListsErrorTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserPinnedLists("9999999999999").userFields(this.userFields).listFields(this.listFields).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listUserUnfollowTest() throws ApiException {
        ListFollowedResponse result = this.apiInstance.lists().listUserUnfollow(this.userId, "84839422").execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertNotEquals((Object)Boolean.TRUE, (Object)result.getData().getFollowing());
    }

    @Test
    public void listUserUnfollowUserNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.lists().listUserUnfollow("9999999999999", "84839422").execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listUserUnfollowListNotFoundTest() throws ApiException {
        ListFollowedResponse result = this.apiInstance.lists().listUserUnfollow(this.userId, "11111112").execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getFollowing());
    }
}

