/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.google.gson.reflect.TypeToken;
import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.api.ApiCommon;
import com.twitter.clientlib.model.AddOrDeleteRulesRequest;
import com.twitter.clientlib.model.AddOrDeleteRulesResponse;
import com.twitter.clientlib.model.FilteredStreamingTweetResponse;
import com.twitter.clientlib.model.Get2ListsIdTweetsResponse;
import com.twitter.clientlib.model.Get2SpacesIdBuyersResponse;
import com.twitter.clientlib.model.Get2SpacesIdTweetsResponse;
import com.twitter.clientlib.model.Get2TweetsCountsAllResponse;
import com.twitter.clientlib.model.Get2TweetsCountsRecentResponse;
import com.twitter.clientlib.model.Get2TweetsIdQuoteTweetsResponse;
import com.twitter.clientlib.model.Get2TweetsIdResponse;
import com.twitter.clientlib.model.Get2TweetsResponse;
import com.twitter.clientlib.model.Get2TweetsSearchAllResponse;
import com.twitter.clientlib.model.Get2TweetsSearchRecentResponse;
import com.twitter.clientlib.model.Get2UsersIdLikedTweetsResponse;
import com.twitter.clientlib.model.Get2UsersIdMentionsResponse;
import com.twitter.clientlib.model.Get2UsersIdTimelinesReverseChronologicalResponse;
import com.twitter.clientlib.model.Get2UsersIdTweetsResponse;
import com.twitter.clientlib.model.ProblemOrError;
import com.twitter.clientlib.model.RulesLookupResponse;
import com.twitter.clientlib.model.StreamingTweetResponse;
import com.twitter.clientlib.model.TweetCreateRequest;
import com.twitter.clientlib.model.TweetCreateResponse;
import com.twitter.clientlib.model.TweetDeleteResponse;
import com.twitter.clientlib.model.TweetHideRequest;
import com.twitter.clientlib.model.TweetHideResponse;
import com.twitter.clientlib.model.UsersLikesCreateRequest;
import com.twitter.clientlib.model.UsersLikesCreateResponse;
import com.twitter.clientlib.model.UsersLikesDeleteResponse;
import com.twitter.clientlib.model.UsersRetweetsCreateRequest;
import com.twitter.clientlib.model.UsersRetweetsCreateResponse;
import com.twitter.clientlib.model.UsersRetweetsDeleteResponse;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import okhttp3.Call;

public class TweetsApi
extends ApiCommon {
    private Call addOrDeleteRulesCall(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        AddOrDeleteRulesRequest localVarPostBody = addOrDeleteRulesRequest;
        String localVarPath = "/2/tweets/search/stream/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dry_run", dryRun));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call addOrDeleteRulesValidateBeforeCall(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun, ApiCallback _callback) throws ApiException {
        if (addOrDeleteRulesRequest == null) {
            throw new ApiException("Missing the required parameter 'addOrDeleteRulesRequest' when calling addOrDeleteRules(Async)");
        }
        Call localVarCall = this.addOrDeleteRulesCall(addOrDeleteRulesRequest, dryRun, _callback);
        return localVarCall;
    }

    private ApiResponse<AddOrDeleteRulesResponse> addOrDeleteRulesWithHttpInfo(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun) throws ApiException {
        Call localVarCall = this.addOrDeleteRulesValidateBeforeCall(addOrDeleteRulesRequest, dryRun, null);
        try {
            Type localVarReturnType = new TypeToken<AddOrDeleteRulesResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call addOrDeleteRulesAsync(AddOrDeleteRulesRequest addOrDeleteRulesRequest, Boolean dryRun, ApiCallback<AddOrDeleteRulesResponse> _callback) throws ApiException {
        Call localVarCall = this.addOrDeleteRulesValidateBeforeCall(addOrDeleteRulesRequest, dryRun, _callback);
        Type localVarReturnType = new TypeToken<AddOrDeleteRulesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIaddOrDeleteRulesRequest addOrDeleteRules(AddOrDeleteRulesRequest addOrDeleteRulesRequest) {
        return new APIaddOrDeleteRulesRequest(addOrDeleteRulesRequest);
    }

    private Call createTweetCall(TweetCreateRequest tweetCreateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        TweetCreateRequest localVarPostBody = tweetCreateRequest;
        String localVarPath = "/2/tweets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call createTweetValidateBeforeCall(TweetCreateRequest tweetCreateRequest, ApiCallback _callback) throws ApiException {
        if (tweetCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'tweetCreateRequest' when calling createTweet(Async)");
        }
        Call localVarCall = this.createTweetCall(tweetCreateRequest, _callback);
        return localVarCall;
    }

    private ApiResponse<TweetCreateResponse> createTweetWithHttpInfo(TweetCreateRequest tweetCreateRequest) throws ApiException {
        Call localVarCall = this.createTweetValidateBeforeCall(tweetCreateRequest, null);
        try {
            Type localVarReturnType = new TypeToken<TweetCreateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call createTweetAsync(TweetCreateRequest tweetCreateRequest, ApiCallback<TweetCreateResponse> _callback) throws ApiException {
        Call localVarCall = this.createTweetValidateBeforeCall(tweetCreateRequest, _callback);
        Type localVarReturnType = new TypeToken<TweetCreateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateTweetRequest createTweet(TweetCreateRequest tweetCreateRequest) {
        return new APIcreateTweetRequest(tweetCreateRequest);
    }

    private Call deleteTweetByIdCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call deleteTweetByIdValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTweetById(Async)");
        }
        Call localVarCall = this.deleteTweetByIdCall(id, _callback);
        return localVarCall;
    }

    private ApiResponse<TweetDeleteResponse> deleteTweetByIdWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteTweetByIdValidateBeforeCall(id, null);
        try {
            Type localVarReturnType = new TypeToken<TweetDeleteResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call deleteTweetByIdAsync(String id, ApiCallback<TweetDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteTweetByIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<TweetDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteTweetByIdRequest deleteTweetById(String id) {
        return new APIdeleteTweetByIdRequest(id);
    }

    private Call findTweetByIdCall(String id, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findTweetByIdValidateBeforeCall(String id, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findTweetById(Async)");
        }
        Call localVarCall = this.findTweetByIdCall(id, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2TweetsIdResponse> findTweetByIdWithHttpInfo(String id, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.findTweetByIdValidateBeforeCall(id, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2TweetsIdResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call findTweetByIdAsync(String id, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2TweetsIdResponse> _callback) throws ApiException {
        Call localVarCall = this.findTweetByIdValidateBeforeCall(id, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2TweetsIdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindTweetByIdRequest findTweetById(String id) {
        return new APIfindTweetByIdRequest(id);
    }

    private Call findTweetsByIdCall(List<String> ids, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "ids", ids));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findTweetsByIdValidateBeforeCall(List<String> ids, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling findTweetsById(Async)");
        }
        Call localVarCall = this.findTweetsByIdCall(ids, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2TweetsResponse> findTweetsByIdWithHttpInfo(List<String> ids, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.findTweetsByIdValidateBeforeCall(ids, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2TweetsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call findTweetsByIdAsync(List<String> ids, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2TweetsResponse> _callback) throws ApiException {
        Call localVarCall = this.findTweetsByIdValidateBeforeCall(ids, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2TweetsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindTweetsByIdRequest findTweetsById(List<String> ids) {
        return new APIfindTweetsByIdRequest(ids);
    }

    private Call findTweetsThatQuoteATweetCall(String id, Integer maxResults, String paginationToken, Set<String> exclude, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/{id}/quote_tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (exclude != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "exclude", exclude));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findTweetsThatQuoteATweetValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> exclude, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findTweetsThatQuoteATweet(Async)");
        }
        Call localVarCall = this.findTweetsThatQuoteATweetCall(id, maxResults, paginationToken, exclude, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2TweetsIdQuoteTweetsResponse> findTweetsThatQuoteATweetWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> exclude, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.findTweetsThatQuoteATweetValidateBeforeCall(id, maxResults, paginationToken, exclude, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2TweetsIdQuoteTweetsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call findTweetsThatQuoteATweetAsync(String id, Integer maxResults, String paginationToken, Set<String> exclude, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2TweetsIdQuoteTweetsResponse> _callback) throws ApiException {
        Call localVarCall = this.findTweetsThatQuoteATweetValidateBeforeCall(id, maxResults, paginationToken, exclude, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2TweetsIdQuoteTweetsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindTweetsThatQuoteATweetRequest findTweetsThatQuoteATweet(String id) {
        return new APIfindTweetsThatQuoteATweetRequest(id);
    }

    private Call getRulesCall(List<String> ids, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/search/stream/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "ids", ids));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call getRulesValidateBeforeCall(List<String> ids, Integer maxResults, String paginationToken, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getRulesCall(ids, maxResults, paginationToken, _callback);
        return localVarCall;
    }

    private ApiResponse<RulesLookupResponse> getRulesWithHttpInfo(List<String> ids, Integer maxResults, String paginationToken) throws ApiException {
        Call localVarCall = this.getRulesValidateBeforeCall(ids, maxResults, paginationToken, null);
        try {
            Type localVarReturnType = new TypeToken<RulesLookupResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call getRulesAsync(List<String> ids, Integer maxResults, String paginationToken, ApiCallback<RulesLookupResponse> _callback) throws ApiException {
        Call localVarCall = this.getRulesValidateBeforeCall(ids, maxResults, paginationToken, _callback);
        Type localVarReturnType = new TypeToken<RulesLookupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetRulesRequest getRules() {
        return new APIgetRulesRequest();
    }

    private Call hideReplyByIdCall(TweetHideRequest tweetHideRequest, String tweetId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        TweetHideRequest localVarPostBody = tweetHideRequest;
        String localVarPath = "/2/tweets/{tweet_id}/hidden".replaceAll("\\{tweet_id\\}", this.localVarApiClient.escapeString(tweetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call hideReplyByIdValidateBeforeCall(TweetHideRequest tweetHideRequest, String tweetId, ApiCallback _callback) throws ApiException {
        if (tweetId == null) {
            throw new ApiException("Missing the required parameter 'tweetId' when calling hideReplyById(Async)");
        }
        Call localVarCall = this.hideReplyByIdCall(tweetHideRequest, tweetId, _callback);
        return localVarCall;
    }

    private ApiResponse<TweetHideResponse> hideReplyByIdWithHttpInfo(TweetHideRequest tweetHideRequest, String tweetId) throws ApiException {
        Call localVarCall = this.hideReplyByIdValidateBeforeCall(tweetHideRequest, tweetId, null);
        try {
            Type localVarReturnType = new TypeToken<TweetHideResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call hideReplyByIdAsync(TweetHideRequest tweetHideRequest, String tweetId, ApiCallback<TweetHideResponse> _callback) throws ApiException {
        Call localVarCall = this.hideReplyByIdValidateBeforeCall(tweetHideRequest, tweetId, _callback);
        Type localVarReturnType = new TypeToken<TweetHideResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIhideReplyByIdRequest hideReplyById(String tweetId) {
        return new APIhideReplyByIdRequest(tweetId);
    }

    private Call listsIdTweetsCall(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}/tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listsIdTweetsValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listsIdTweets(Async)");
        }
        Call localVarCall = this.listsIdTweetsCall(id, maxResults, paginationToken, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2ListsIdTweetsResponse> listsIdTweetsWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.listsIdTweetsValidateBeforeCall(id, maxResults, paginationToken, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2ListsIdTweetsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listsIdTweetsAsync(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2ListsIdTweetsResponse> _callback) throws ApiException {
        Call localVarCall = this.listsIdTweetsValidateBeforeCall(id, maxResults, paginationToken, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2ListsIdTweetsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistsIdTweetsRequest listsIdTweets(String id) {
        return new APIlistsIdTweetsRequest(id);
    }

    private Call sampleStreamCall(Integer backfillMinutes, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/sample/stream";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (backfillMinutes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("backfill_minutes", backfillMinutes));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call sampleStreamValidateBeforeCall(Integer backfillMinutes, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.sampleStreamCall(backfillMinutes, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private InputStream sampleStreamWithHttpInfo(Integer backfillMinutes, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.sampleStreamValidateBeforeCall(backfillMinutes, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<StreamingTweetResponse>(){}.getType();
            return this.localVarApiClient.executeStream(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call sampleStreamAsync(Integer backfillMinutes, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<StreamingTweetResponse> _callback) throws ApiException {
        Call localVarCall = this.sampleStreamValidateBeforeCall(backfillMinutes, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<StreamingTweetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsampleStreamRequest sampleStream() {
        return new APIsampleStreamRequest();
    }

    private Call searchStreamCall(Integer backfillMinutes, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/search/stream";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (backfillMinutes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("backfill_minutes", backfillMinutes));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call searchStreamValidateBeforeCall(Integer backfillMinutes, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.searchStreamCall(backfillMinutes, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private InputStream searchStreamWithHttpInfo(Integer backfillMinutes, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.searchStreamValidateBeforeCall(backfillMinutes, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<FilteredStreamingTweetResponse>(){}.getType();
            return this.localVarApiClient.executeStream(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call searchStreamAsync(Integer backfillMinutes, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<FilteredStreamingTweetResponse> _callback) throws ApiException {
        Call localVarCall = this.searchStreamValidateBeforeCall(backfillMinutes, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<FilteredStreamingTweetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsearchStreamRequest searchStream() {
        return new APIsearchStreamRequest();
    }

    private Call spaceBuyersCall(String id, String paginationToken, Integer maxResults, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/{id}/buyers".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call spaceBuyersValidateBeforeCall(String id, String paginationToken, Integer maxResults, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceBuyers(Async)");
        }
        Call localVarCall = this.spaceBuyersCall(id, paginationToken, maxResults, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2SpacesIdBuyersResponse> spaceBuyersWithHttpInfo(String id, String paginationToken, Integer maxResults, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.spaceBuyersValidateBeforeCall(id, paginationToken, maxResults, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2SpacesIdBuyersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call spaceBuyersAsync(String id, String paginationToken, Integer maxResults, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2SpacesIdBuyersResponse> _callback) throws ApiException {
        Call localVarCall = this.spaceBuyersValidateBeforeCall(id, paginationToken, maxResults, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2SpacesIdBuyersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIspaceBuyersRequest spaceBuyers(String id) {
        return new APIspaceBuyersRequest(id);
    }

    private Call spaceTweetsCall(String id, Integer maxResults, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/spaces/{id}/tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call spaceTweetsValidateBeforeCall(String id, Integer maxResults, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling spaceTweets(Async)");
        }
        Call localVarCall = this.spaceTweetsCall(id, maxResults, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2SpacesIdTweetsResponse> spaceTweetsWithHttpInfo(String id, Integer maxResults, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.spaceTweetsValidateBeforeCall(id, maxResults, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2SpacesIdTweetsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call spaceTweetsAsync(String id, Integer maxResults, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2SpacesIdTweetsResponse> _callback) throws ApiException {
        Call localVarCall = this.spaceTweetsValidateBeforeCall(id, maxResults, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2SpacesIdTweetsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIspaceTweetsRequest spaceTweets(String id) {
        return new APIspaceTweetsRequest(id);
    }

    private Call tweetCountsFullArchiveSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, String granularity, Set<String> searchCountFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/counts/all";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next_token", nextToken));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (granularity != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("granularity", granularity));
        }
        if (searchCountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "search_count.fields", searchCountFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetCountsFullArchiveSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, String granularity, Set<String> searchCountFields, ApiCallback _callback) throws ApiException {
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetCountsFullArchiveSearch(Async)");
        }
        Call localVarCall = this.tweetCountsFullArchiveSearchCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, searchCountFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2TweetsCountsAllResponse> tweetCountsFullArchiveSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, String granularity, Set<String> searchCountFields) throws ApiException {
        Call localVarCall = this.tweetCountsFullArchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, searchCountFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2TweetsCountsAllResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call tweetCountsFullArchiveSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, String granularity, Set<String> searchCountFields, ApiCallback<Get2TweetsCountsAllResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetCountsFullArchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, searchCountFields, _callback);
        Type localVarReturnType = new TypeToken<Get2TweetsCountsAllResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APItweetCountsFullArchiveSearchRequest tweetCountsFullArchiveSearch(String query) {
        return new APItweetCountsFullArchiveSearchRequest(query);
    }

    private Call tweetCountsRecentSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, String granularity, Set<String> searchCountFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/counts/recent";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next_token", nextToken));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (granularity != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("granularity", granularity));
        }
        if (searchCountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "search_count.fields", searchCountFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetCountsRecentSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, String granularity, Set<String> searchCountFields, ApiCallback _callback) throws ApiException {
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetCountsRecentSearch(Async)");
        }
        Call localVarCall = this.tweetCountsRecentSearchCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, searchCountFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2TweetsCountsRecentResponse> tweetCountsRecentSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, String granularity, Set<String> searchCountFields) throws ApiException {
        Call localVarCall = this.tweetCountsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, searchCountFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2TweetsCountsRecentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call tweetCountsRecentSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, String nextToken, String paginationToken, String granularity, Set<String> searchCountFields, ApiCallback<Get2TweetsCountsRecentResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetCountsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, nextToken, paginationToken, granularity, searchCountFields, _callback);
        Type localVarReturnType = new TypeToken<Get2TweetsCountsRecentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APItweetCountsRecentSearchRequest tweetCountsRecentSearch(String query) {
        return new APItweetCountsRecentSearchRequest(query);
    }

    private Call tweetsFullarchiveSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String nextToken, String paginationToken, String sortOrder, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/search/all";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next_token", nextToken));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_order", sortOrder));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetsFullarchiveSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String nextToken, String paginationToken, String sortOrder, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetsFullarchiveSearch(Async)");
        }
        Call localVarCall = this.tweetsFullarchiveSearchCall(query, startTime, endTime, sinceId, untilId, maxResults, nextToken, paginationToken, sortOrder, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2TweetsSearchAllResponse> tweetsFullarchiveSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String nextToken, String paginationToken, String sortOrder, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.tweetsFullarchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, nextToken, paginationToken, sortOrder, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2TweetsSearchAllResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call tweetsFullarchiveSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String nextToken, String paginationToken, String sortOrder, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2TweetsSearchAllResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetsFullarchiveSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, nextToken, paginationToken, sortOrder, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2TweetsSearchAllResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APItweetsFullarchiveSearchRequest tweetsFullarchiveSearch(String query) {
        return new APItweetsFullarchiveSearchRequest(query);
    }

    private Call tweetsRecentSearchCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String nextToken, String paginationToken, String sortOrder, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/search/recent";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("next_token", nextToken));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort_order", sortOrder));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetsRecentSearchValidateBeforeCall(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String nextToken, String paginationToken, String sortOrder, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling tweetsRecentSearch(Async)");
        }
        Call localVarCall = this.tweetsRecentSearchCall(query, startTime, endTime, sinceId, untilId, maxResults, nextToken, paginationToken, sortOrder, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2TweetsSearchRecentResponse> tweetsRecentSearchWithHttpInfo(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String nextToken, String paginationToken, String sortOrder, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.tweetsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, nextToken, paginationToken, sortOrder, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2TweetsSearchRecentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call tweetsRecentSearchAsync(String query, OffsetDateTime startTime, OffsetDateTime endTime, String sinceId, String untilId, Integer maxResults, String nextToken, String paginationToken, String sortOrder, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2TweetsSearchRecentResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetsRecentSearchValidateBeforeCall(query, startTime, endTime, sinceId, untilId, maxResults, nextToken, paginationToken, sortOrder, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2TweetsSearchRecentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APItweetsRecentSearchRequest tweetsRecentSearch(String query) {
        return new APItweetsRecentSearchRequest(query);
    }

    private Call usersIdLikeCall(UsersLikesCreateRequest usersLikesCreateRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        UsersLikesCreateRequest localVarPostBody = usersLikesCreateRequest;
        String localVarPath = "/2/users/{id}/likes".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdLikeValidateBeforeCall(UsersLikesCreateRequest usersLikesCreateRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdLike(Async)");
        }
        Call localVarCall = this.usersIdLikeCall(usersLikesCreateRequest, id, _callback);
        return localVarCall;
    }

    private ApiResponse<UsersLikesCreateResponse> usersIdLikeWithHttpInfo(UsersLikesCreateRequest usersLikesCreateRequest, String id) throws ApiException {
        Call localVarCall = this.usersIdLikeValidateBeforeCall(usersLikesCreateRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersLikesCreateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdLikeAsync(UsersLikesCreateRequest usersLikesCreateRequest, String id, ApiCallback<UsersLikesCreateResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdLikeValidateBeforeCall(usersLikesCreateRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersLikesCreateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdLikeRequest usersIdLike(String id) {
        return new APIusersIdLikeRequest(id);
    }

    private Call usersIdLikedTweetsCall(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/liked_tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdLikedTweetsValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdLikedTweets(Async)");
        }
        Call localVarCall = this.usersIdLikedTweetsCall(id, maxResults, paginationToken, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdLikedTweetsResponse> usersIdLikedTweetsWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.usersIdLikedTweetsValidateBeforeCall(id, maxResults, paginationToken, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdLikedTweetsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdLikedTweetsAsync(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2UsersIdLikedTweetsResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdLikedTweetsValidateBeforeCall(id, maxResults, paginationToken, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdLikedTweetsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdLikedTweetsRequest usersIdLikedTweets(String id) {
        return new APIusersIdLikedTweetsRequest(id);
    }

    private Call usersIdMentionsCall(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/mentions".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdMentionsValidateBeforeCall(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdMentions(Async)");
        }
        Call localVarCall = this.usersIdMentionsCall(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdMentionsResponse> usersIdMentionsWithHttpInfo(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.usersIdMentionsValidateBeforeCall(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdMentionsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdMentionsAsync(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2UsersIdMentionsResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdMentionsValidateBeforeCall(id, sinceId, untilId, maxResults, paginationToken, startTime, endTime, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdMentionsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdMentionsRequest usersIdMentions(String id) {
        return new APIusersIdMentionsRequest(id);
    }

    private Call usersIdRetweetsCall(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        UsersRetweetsCreateRequest localVarPostBody = usersRetweetsCreateRequest;
        String localVarPath = "/2/users/{id}/retweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdRetweetsValidateBeforeCall(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdRetweets(Async)");
        }
        Call localVarCall = this.usersIdRetweetsCall(usersRetweetsCreateRequest, id, _callback);
        return localVarCall;
    }

    private ApiResponse<UsersRetweetsCreateResponse> usersIdRetweetsWithHttpInfo(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id) throws ApiException {
        Call localVarCall = this.usersIdRetweetsValidateBeforeCall(usersRetweetsCreateRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersRetweetsCreateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdRetweetsAsync(UsersRetweetsCreateRequest usersRetweetsCreateRequest, String id, ApiCallback<UsersRetweetsCreateResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdRetweetsValidateBeforeCall(usersRetweetsCreateRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersRetweetsCreateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdRetweetsRequest usersIdRetweets(String id) {
        return new APIusersIdRetweetsRequest(id);
    }

    private Call usersIdTimelineCall(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, Set<String> exclude, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/timelines/reverse_chronological".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (exclude != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "exclude", exclude));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdTimelineValidateBeforeCall(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, Set<String> exclude, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdTimeline(Async)");
        }
        Call localVarCall = this.usersIdTimelineCall(id, sinceId, untilId, maxResults, paginationToken, exclude, startTime, endTime, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdTimelinesReverseChronologicalResponse> usersIdTimelineWithHttpInfo(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, Set<String> exclude, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.usersIdTimelineValidateBeforeCall(id, sinceId, untilId, maxResults, paginationToken, exclude, startTime, endTime, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdTimelinesReverseChronologicalResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdTimelineAsync(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, Set<String> exclude, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2UsersIdTimelinesReverseChronologicalResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdTimelineValidateBeforeCall(id, sinceId, untilId, maxResults, paginationToken, exclude, startTime, endTime, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdTimelinesReverseChronologicalResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdTimelineRequest usersIdTimeline(String id) {
        return new APIusersIdTimelineRequest(id);
    }

    private Call usersIdTweetsCall(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, Set<String> exclude, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/tweets".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sinceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since_id", sinceId));
        }
        if (untilId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until_id", untilId));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (exclude != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "exclude", exclude));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_time", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_time", endTime));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdTweetsValidateBeforeCall(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, Set<String> exclude, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdTweets(Async)");
        }
        Call localVarCall = this.usersIdTweetsCall(id, sinceId, untilId, maxResults, paginationToken, exclude, startTime, endTime, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdTweetsResponse> usersIdTweetsWithHttpInfo(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, Set<String> exclude, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.usersIdTweetsValidateBeforeCall(id, sinceId, untilId, maxResults, paginationToken, exclude, startTime, endTime, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdTweetsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdTweetsAsync(String id, String sinceId, String untilId, Integer maxResults, String paginationToken, Set<String> exclude, OffsetDateTime startTime, OffsetDateTime endTime, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2UsersIdTweetsResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdTweetsValidateBeforeCall(id, sinceId, untilId, maxResults, paginationToken, exclude, startTime, endTime, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdTweetsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdTweetsRequest usersIdTweets(String id) {
        return new APIusersIdTweetsRequest(id);
    }

    private Call usersIdUnlikeCall(String id, String tweetId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/likes/{tweet_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{tweet_id\\}", this.localVarApiClient.escapeString(tweetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdUnlikeValidateBeforeCall(String id, String tweetId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdUnlike(Async)");
        }
        if (tweetId == null) {
            throw new ApiException("Missing the required parameter 'tweetId' when calling usersIdUnlike(Async)");
        }
        Call localVarCall = this.usersIdUnlikeCall(id, tweetId, _callback);
        return localVarCall;
    }

    private ApiResponse<UsersLikesDeleteResponse> usersIdUnlikeWithHttpInfo(String id, String tweetId) throws ApiException {
        Call localVarCall = this.usersIdUnlikeValidateBeforeCall(id, tweetId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersLikesDeleteResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdUnlikeAsync(String id, String tweetId, ApiCallback<UsersLikesDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdUnlikeValidateBeforeCall(id, tweetId, _callback);
        Type localVarReturnType = new TypeToken<UsersLikesDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdUnlikeRequest usersIdUnlike(String id, String tweetId) {
        return new APIusersIdUnlikeRequest(id, tweetId);
    }

    private Call usersIdUnretweetsCall(String id, String sourceTweetId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/retweets/{source_tweet_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{source_tweet_id\\}", this.localVarApiClient.escapeString(sourceTweetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdUnretweetsValidateBeforeCall(String id, String sourceTweetId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdUnretweets(Async)");
        }
        if (sourceTweetId == null) {
            throw new ApiException("Missing the required parameter 'sourceTweetId' when calling usersIdUnretweets(Async)");
        }
        Call localVarCall = this.usersIdUnretweetsCall(id, sourceTweetId, _callback);
        return localVarCall;
    }

    private ApiResponse<UsersRetweetsDeleteResponse> usersIdUnretweetsWithHttpInfo(String id, String sourceTweetId) throws ApiException {
        Call localVarCall = this.usersIdUnretweetsValidateBeforeCall(id, sourceTweetId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersRetweetsDeleteResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdUnretweetsAsync(String id, String sourceTweetId, ApiCallback<UsersRetweetsDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdUnretweetsValidateBeforeCall(id, sourceTweetId, _callback);
        Type localVarReturnType = new TypeToken<UsersRetweetsDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdUnretweetsRequest usersIdUnretweets(String id, String sourceTweetId) {
        return new APIusersIdUnretweetsRequest(id, sourceTweetId);
    }

    public class APIusersIdUnretweetsRequest {
        private final String id;
        private final String sourceTweetId;

        private APIusersIdUnretweetsRequest(String id, String sourceTweetId) {
            this.id = id;
            this.sourceTweetId = sourceTweetId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.usersIdUnretweetsCall(this.id, this.sourceTweetId, _callback);
        }

        public UsersRetweetsDeleteResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.usersIdUnretweetsWithHttpInfo(this.id, this.sourceTweetId);
            return (UsersRetweetsDeleteResponse)localVarResp.getData();
        }

        public UsersRetweetsDeleteResponse execute(Integer retries) throws ApiException {
            UsersRetweetsDeleteResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<UsersRetweetsDeleteResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.usersIdUnretweetsWithHttpInfo(this.id, this.sourceTweetId);
        }

        public Call executeAsync(ApiCallback<UsersRetweetsDeleteResponse> _callback) throws ApiException {
            return TweetsApi.this.usersIdUnretweetsAsync(this.id, this.sourceTweetId, _callback);
        }
    }

    public class APIusersIdUnlikeRequest {
        private final String id;
        private final String tweetId;

        private APIusersIdUnlikeRequest(String id, String tweetId) {
            this.id = id;
            this.tweetId = tweetId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.usersIdUnlikeCall(this.id, this.tweetId, _callback);
        }

        public UsersLikesDeleteResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.usersIdUnlikeWithHttpInfo(this.id, this.tweetId);
            return (UsersLikesDeleteResponse)localVarResp.getData();
        }

        public UsersLikesDeleteResponse execute(Integer retries) throws ApiException {
            UsersLikesDeleteResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<UsersLikesDeleteResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.usersIdUnlikeWithHttpInfo(this.id, this.tweetId);
        }

        public Call executeAsync(ApiCallback<UsersLikesDeleteResponse> _callback) throws ApiException {
            return TweetsApi.this.usersIdUnlikeAsync(this.id, this.tweetId, _callback);
        }
    }

    public class APIusersIdTweetsRequest {
        private final String id;
        private String sinceId;
        private String untilId;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> exclude;
        private OffsetDateTime startTime;
        private OffsetDateTime endTime;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIusersIdTweetsRequest(String id) {
            this.id = id;
        }

        public APIusersIdTweetsRequest sinceId(String sinceId) {
            this.sinceId = sinceId;
            return this;
        }

        public APIusersIdTweetsRequest untilId(String untilId) {
            this.untilId = untilId;
            return this;
        }

        public APIusersIdTweetsRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIusersIdTweetsRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIusersIdTweetsRequest exclude(Set<String> exclude) {
            this.exclude = exclude;
            return this;
        }

        public APIusersIdTweetsRequest startTime(OffsetDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public APIusersIdTweetsRequest endTime(OffsetDateTime endTime) {
            this.endTime = endTime;
            return this;
        }

        public APIusersIdTweetsRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIusersIdTweetsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIusersIdTweetsRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIusersIdTweetsRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIusersIdTweetsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIusersIdTweetsRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.usersIdTweetsCall(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.exclude, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2UsersIdTweetsResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.usersIdTweetsWithHttpInfo(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.exclude, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2UsersIdTweetsResponse)localVarResp.getData();
        }

        public Get2UsersIdTweetsResponse execute(Integer retries) throws ApiException {
            Get2UsersIdTweetsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdTweetsResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.usersIdTweetsWithHttpInfo(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.exclude, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdTweetsResponse> _callback) throws ApiException {
            return TweetsApi.this.usersIdTweetsAsync(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.exclude, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIusersIdTimelineRequest {
        private final String id;
        private String sinceId;
        private String untilId;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> exclude;
        private OffsetDateTime startTime;
        private OffsetDateTime endTime;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIusersIdTimelineRequest(String id) {
            this.id = id;
        }

        public APIusersIdTimelineRequest sinceId(String sinceId) {
            this.sinceId = sinceId;
            return this;
        }

        public APIusersIdTimelineRequest untilId(String untilId) {
            this.untilId = untilId;
            return this;
        }

        public APIusersIdTimelineRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIusersIdTimelineRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIusersIdTimelineRequest exclude(Set<String> exclude) {
            this.exclude = exclude;
            return this;
        }

        public APIusersIdTimelineRequest startTime(OffsetDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public APIusersIdTimelineRequest endTime(OffsetDateTime endTime) {
            this.endTime = endTime;
            return this;
        }

        public APIusersIdTimelineRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIusersIdTimelineRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIusersIdTimelineRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIusersIdTimelineRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIusersIdTimelineRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIusersIdTimelineRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.usersIdTimelineCall(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.exclude, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2UsersIdTimelinesReverseChronologicalResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.usersIdTimelineWithHttpInfo(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.exclude, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2UsersIdTimelinesReverseChronologicalResponse)localVarResp.getData();
        }

        public Get2UsersIdTimelinesReverseChronologicalResponse execute(Integer retries) throws ApiException {
            Get2UsersIdTimelinesReverseChronologicalResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdTimelinesReverseChronologicalResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.usersIdTimelineWithHttpInfo(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.exclude, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdTimelinesReverseChronologicalResponse> _callback) throws ApiException {
            return TweetsApi.this.usersIdTimelineAsync(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.exclude, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIusersIdRetweetsRequest {
        private final String id;
        private UsersRetweetsCreateRequest usersRetweetsCreateRequest;

        private APIusersIdRetweetsRequest(String id) {
            this.id = id;
        }

        public APIusersIdRetweetsRequest usersRetweetsCreateRequest(UsersRetweetsCreateRequest usersRetweetsCreateRequest) {
            this.usersRetweetsCreateRequest = usersRetweetsCreateRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.usersIdRetweetsCall(this.usersRetweetsCreateRequest, this.id, _callback);
        }

        public UsersRetweetsCreateResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.usersIdRetweetsWithHttpInfo(this.usersRetweetsCreateRequest, this.id);
            return (UsersRetweetsCreateResponse)localVarResp.getData();
        }

        public UsersRetweetsCreateResponse execute(Integer retries) throws ApiException {
            UsersRetweetsCreateResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<UsersRetweetsCreateResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.usersIdRetweetsWithHttpInfo(this.usersRetweetsCreateRequest, this.id);
        }

        public Call executeAsync(ApiCallback<UsersRetweetsCreateResponse> _callback) throws ApiException {
            return TweetsApi.this.usersIdRetweetsAsync(this.usersRetweetsCreateRequest, this.id, _callback);
        }
    }

    public class APIusersIdMentionsRequest {
        private final String id;
        private String sinceId;
        private String untilId;
        private Integer maxResults;
        private String paginationToken;
        private OffsetDateTime startTime;
        private OffsetDateTime endTime;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIusersIdMentionsRequest(String id) {
            this.id = id;
        }

        public APIusersIdMentionsRequest sinceId(String sinceId) {
            this.sinceId = sinceId;
            return this;
        }

        public APIusersIdMentionsRequest untilId(String untilId) {
            this.untilId = untilId;
            return this;
        }

        public APIusersIdMentionsRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIusersIdMentionsRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIusersIdMentionsRequest startTime(OffsetDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public APIusersIdMentionsRequest endTime(OffsetDateTime endTime) {
            this.endTime = endTime;
            return this;
        }

        public APIusersIdMentionsRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIusersIdMentionsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIusersIdMentionsRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIusersIdMentionsRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIusersIdMentionsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIusersIdMentionsRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.usersIdMentionsCall(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2UsersIdMentionsResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.usersIdMentionsWithHttpInfo(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2UsersIdMentionsResponse)localVarResp.getData();
        }

        public Get2UsersIdMentionsResponse execute(Integer retries) throws ApiException {
            Get2UsersIdMentionsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdMentionsResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.usersIdMentionsWithHttpInfo(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdMentionsResponse> _callback) throws ApiException {
            return TweetsApi.this.usersIdMentionsAsync(this.id, this.sinceId, this.untilId, this.maxResults, this.paginationToken, this.startTime, this.endTime, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIusersIdLikedTweetsRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIusersIdLikedTweetsRequest(String id) {
            this.id = id;
        }

        public APIusersIdLikedTweetsRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIusersIdLikedTweetsRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIusersIdLikedTweetsRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIusersIdLikedTweetsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIusersIdLikedTweetsRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIusersIdLikedTweetsRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIusersIdLikedTweetsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIusersIdLikedTweetsRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.usersIdLikedTweetsCall(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2UsersIdLikedTweetsResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.usersIdLikedTweetsWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2UsersIdLikedTweetsResponse)localVarResp.getData();
        }

        public Get2UsersIdLikedTweetsResponse execute(Integer retries) throws ApiException {
            Get2UsersIdLikedTweetsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdLikedTweetsResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.usersIdLikedTweetsWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdLikedTweetsResponse> _callback) throws ApiException {
            return TweetsApi.this.usersIdLikedTweetsAsync(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIusersIdLikeRequest {
        private final String id;
        private UsersLikesCreateRequest usersLikesCreateRequest;

        private APIusersIdLikeRequest(String id) {
            this.id = id;
        }

        public APIusersIdLikeRequest usersLikesCreateRequest(UsersLikesCreateRequest usersLikesCreateRequest) {
            this.usersLikesCreateRequest = usersLikesCreateRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.usersIdLikeCall(this.usersLikesCreateRequest, this.id, _callback);
        }

        public UsersLikesCreateResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.usersIdLikeWithHttpInfo(this.usersLikesCreateRequest, this.id);
            return (UsersLikesCreateResponse)localVarResp.getData();
        }

        public UsersLikesCreateResponse execute(Integer retries) throws ApiException {
            UsersLikesCreateResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<UsersLikesCreateResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.usersIdLikeWithHttpInfo(this.usersLikesCreateRequest, this.id);
        }

        public Call executeAsync(ApiCallback<UsersLikesCreateResponse> _callback) throws ApiException {
            return TweetsApi.this.usersIdLikeAsync(this.usersLikesCreateRequest, this.id, _callback);
        }
    }

    public class APItweetsRecentSearchRequest {
        private final String query;
        private OffsetDateTime startTime;
        private OffsetDateTime endTime;
        private String sinceId;
        private String untilId;
        private Integer maxResults;
        private String nextToken;
        private String paginationToken;
        private String sortOrder;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APItweetsRecentSearchRequest(String query) {
            this.query = query;
        }

        public APItweetsRecentSearchRequest startTime(OffsetDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public APItweetsRecentSearchRequest endTime(OffsetDateTime endTime) {
            this.endTime = endTime;
            return this;
        }

        public APItweetsRecentSearchRequest sinceId(String sinceId) {
            this.sinceId = sinceId;
            return this;
        }

        public APItweetsRecentSearchRequest untilId(String untilId) {
            this.untilId = untilId;
            return this;
        }

        public APItweetsRecentSearchRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APItweetsRecentSearchRequest nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public APItweetsRecentSearchRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APItweetsRecentSearchRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APItweetsRecentSearchRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APItweetsRecentSearchRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APItweetsRecentSearchRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APItweetsRecentSearchRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APItweetsRecentSearchRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APItweetsRecentSearchRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.tweetsRecentSearchCall(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.maxResults, this.nextToken, this.paginationToken, this.sortOrder, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2TweetsSearchRecentResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.tweetsRecentSearchWithHttpInfo(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.maxResults, this.nextToken, this.paginationToken, this.sortOrder, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2TweetsSearchRecentResponse)localVarResp.getData();
        }

        public Get2TweetsSearchRecentResponse execute(Integer retries) throws ApiException {
            Get2TweetsSearchRecentResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2TweetsSearchRecentResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.tweetsRecentSearchWithHttpInfo(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.maxResults, this.nextToken, this.paginationToken, this.sortOrder, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2TweetsSearchRecentResponse> _callback) throws ApiException {
            return TweetsApi.this.tweetsRecentSearchAsync(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.maxResults, this.nextToken, this.paginationToken, this.sortOrder, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APItweetsFullarchiveSearchRequest {
        private final String query;
        private OffsetDateTime startTime;
        private OffsetDateTime endTime;
        private String sinceId;
        private String untilId;
        private Integer maxResults;
        private String nextToken;
        private String paginationToken;
        private String sortOrder;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APItweetsFullarchiveSearchRequest(String query) {
            this.query = query;
        }

        public APItweetsFullarchiveSearchRequest startTime(OffsetDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public APItweetsFullarchiveSearchRequest endTime(OffsetDateTime endTime) {
            this.endTime = endTime;
            return this;
        }

        public APItweetsFullarchiveSearchRequest sinceId(String sinceId) {
            this.sinceId = sinceId;
            return this;
        }

        public APItweetsFullarchiveSearchRequest untilId(String untilId) {
            this.untilId = untilId;
            return this;
        }

        public APItweetsFullarchiveSearchRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APItweetsFullarchiveSearchRequest nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public APItweetsFullarchiveSearchRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APItweetsFullarchiveSearchRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APItweetsFullarchiveSearchRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APItweetsFullarchiveSearchRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APItweetsFullarchiveSearchRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APItweetsFullarchiveSearchRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APItweetsFullarchiveSearchRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APItweetsFullarchiveSearchRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.tweetsFullarchiveSearchCall(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.maxResults, this.nextToken, this.paginationToken, this.sortOrder, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2TweetsSearchAllResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.tweetsFullarchiveSearchWithHttpInfo(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.maxResults, this.nextToken, this.paginationToken, this.sortOrder, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2TweetsSearchAllResponse)localVarResp.getData();
        }

        public Get2TweetsSearchAllResponse execute(Integer retries) throws ApiException {
            Get2TweetsSearchAllResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2TweetsSearchAllResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.tweetsFullarchiveSearchWithHttpInfo(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.maxResults, this.nextToken, this.paginationToken, this.sortOrder, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2TweetsSearchAllResponse> _callback) throws ApiException {
            return TweetsApi.this.tweetsFullarchiveSearchAsync(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.maxResults, this.nextToken, this.paginationToken, this.sortOrder, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APItweetCountsRecentSearchRequest {
        private final String query;
        private OffsetDateTime startTime;
        private OffsetDateTime endTime;
        private String sinceId;
        private String untilId;
        private String nextToken;
        private String paginationToken;
        private String granularity;
        private Set<String> searchCountFields;

        private APItweetCountsRecentSearchRequest(String query) {
            this.query = query;
        }

        public APItweetCountsRecentSearchRequest startTime(OffsetDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public APItweetCountsRecentSearchRequest endTime(OffsetDateTime endTime) {
            this.endTime = endTime;
            return this;
        }

        public APItweetCountsRecentSearchRequest sinceId(String sinceId) {
            this.sinceId = sinceId;
            return this;
        }

        public APItweetCountsRecentSearchRequest untilId(String untilId) {
            this.untilId = untilId;
            return this;
        }

        public APItweetCountsRecentSearchRequest nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public APItweetCountsRecentSearchRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APItweetCountsRecentSearchRequest granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        public APItweetCountsRecentSearchRequest searchCountFields(Set<String> searchCountFields) {
            this.searchCountFields = searchCountFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.tweetCountsRecentSearchCall(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.nextToken, this.paginationToken, this.granularity, this.searchCountFields, _callback);
        }

        public Get2TweetsCountsRecentResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.tweetCountsRecentSearchWithHttpInfo(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.nextToken, this.paginationToken, this.granularity, this.searchCountFields);
            return (Get2TweetsCountsRecentResponse)localVarResp.getData();
        }

        public Get2TweetsCountsRecentResponse execute(Integer retries) throws ApiException {
            Get2TweetsCountsRecentResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2TweetsCountsRecentResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.tweetCountsRecentSearchWithHttpInfo(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.nextToken, this.paginationToken, this.granularity, this.searchCountFields);
        }

        public Call executeAsync(ApiCallback<Get2TweetsCountsRecentResponse> _callback) throws ApiException {
            return TweetsApi.this.tweetCountsRecentSearchAsync(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.nextToken, this.paginationToken, this.granularity, this.searchCountFields, _callback);
        }
    }

    public class APItweetCountsFullArchiveSearchRequest {
        private final String query;
        private OffsetDateTime startTime;
        private OffsetDateTime endTime;
        private String sinceId;
        private String untilId;
        private String nextToken;
        private String paginationToken;
        private String granularity;
        private Set<String> searchCountFields;

        private APItweetCountsFullArchiveSearchRequest(String query) {
            this.query = query;
        }

        public APItweetCountsFullArchiveSearchRequest startTime(OffsetDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public APItweetCountsFullArchiveSearchRequest endTime(OffsetDateTime endTime) {
            this.endTime = endTime;
            return this;
        }

        public APItweetCountsFullArchiveSearchRequest sinceId(String sinceId) {
            this.sinceId = sinceId;
            return this;
        }

        public APItweetCountsFullArchiveSearchRequest untilId(String untilId) {
            this.untilId = untilId;
            return this;
        }

        public APItweetCountsFullArchiveSearchRequest nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public APItweetCountsFullArchiveSearchRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APItweetCountsFullArchiveSearchRequest granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        public APItweetCountsFullArchiveSearchRequest searchCountFields(Set<String> searchCountFields) {
            this.searchCountFields = searchCountFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.tweetCountsFullArchiveSearchCall(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.nextToken, this.paginationToken, this.granularity, this.searchCountFields, _callback);
        }

        public Get2TweetsCountsAllResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.tweetCountsFullArchiveSearchWithHttpInfo(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.nextToken, this.paginationToken, this.granularity, this.searchCountFields);
            return (Get2TweetsCountsAllResponse)localVarResp.getData();
        }

        public Get2TweetsCountsAllResponse execute(Integer retries) throws ApiException {
            Get2TweetsCountsAllResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2TweetsCountsAllResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.tweetCountsFullArchiveSearchWithHttpInfo(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.nextToken, this.paginationToken, this.granularity, this.searchCountFields);
        }

        public Call executeAsync(ApiCallback<Get2TweetsCountsAllResponse> _callback) throws ApiException {
            return TweetsApi.this.tweetCountsFullArchiveSearchAsync(this.query, this.startTime, this.endTime, this.sinceId, this.untilId, this.nextToken, this.paginationToken, this.granularity, this.searchCountFields, _callback);
        }
    }

    public class APIspaceTweetsRequest {
        private final String id;
        private Integer maxResults;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIspaceTweetsRequest(String id) {
            this.id = id;
        }

        public APIspaceTweetsRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIspaceTweetsRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIspaceTweetsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIspaceTweetsRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIspaceTweetsRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIspaceTweetsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIspaceTweetsRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.spaceTweetsCall(this.id, this.maxResults, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2SpacesIdTweetsResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.spaceTweetsWithHttpInfo(this.id, this.maxResults, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2SpacesIdTweetsResponse)localVarResp.getData();
        }

        public Get2SpacesIdTweetsResponse execute(Integer retries) throws ApiException {
            Get2SpacesIdTweetsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2SpacesIdTweetsResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.spaceTweetsWithHttpInfo(this.id, this.maxResults, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2SpacesIdTweetsResponse> _callback) throws ApiException {
            return TweetsApi.this.spaceTweetsAsync(this.id, this.maxResults, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIspaceBuyersRequest {
        private final String id;
        private String paginationToken;
        private Integer maxResults;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIspaceBuyersRequest(String id) {
            this.id = id;
        }

        public APIspaceBuyersRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIspaceBuyersRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIspaceBuyersRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIspaceBuyersRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIspaceBuyersRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.spaceBuyersCall(this.id, this.paginationToken, this.maxResults, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2SpacesIdBuyersResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.spaceBuyersWithHttpInfo(this.id, this.paginationToken, this.maxResults, this.userFields, this.expansions, this.tweetFields);
            return (Get2SpacesIdBuyersResponse)localVarResp.getData();
        }

        public Get2SpacesIdBuyersResponse execute(Integer retries) throws ApiException {
            Get2SpacesIdBuyersResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2SpacesIdBuyersResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.spaceBuyersWithHttpInfo(this.id, this.paginationToken, this.maxResults, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2SpacesIdBuyersResponse> _callback) throws ApiException {
            return TweetsApi.this.spaceBuyersAsync(this.id, this.paginationToken, this.maxResults, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIsearchStreamRequest {
        private Integer backfillMinutes;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIsearchStreamRequest() {
        }

        public APIsearchStreamRequest backfillMinutes(Integer backfillMinutes) {
            this.backfillMinutes = backfillMinutes;
            return this;
        }

        public APIsearchStreamRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIsearchStreamRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIsearchStreamRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIsearchStreamRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIsearchStreamRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIsearchStreamRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.searchStreamCall(this.backfillMinutes, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public InputStream execute() throws ApiException {
            return TweetsApi.this.searchStreamWithHttpInfo(this.backfillMinutes, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public InputStream execute(Integer retries) throws ApiException {
            InputStream localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public InputStream executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.searchStreamWithHttpInfo(this.backfillMinutes, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<FilteredStreamingTweetResponse> _callback) throws ApiException {
            return TweetsApi.this.searchStreamAsync(this.backfillMinutes, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIsampleStreamRequest {
        private Integer backfillMinutes;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIsampleStreamRequest() {
        }

        public APIsampleStreamRequest backfillMinutes(Integer backfillMinutes) {
            this.backfillMinutes = backfillMinutes;
            return this;
        }

        public APIsampleStreamRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIsampleStreamRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIsampleStreamRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIsampleStreamRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIsampleStreamRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIsampleStreamRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.sampleStreamCall(this.backfillMinutes, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public InputStream execute() throws ApiException {
            return TweetsApi.this.sampleStreamWithHttpInfo(this.backfillMinutes, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public InputStream execute(Integer retries) throws ApiException {
            InputStream localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public InputStream executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.sampleStreamWithHttpInfo(this.backfillMinutes, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<StreamingTweetResponse> _callback) throws ApiException {
            return TweetsApi.this.sampleStreamAsync(this.backfillMinutes, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIlistsIdTweetsRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIlistsIdTweetsRequest(String id) {
            this.id = id;
        }

        public APIlistsIdTweetsRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIlistsIdTweetsRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIlistsIdTweetsRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIlistsIdTweetsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIlistsIdTweetsRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIlistsIdTweetsRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIlistsIdTweetsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIlistsIdTweetsRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.listsIdTweetsCall(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2ListsIdTweetsResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.listsIdTweetsWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2ListsIdTweetsResponse)localVarResp.getData();
        }

        public Get2ListsIdTweetsResponse execute(Integer retries) throws ApiException {
            Get2ListsIdTweetsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2ListsIdTweetsResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.listsIdTweetsWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2ListsIdTweetsResponse> _callback) throws ApiException {
            return TweetsApi.this.listsIdTweetsAsync(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIhideReplyByIdRequest {
        private final String tweetId;
        private TweetHideRequest tweetHideRequest;

        private APIhideReplyByIdRequest(String tweetId) {
            this.tweetId = tweetId;
        }

        public APIhideReplyByIdRequest tweetHideRequest(TweetHideRequest tweetHideRequest) {
            this.tweetHideRequest = tweetHideRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.hideReplyByIdCall(this.tweetHideRequest, this.tweetId, _callback);
        }

        public TweetHideResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.hideReplyByIdWithHttpInfo(this.tweetHideRequest, this.tweetId);
            return (TweetHideResponse)localVarResp.getData();
        }

        public TweetHideResponse execute(Integer retries) throws ApiException {
            TweetHideResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<TweetHideResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.hideReplyByIdWithHttpInfo(this.tweetHideRequest, this.tweetId);
        }

        public Call executeAsync(ApiCallback<TweetHideResponse> _callback) throws ApiException {
            return TweetsApi.this.hideReplyByIdAsync(this.tweetHideRequest, this.tweetId, _callback);
        }
    }

    public class APIgetRulesRequest {
        private List<String> ids;
        private Integer maxResults;
        private String paginationToken;

        private APIgetRulesRequest() {
        }

        public APIgetRulesRequest ids(List<String> ids) {
            this.ids = ids;
            return this;
        }

        public APIgetRulesRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIgetRulesRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.getRulesCall(this.ids, this.maxResults, this.paginationToken, _callback);
        }

        public RulesLookupResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.getRulesWithHttpInfo(this.ids, this.maxResults, this.paginationToken);
            return (RulesLookupResponse)localVarResp.getData();
        }

        public RulesLookupResponse execute(Integer retries) throws ApiException {
            RulesLookupResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<RulesLookupResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.getRulesWithHttpInfo(this.ids, this.maxResults, this.paginationToken);
        }

        public Call executeAsync(ApiCallback<RulesLookupResponse> _callback) throws ApiException {
            return TweetsApi.this.getRulesAsync(this.ids, this.maxResults, this.paginationToken, _callback);
        }
    }

    public class APIfindTweetsThatQuoteATweetRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> exclude;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIfindTweetsThatQuoteATweetRequest(String id) {
            this.id = id;
        }

        public APIfindTweetsThatQuoteATweetRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIfindTweetsThatQuoteATweetRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIfindTweetsThatQuoteATweetRequest exclude(Set<String> exclude) {
            this.exclude = exclude;
            return this;
        }

        public APIfindTweetsThatQuoteATweetRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIfindTweetsThatQuoteATweetRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIfindTweetsThatQuoteATweetRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIfindTweetsThatQuoteATweetRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIfindTweetsThatQuoteATweetRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIfindTweetsThatQuoteATweetRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.findTweetsThatQuoteATweetCall(this.id, this.maxResults, this.paginationToken, this.exclude, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2TweetsIdQuoteTweetsResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.findTweetsThatQuoteATweetWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.exclude, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2TweetsIdQuoteTweetsResponse)localVarResp.getData();
        }

        public Get2TweetsIdQuoteTweetsResponse execute(Integer retries) throws ApiException {
            Get2TweetsIdQuoteTweetsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2TweetsIdQuoteTweetsResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.findTweetsThatQuoteATweetWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.exclude, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2TweetsIdQuoteTweetsResponse> _callback) throws ApiException {
            return TweetsApi.this.findTweetsThatQuoteATweetAsync(this.id, this.maxResults, this.paginationToken, this.exclude, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIfindTweetsByIdRequest {
        private final List<String> ids;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIfindTweetsByIdRequest(List<String> ids) {
            this.ids = ids;
        }

        public APIfindTweetsByIdRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIfindTweetsByIdRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIfindTweetsByIdRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIfindTweetsByIdRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIfindTweetsByIdRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIfindTweetsByIdRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.findTweetsByIdCall(this.ids, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2TweetsResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.findTweetsByIdWithHttpInfo(this.ids, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2TweetsResponse)localVarResp.getData();
        }

        public Get2TweetsResponse execute(Integer retries) throws ApiException {
            Get2TweetsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2TweetsResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.findTweetsByIdWithHttpInfo(this.ids, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2TweetsResponse> _callback) throws ApiException {
            return TweetsApi.this.findTweetsByIdAsync(this.ids, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIfindTweetByIdRequest {
        private final String id;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIfindTweetByIdRequest(String id) {
            this.id = id;
        }

        public APIfindTweetByIdRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIfindTweetByIdRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIfindTweetByIdRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIfindTweetByIdRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIfindTweetByIdRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIfindTweetByIdRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.findTweetByIdCall(this.id, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2TweetsIdResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.findTweetByIdWithHttpInfo(this.id, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2TweetsIdResponse)localVarResp.getData();
        }

        public Get2TweetsIdResponse execute(Integer retries) throws ApiException {
            Get2TweetsIdResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2TweetsIdResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.findTweetByIdWithHttpInfo(this.id, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2TweetsIdResponse> _callback) throws ApiException {
            return TweetsApi.this.findTweetByIdAsync(this.id, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }

    public class APIdeleteTweetByIdRequest {
        private final String id;

        private APIdeleteTweetByIdRequest(String id) {
            this.id = id;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.deleteTweetByIdCall(this.id, _callback);
        }

        public TweetDeleteResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.deleteTweetByIdWithHttpInfo(this.id);
            return (TweetDeleteResponse)localVarResp.getData();
        }

        public TweetDeleteResponse execute(Integer retries) throws ApiException {
            TweetDeleteResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<TweetDeleteResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.deleteTweetByIdWithHttpInfo(this.id);
        }

        public Call executeAsync(ApiCallback<TweetDeleteResponse> _callback) throws ApiException {
            return TweetsApi.this.deleteTweetByIdAsync(this.id, _callback);
        }
    }

    public class APIcreateTweetRequest {
        private final TweetCreateRequest tweetCreateRequest;

        private APIcreateTweetRequest(TweetCreateRequest tweetCreateRequest) {
            this.tweetCreateRequest = tweetCreateRequest;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.createTweetCall(this.tweetCreateRequest, _callback);
        }

        public TweetCreateResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.createTweetWithHttpInfo(this.tweetCreateRequest);
            return (TweetCreateResponse)localVarResp.getData();
        }

        public TweetCreateResponse execute(Integer retries) throws ApiException {
            TweetCreateResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<TweetCreateResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.createTweetWithHttpInfo(this.tweetCreateRequest);
        }

        public Call executeAsync(ApiCallback<TweetCreateResponse> _callback) throws ApiException {
            return TweetsApi.this.createTweetAsync(this.tweetCreateRequest, _callback);
        }
    }

    public class APIaddOrDeleteRulesRequest {
        private final AddOrDeleteRulesRequest addOrDeleteRulesRequest;
        private Boolean dryRun;

        private APIaddOrDeleteRulesRequest(AddOrDeleteRulesRequest addOrDeleteRulesRequest) {
            this.addOrDeleteRulesRequest = addOrDeleteRulesRequest;
        }

        public APIaddOrDeleteRulesRequest dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TweetsApi.this.addOrDeleteRulesCall(this.addOrDeleteRulesRequest, this.dryRun, _callback);
        }

        public AddOrDeleteRulesResponse execute() throws ApiException {
            ApiResponse localVarResp = TweetsApi.this.addOrDeleteRulesWithHttpInfo(this.addOrDeleteRulesRequest, this.dryRun);
            return (AddOrDeleteRulesResponse)localVarResp.getData();
        }

        public AddOrDeleteRulesResponse execute(Integer retries) throws ApiException {
            AddOrDeleteRulesResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (TweetsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<AddOrDeleteRulesResponse> executeWithHttpInfo() throws ApiException {
            return TweetsApi.this.addOrDeleteRulesWithHttpInfo(this.addOrDeleteRulesRequest, this.dryRun);
        }

        public Call executeAsync(ApiCallback<AddOrDeleteRulesResponse> _callback) throws ApiException {
            return TweetsApi.this.addOrDeleteRulesAsync(this.addOrDeleteRulesRequest, this.dryRun, _callback);
        }
    }
}

