/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.auth;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.AccessTokenRequestParams;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.pkce.PKCE;
import com.twitter.clientlib.auth.TwitterOAuth20Api;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;

public class TwitterOAuth20Service
extends OAuth20Service {
    public TwitterOAuth20Service(String apiKey, String apiSecret, String callback, String defaultScope) {
        super((DefaultApi20)TwitterOAuth20Api.instance(), apiKey, apiSecret, callback, defaultScope, "code", null, null, null, null);
    }

    public TwitterOAuth20Service(String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super((DefaultApi20)TwitterOAuth20Api.instance(), apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
    }

    public TwitterOAuth20Service createService(String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        return new TwitterOAuth20Service(apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
    }

    public String getAuthorizationUrl(PKCE pkce, String state) {
        this.checkApiKeyAndSecret();
        if (StringUtils.isEmpty((CharSequence)this.getCallback())) {
            throw new IllegalArgumentException("The callback cannot be null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.getDefaultScope())) {
            throw new IllegalArgumentException("The scope cannot be null or empty");
        }
        return this.createAuthorizationUrlBuilder().pkce(pkce).state(state).build();
    }

    public OAuth2AccessToken getAccessToken(PKCE pkce, String code) throws IOException, ExecutionException, InterruptedException {
        this.checkApiKeyAndSecret();
        AccessTokenRequestParams params = AccessTokenRequestParams.create((String)code);
        params = params.pkceCodeVerifier(pkce.getCodeVerifier());
        return this.getAccessToken(params);
    }

    private void checkApiKeyAndSecret() {
        if (StringUtils.isEmpty((CharSequence)this.getApiKey())) {
            throw new IllegalArgumentException("The TWITTER_OAUTH2_CLIENT_ID cannot be null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.getApiSecret())) {
            throw new IllegalArgumentException("The TWITTER_OAUTH2_CLIENT_SECRET cannot be null or empty");
        }
    }
}

