/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.CashtagEntity;
import com.twitter.clientlib.model.FullTextEntitiesAnnotations;
import com.twitter.clientlib.model.HashtagEntity;
import com.twitter.clientlib.model.MentionEntity;
import com.twitter.clientlib.model.UrlEntity;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class FullTextEntities {
    public static final String SERIALIZED_NAME_ANNOTATIONS = "annotations";
    @SerializedName(value="annotations")
    private List<FullTextEntitiesAnnotations> annotations = null;
    public static final String SERIALIZED_NAME_CASHTAGS = "cashtags";
    @SerializedName(value="cashtags")
    private List<CashtagEntity> cashtags = null;
    public static final String SERIALIZED_NAME_HASHTAGS = "hashtags";
    @SerializedName(value="hashtags")
    private List<HashtagEntity> hashtags = null;
    public static final String SERIALIZED_NAME_MENTIONS = "mentions";
    @SerializedName(value="mentions")
    private List<MentionEntity> mentions = null;
    public static final String SERIALIZED_NAME_URLS = "urls";
    @SerializedName(value="urls")
    private List<UrlEntity> urls = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FullTextEntities annotations(List<FullTextEntitiesAnnotations> annotations) {
        this.annotations = annotations;
        return this;
    }

    public FullTextEntities addAnnotationsItem(FullTextEntitiesAnnotations annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<FullTextEntitiesAnnotations>();
        }
        this.annotations.add(annotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<FullTextEntitiesAnnotations> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<FullTextEntitiesAnnotations> annotations) {
        this.annotations = annotations;
    }

    public FullTextEntities cashtags(List<CashtagEntity> cashtags) {
        this.cashtags = cashtags;
        return this;
    }

    public FullTextEntities addCashtagsItem(CashtagEntity cashtagsItem) {
        if (this.cashtags == null) {
            this.cashtags = new ArrayList<CashtagEntity>();
        }
        this.cashtags.add(cashtagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<CashtagEntity> getCashtags() {
        return this.cashtags;
    }

    public void setCashtags(List<CashtagEntity> cashtags) {
        this.cashtags = cashtags;
    }

    public FullTextEntities hashtags(List<HashtagEntity> hashtags) {
        this.hashtags = hashtags;
        return this;
    }

    public FullTextEntities addHashtagsItem(HashtagEntity hashtagsItem) {
        if (this.hashtags == null) {
            this.hashtags = new ArrayList<HashtagEntity>();
        }
        this.hashtags.add(hashtagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<HashtagEntity> getHashtags() {
        return this.hashtags;
    }

    public void setHashtags(List<HashtagEntity> hashtags) {
        this.hashtags = hashtags;
    }

    public FullTextEntities mentions(List<MentionEntity> mentions) {
        this.mentions = mentions;
        return this;
    }

    public FullTextEntities addMentionsItem(MentionEntity mentionsItem) {
        if (this.mentions == null) {
            this.mentions = new ArrayList<MentionEntity>();
        }
        this.mentions.add(mentionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<MentionEntity> getMentions() {
        return this.mentions;
    }

    public void setMentions(List<MentionEntity> mentions) {
        this.mentions = mentions;
    }

    public FullTextEntities urls(List<UrlEntity> urls) {
        this.urls = urls;
        return this;
    }

    public FullTextEntities addUrlsItem(UrlEntity urlsItem) {
        if (this.urls == null) {
            this.urls = new ArrayList<UrlEntity>();
        }
        this.urls.add(urlsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<UrlEntity> getUrls() {
        return this.urls;
    }

    public void setUrls(List<UrlEntity> urls) {
        this.urls = urls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullTextEntities fullTextEntities = (FullTextEntities)o;
        return Objects.equals(this.annotations, fullTextEntities.annotations) && Objects.equals(this.cashtags, fullTextEntities.cashtags) && Objects.equals(this.hashtags, fullTextEntities.hashtags) && Objects.equals(this.mentions, fullTextEntities.mentions) && Objects.equals(this.urls, fullTextEntities.urls);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.cashtags, this.hashtags, this.mentions, this.urls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FullTextEntities {\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    cashtags: ").append(this.toIndentedString(this.cashtags)).append("\n");
        sb.append("    hashtags: ").append(this.toIndentedString(this.hashtags)).append("\n");
        sb.append("    mentions: ").append(this.toIndentedString(this.mentions)).append("\n");
        sb.append("    urls: ").append(this.toIndentedString(this.urls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayurls;
        JsonArray jsonArraymentions;
        JsonArray jsonArrayhashtags;
        JsonArray jsonArraycashtags;
        JsonArray jsonArrayannotations = jsonObj.getAsJsonArray(SERIALIZED_NAME_ANNOTATIONS);
        if (jsonArrayannotations != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ANNOTATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `annotations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ANNOTATIONS).toString()));
            }
            for (int i = 0; i < jsonArrayannotations.size(); ++i) {
                FullTextEntitiesAnnotations.validateJsonObject(jsonArrayannotations.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraycashtags = jsonObj.getAsJsonArray(SERIALIZED_NAME_CASHTAGS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CASHTAGS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `cashtags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CASHTAGS).toString()));
            }
            for (int i = 0; i < jsonArraycashtags.size(); ++i) {
                CashtagEntity.validateJsonObject(jsonArraycashtags.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayhashtags = jsonObj.getAsJsonArray(SERIALIZED_NAME_HASHTAGS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_HASHTAGS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `hashtags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HASHTAGS).toString()));
            }
            for (int i = 0; i < jsonArrayhashtags.size(); ++i) {
                HashtagEntity.validateJsonObject(jsonArrayhashtags.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraymentions = jsonObj.getAsJsonArray(SERIALIZED_NAME_MENTIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MENTIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `mentions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MENTIONS).toString()));
            }
            for (int i = 0; i < jsonArraymentions.size(); ++i) {
                MentionEntity.validateJsonObject(jsonArraymentions.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayurls = jsonObj.getAsJsonArray(SERIALIZED_NAME_URLS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_URLS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `urls` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URLS).toString()));
            }
            for (int i = 0; i < jsonArrayurls.size(); ++i) {
                UrlEntity.validateJsonObject(jsonArrayurls.get(i).getAsJsonObject());
            }
        }
    }

    public static FullTextEntities fromJson(String jsonString) throws IOException {
        return (FullTextEntities)JSON.getGson().fromJson(jsonString, FullTextEntities.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ANNOTATIONS);
        openapiFields.add(SERIALIZED_NAME_CASHTAGS);
        openapiFields.add(SERIALIZED_NAME_HASHTAGS);
        openapiFields.add(SERIALIZED_NAME_MENTIONS);
        openapiFields.add(SERIALIZED_NAME_URLS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!FullTextEntities.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FullTextEntities.class));
            return new TypeAdapter<FullTextEntities>(){

                public void write(JsonWriter out, FullTextEntities value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public FullTextEntities read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FullTextEntities.validateJsonObject(jsonObj);
                    return (FullTextEntities)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

