/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Annotation for entities based on the Tweet text.")
public class FullTextEntitiesAnnotations {
    public static final String SERIALIZED_NAME_END = "end";
    @SerializedName(value="end")
    private Integer end;
    public static final String SERIALIZED_NAME_START = "start";
    @SerializedName(value="start")
    private Integer start;
    public static final String SERIALIZED_NAME_NORMALIZED_TEXT = "normalized_text";
    @SerializedName(value="normalized_text")
    private String normalizedText;
    public static final String SERIALIZED_NAME_PROBABILITY = "probability";
    @SerializedName(value="probability")
    private Double probability;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FullTextEntitiesAnnotations end(Integer end) {
        this.end = end;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="61", required=true, value="Index (zero-based) at which position this entity ends.  The index is inclusive.")
    public Integer getEnd() {
        return this.end;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public FullTextEntitiesAnnotations start(Integer start) {
        this.start = start;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="50", required=true, value="Index (zero-based) at which position this entity starts.  The index is inclusive.")
    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public FullTextEntitiesAnnotations normalizedText(String normalizedText) {
        this.normalizedText = normalizedText;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Barack Obama", value="Text used to determine annotation.")
    public String getNormalizedText() {
        return this.normalizedText;
    }

    public void setNormalizedText(String normalizedText) {
        this.normalizedText = normalizedText;
    }

    public FullTextEntitiesAnnotations probability(Double probability) {
        this.probability = probability;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Confidence factor for annotation type.")
    public Double getProbability() {
        return this.probability;
    }

    public void setProbability(Double probability) {
        this.probability = probability;
    }

    public FullTextEntitiesAnnotations type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Person", value="Annotation type.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullTextEntitiesAnnotations fullTextEntitiesAnnotations = (FullTextEntitiesAnnotations)o;
        return Objects.equals(this.end, fullTextEntitiesAnnotations.end) && Objects.equals(this.start, fullTextEntitiesAnnotations.start) && Objects.equals(this.normalizedText, fullTextEntitiesAnnotations.normalizedText) && Objects.equals(this.probability, fullTextEntitiesAnnotations.probability) && Objects.equals(this.type, fullTextEntitiesAnnotations.type);
    }

    public int hashCode() {
        return Objects.hash(this.end, this.start, this.normalizedText, this.probability, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FullTextEntitiesAnnotations {\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    normalizedText: ").append(this.toIndentedString(this.normalizedText)).append("\n");
        sb.append("    probability: ").append(this.toIndentedString(this.probability)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NORMALIZED_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_NORMALIZED_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `normalized_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NORMALIZED_TEXT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static FullTextEntitiesAnnotations fromJson(String jsonString) throws IOException {
        return (FullTextEntitiesAnnotations)JSON.getGson().fromJson(jsonString, FullTextEntitiesAnnotations.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_END);
        openapiFields.add(SERIALIZED_NAME_START);
        openapiFields.add(SERIALIZED_NAME_NORMALIZED_TEXT);
        openapiFields.add(SERIALIZED_NAME_PROBABILITY);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_END);
        openapiRequiredFields.add(SERIALIZED_NAME_START);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!FullTextEntitiesAnnotations.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FullTextEntitiesAnnotations.class));
            return new TypeAdapter<FullTextEntitiesAnnotations>(){

                public void write(JsonWriter out, FullTextEntitiesAnnotations value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public FullTextEntitiesAnnotations read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FullTextEntitiesAnnotations.validateJsonObject(jsonObj);
                    return (FullTextEntitiesAnnotations)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

