/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.Point;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The location tagged on the Tweet, if the user provided one.")
public class TweetGeo {
    public static final String SERIALIZED_NAME_COORDINATES = "coordinates";
    @SerializedName(value="coordinates")
    private Point coordinates;
    public static final String SERIALIZED_NAME_PLACE_ID = "place_id";
    @SerializedName(value="place_id")
    private String placeId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetGeo coordinates(Point coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Point getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(Point coordinates) {
        this.coordinates = coordinates;
    }

    public TweetGeo placeId(String placeId) {
        this.placeId = placeId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="f7eb2fa2fea288b1", value="The identifier for this place.")
    public String getPlaceId() {
        return this.placeId;
    }

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetGeo tweetGeo = (TweetGeo)o;
        return Objects.equals(this.coordinates, tweetGeo.coordinates) && Objects.equals(this.placeId, tweetGeo.placeId);
    }

    public int hashCode() {
        return Objects.hash(this.coordinates, this.placeId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetGeo {\n");
        sb.append("    coordinates: ").append(this.toIndentedString(this.coordinates)).append("\n");
        sb.append("    placeId: ").append(this.toIndentedString(this.placeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COORDINATES) != null) {
            Point.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COORDINATES));
        }
        if (jsonObj.get(SERIALIZED_NAME_PLACE_ID) != null && !jsonObj.get(SERIALIZED_NAME_PLACE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `place_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PLACE_ID).toString()));
        }
    }

    public static TweetGeo fromJson(String jsonString) throws IOException {
        return (TweetGeo)JSON.getGson().fromJson(jsonString, TweetGeo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COORDINATES);
        openapiFields.add(SERIALIZED_NAME_PLACE_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetGeo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetGeo.class));
            return new TypeAdapter<TweetGeo>(){

                public void write(JsonWriter out, TweetGeo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetGeo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetGeo.validateJsonObject(jsonObj);
                    return (TweetGeo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

