/*
 * Decompiled with CFR 0.152.
 */
package unquietcode.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import unquietcode.utils.Factory;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    @SafeVarargs
    public static <T> T[] array(T ... values) {
        return values;
    }

    @SafeVarargs
    public static <T> T[] prepend(T[] array, T ... newValues) {
        return CollectionUtils.append(newValues, array);
    }

    @SafeVarargs
    public static <T> T[] append(T[] array, T ... newValues) {
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + newValues.length);
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(newValues, 0, newArray, array.length, newValues.length);
        return newArray;
    }

    public static <T> List<T> deduplicate(T[] array, Factory<Set<T>> setFactory) {
        Set<T> set = setFactory.get();
        ArrayList<T> retval = new ArrayList<T>();
        for (T t : array) {
            if (set.contains(t)) continue;
            set.add(t);
            retval.add(t);
        }
        return retval;
    }

    @SafeVarargs
    public static <T> List<T> list(T ... values) {
        return new ArrayList<T>(Arrays.asList(values));
    }

    @SafeVarargs
    public static <T> Set<T> hashSet(T ... values) {
        return new HashSet<T>(CollectionUtils.list(values));
    }

    public static String print(Collection<?> values) {
        return CollectionUtils.print("[", "]", ", ", values);
    }

    public static String print(Map<?, ?> values) {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            String string = String.valueOf(entry.getKey()) + " => " + String.valueOf(entry.getValue());
            set.add(string);
        }
        return CollectionUtils.print(set);
    }

    public static String print(Object ... values) {
        return CollectionUtils.print("[", "]", ", ", values);
    }

    public static String print(String delimiter, Collection<?> values) {
        return CollectionUtils.print("", "", delimiter, values);
    }

    public static String print(String delimiter, Object ... values) {
        return CollectionUtils.print("", "", delimiter, values);
    }

    public static String print(String prefix, String suffix, String delimiter, Object ... values) {
        return CollectionUtils.print(prefix, suffix, delimiter, Arrays.asList(values));
    }

    public static String print(String prefix, String suffix, String delimiter, Collection<?> values) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        boolean first = true;
        for (Object value : values) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(value);
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static <T> Set<T> randomSubset(Set<T> set, int count, Set<T> target) {
        LinkedList<T> list = new LinkedList<T>(set);
        Collections.shuffle(list);
        int end = count <= list.size() ? count : list.size();
        target.addAll(list.subList(0, end));
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V synchronized_get_or_set(Map<K, V> map, K key, Supplier<V> valueProvider) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        Map<K, V> map2 = map;
        synchronized (map2) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            V value = valueProvider.get();
            map.put(key, value);
            return value;
        }
    }

    public static <T> T first(List<T> list) {
        return list.get(0);
    }

    public static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> Collection<T> safe(Collection<T> collection) {
        return collection != null ? collection : Collections.emptyList();
    }

    public static <T> List<T> safe(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    public static <T> List<T> safe(T[] list) {
        return list != null ? Arrays.asList(list) : Collections.emptyList();
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !CollectionUtils.isEmpty(array);
    }

    public static <K, V> void addToArrayList(Map<K, List<V>> map, K key, V value) {
        CollectionUtils.addToMap(map, key, value, ArrayList::new);
    }

    public static <K, V> void addToHashSet(Map<K, Set<V>> map, K key, V value) {
        CollectionUtils.addToMap(map, key, value, HashSet::new);
    }

    public static <K, V> void addToIdentityHashSet(Map<K, Set<V>> map, K key, V value) {
        CollectionUtils.addToMap(map, key, value, CollectionUtils::newIdentityHashSet);
    }

    public static <K, V, T extends Collection<V>> void addToMap(Map<K, T> map, K key, V value, Factory<T> factory) {
        if (map.containsKey(key)) {
            ((Collection)map.get(key)).add(value);
        } else {
            Collection collection = (Collection)factory.get();
            collection.add(value);
            map.put(key, collection);
        }
    }

    public static <_Key1, _Key2, _Value> void addToHashMap(Map<_Key1, Map<_Key2, _Value>> map, _Key1 outerKey, _Key2 innerKey, _Value value) {
        CollectionUtils.addToNestedMap(map, outerKey, innerKey, value, HashMap::new);
    }

    public static <_Key1, _Key2, _Value> void addToIdentityHashMap(Map<_Key1, Map<_Key2, _Value>> map, _Key1 outerKey, _Key2 innerKey, _Value value) {
        CollectionUtils.addToNestedMap(map, outerKey, innerKey, value, IdentityHashMap::new);
    }

    public static <_Key1, _Key2, _Value> void addToNestedMap(Map<_Key1, Map<_Key2, _Value>> map, _Key1 outerKey, _Key2 innerKey, _Value value, Factory<Map<_Key2, _Value>> factory) {
        Map<_Key2, _Value> innerMap = map.get(outerKey);
        if (innerMap == null) {
            innerMap = factory.get();
            map.put(outerKey, innerMap);
        }
        innerMap.put(innerKey, value);
    }

    public static <T> Set<T> newIdentityHashSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    public static <T> List<T> flatten(Collection<? extends Collection<T>> items) {
        return items.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

