/*
 * Decompiled with CFR 0.152.
 */
package unquietcode.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.TimeZone;

public final class TimeUtils {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final DateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");

    private TimeUtils() {
    }

    public static String iso8601(long time) {
        return TimeUtils.iso8601(new Date(time));
    }

    public static String iso8601(Date date) {
        return ISO_8601.format(Objects.requireNonNull(date));
    }

    public static long getCurrentTimeToTheMinute() {
        Calendar time = GregorianCalendar.getInstance();
        time.set(14, 0);
        time.set(13, 0);
        return time.getTimeInMillis();
    }

    public static long getCurrentTimeToTheSecond() {
        Calendar time = GregorianCalendar.getInstance();
        time.set(14, 0);
        return time.getTimeInMillis();
    }

    public static long getTimeToTheSecond_div10(long time) {
        Calendar working = GregorianCalendar.getInstance();
        working.setTimeInMillis(time);
        working.set(14, 0);
        int second = working.get(13);
        second = (int)((double)second / 10.0 * 10.0);
        working.set(13, second);
        return working.getTimeInMillis();
    }

    static {
        ISO_8601.setTimeZone(UTC);
    }
}

