/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations;

import com.wavefront.api.DataIngesterAPI;
import com.wavefront.common.NamedThreadFactory;
import com.wavefront.integrations.WavefrontConnectionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDirectConnectionHandler
implements WavefrontConnectionHandler,
Runnable {
    private static final String DEFAULT_SOURCE = "wavefrontDirectSender";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDirectConnectionHandler.class);
    private ScheduledExecutorService scheduler;
    private final String server;
    private final String token;
    private DataIngesterAPI directService;

    protected AbstractDirectConnectionHandler(String server, String token) {
        this.server = server;
        this.token = token;
    }

    @Override
    public synchronized void connect() throws IllegalStateException, IOException {
        if (this.directService == null) {
            this.directService = new DataIngesterService(this.server, this.token);
            this.scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(DEFAULT_SOURCE));
            this.scheduler.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void flush() throws IOException {
        this.internalFlush();
    }

    protected abstract void internalFlush() throws IOException;

    @Override
    public synchronized boolean isConnected() {
        return this.directService != null;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.directService != null) {
            try {
                this.scheduler.shutdownNow();
            }
            catch (SecurityException ex) {
                LOGGER.debug("shutdown error", (Throwable)ex);
            }
            this.scheduler = null;
            this.directService = null;
        }
    }

    protected Response report(String format, InputStream is) throws IOException {
        return this.directService.report(format, is);
    }

    private static final class DataIngesterService
    implements DataIngesterAPI {
        private final String token;
        private final URI uri;
        private static final String BAD_REQUEST = "Bad client request";
        private static final int CONNECT_TIMEOUT = 30000;
        private static final int READ_TIMEOUT = 10000;

        public DataIngesterService(String server, String token) {
            this.token = token;
            this.uri = URI.create(server);
        }

        public Response report(String format, InputStream stream) throws IOException {
            String respMsg;
            int statusCode;
            block16: {
                statusCode = 400;
                respMsg = BAD_REQUEST;
                HttpURLConnection urlConn = null;
                try {
                    URL url = new URL(this.uri.getScheme(), this.uri.getHost(), this.uri.getPort(), String.format("/report?f=" + format, new Object[0]));
                    urlConn = (HttpURLConnection)url.openConnection();
                    urlConn.setDoOutput(true);
                    urlConn.addRequestProperty("Content-Type", "application/octet-stream");
                    urlConn.addRequestProperty("Content-Encoding", "gzip");
                    urlConn.addRequestProperty("Authorization", "Bearer " + this.token);
                    urlConn.setConnectTimeout(30000);
                    urlConn.setReadTimeout(10000);
                    try (GZIPOutputStream gzipOS = new GZIPOutputStream(urlConn.getOutputStream());){
                        byte[] buffer = new byte[4096];
                        int len = 0;
                        while ((len = stream.read(buffer)) > 0) {
                            gzipOS.write(buffer);
                        }
                        gzipOS.flush();
                    }
                    statusCode = urlConn.getResponseCode();
                    respMsg = urlConn.getResponseMessage();
                    this.readAndClose(urlConn.getInputStream());
                }
                catch (IOException ex) {
                    if (urlConn == null) break block16;
                    statusCode = urlConn.getResponseCode();
                    respMsg = urlConn.getResponseMessage();
                    this.readAndClose(urlConn.getErrorStream());
                }
            }
            return Response.status((int)statusCode).entity((Object)respMsg).build();
        }

        private void readAndClose(InputStream stream) throws IOException {
            if (stream != null) {
                try (InputStream is = stream;){
                    byte[] buffer = new byte[4096];
                    int ret = 0;
                    while ((ret = is.read(buffer)) > 0) {
                    }
                }
            }
        }
    }
}

