/*
 * Decompiled with CFR 0.152.
 */
package com.weaverplatform;

import com.weaverplatform.CliOptions;
import com.weaverplatform.sdk.Project;
import com.weaverplatform.sdk.Weaver;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class Main {
    private static CliOptions options;

    public static void signIn(Weaver w, String uri, String username, String password) {
        w.setUri(uri);
        w.setUsername(username);
        w.setPassword(password);
        w.login();
    }

    public static void printProjects(Weaver w) {
        Project[] projects;
        for (Project p : projects = w.getProjects()) {
            System.out.println("id: " + p.getId() + ", name: " + p.getName());
        }
    }

    public static void performOperation(Weaver w, String project, String operation) {
        w.setProject(project);
        switch (operation) {
            case "history": {
                System.out.println(w.getHistory());
                break;
            }
            case "snapshot": {
                System.out.println(w.getSnapshot(options.zip()));
                break;
            }
            case "restore": {
                w.restore(System.in);
                break;
            }
            case "project-create": {
                w.createProject(project);
                break;
            }
            case "project-ready": {
                w.projectReady(project);
                break;
            }
            case "project-wipe": {
                w.wipe();
                break;
            }
            default: {
                CliOptions.printUsage();
            }
        }
    }

    public static void main(String[] args) {
        options = new CliOptions(args);
        ArrayList<String> arguments = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            arguments.add(arg);
        }
        try {
            Main.fixHttps();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Weaver w = new Weaver(options);
        if (arguments.size() == 0) {
            CliOptions.printUsage();
        } else if (arguments.size() >= 3) {
            Main.signIn(w, (String)arguments.get(0), (String)arguments.get(1), (String)arguments.get(2));
            if (arguments.size() == 3) {
                Main.printProjects(w);
            } else if (arguments.size() == 5) {
                Main.performOperation(w, (String)arguments.get(3), (String)arguments.get(4));
            } else {
                CliOptions.printUsage();
            }
        } else {
            CliOptions.printUsage();
        }
    }

    public static void fixHttps() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }
}

