/*
 * Decompiled with CFR 0.152.
 */
package com.weaverplatform.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.weaverplatform.protocol.WeaverError;
import com.weaverplatform.protocol.model.CreateAttributeOperation;
import com.weaverplatform.protocol.model.CreateNodeOperation;
import com.weaverplatform.protocol.model.CreateRelationOperation;
import com.weaverplatform.protocol.model.RemoveAttributeOperation;
import com.weaverplatform.protocol.model.RemoveNodeOperation;
import com.weaverplatform.protocol.model.RemoveNodeUnrecoverableOperation;
import com.weaverplatform.protocol.model.RemoveRelationOperation;
import com.weaverplatform.protocol.model.WriteOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WriteOperationParser {
    private static final Gson gson;
    private JsonReader reader = null;

    public static List<WriteOperation> parse(String writeOperationsJson) {
        return (List)gson.fromJson(writeOperationsJson, new TypeToken<List<WriteOperation>>(){}.getType());
    }

    public List<WriteOperation> parseNext(InputStream stream, int chunkSize) throws IOException {
        ArrayList<WriteOperation> list = new ArrayList<WriteOperation>();
        if (this.reader == null) {
            this.reader = new JsonReader((Reader)new InputStreamReader(stream, "UTF-8"));
            this.reader.beginArray();
        }
        int count = 0;
        while (this.reader.hasNext() && count++ < chunkSize) {
            list.add((WriteOperation)gson.fromJson(this.reader, new TypeToken<WriteOperation>(){}.getType()));
        }
        return list;
    }

    public static List<WriteOperation> parse(String writeOperationsJson, String creator) {
        List<WriteOperation> operations = WriteOperationParser.parse(writeOperationsJson);
        if (creator != null) {
            operations.forEach(operation -> operation.setUser(creator));
        }
        return operations;
    }

    static {
        WriteOperationDeserializer deserializer = new WriteOperationDeserializer();
        deserializer.registerAction(WriteOperation.WriteOperationAction.CREATE_NODE, CreateNodeOperation.class);
        deserializer.registerAction(WriteOperation.WriteOperationAction.CREATE_ATTRIBUTE, CreateAttributeOperation.class);
        deserializer.registerAction(WriteOperation.WriteOperationAction.CREATE_RELATION, CreateRelationOperation.class);
        deserializer.registerAction(WriteOperation.WriteOperationAction.REMOVE_NODE, RemoveNodeOperation.class);
        deserializer.registerAction(WriteOperation.WriteOperationAction.REMOVE_NODE_UNRECOVERABLE, RemoveNodeUnrecoverableOperation.class);
        deserializer.registerAction(WriteOperation.WriteOperationAction.REMOVE_ATTRIBUTE, RemoveAttributeOperation.class);
        deserializer.registerAction(WriteOperation.WriteOperationAction.REMOVE_RELATION, RemoveRelationOperation.class);
        gson = new GsonBuilder().registerTypeAdapter(WriteOperation.class, (Object)deserializer).create();
    }

    static class WriteOperationDeserializer
    implements JsonDeserializer<WriteOperation> {
        Map<String, Class<? extends WriteOperation>> actionRegistry = new HashMap<String, Class<? extends WriteOperation>>();

        WriteOperationDeserializer() {
        }

        void registerAction(WriteOperation.WriteOperationAction action, Class<? extends WriteOperation> javaType) {
            this.actionRegistry.put(action.getValue(), javaType);
        }

        public WriteOperation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            String action = jsonObject.get("action").getAsString();
            if (!this.actionRegistry.containsKey(action)) {
                throw new WeaverError(344, "This action was not found: " + action);
            }
            Class<? extends WriteOperation> dataType = this.actionRegistry.get(action);
            return (WriteOperation)context.deserialize((JsonElement)jsonObject, dataType);
        }
    }
}

