/*
 * Decompiled with CFR 0.152.
 */
package com.weaverplatform.protocol.model;

import com.google.gson.Gson;

public abstract class WriteOperation {
    private WriteOperationAction action;
    private String user;
    private String id;
    private String graph;
    private long timestamp;

    public WriteOperation(String user, String id) {
        this.user = user;
        this.id = id;
        this.timestamp = System.currentTimeMillis();
        this.action = this.getAction();
    }

    public abstract WriteOperationAction getAction();

    public String toJson() {
        return new Gson().toJson((Object)this);
    }

    public String getUser() {
        return this.user;
    }

    public String getGraph() {
        return this.graph;
    }

    public void setGraph(String graph) {
        this.graph = graph;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static enum WriteOperationAction {
        CREATE_NODE("create-node"),
        CREATE_RELATION("create-relation"),
        CREATE_ATTRIBUTE("create-attribute"),
        REMOVE_NODE("remove-node"),
        REMOVE_NODE_UNRECOVERABLE("remove-node-unrecoverable"),
        REMOVE_RELATION("remove-relation"),
        REMOVE_ATTRIBUTE("remove-attribute");

        private String value;

        private WriteOperationAction(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

