/*
 * Decompiled with CFR 0.152.
 */
package com.weaverplatform.protocol.weavermodel;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.weaverplatform.protocol.weavermodel.ModelAttribute;
import com.weaverplatform.protocol.weavermodel.ModelAuthor;
import com.weaverplatform.protocol.weavermodel.ModelClass;
import com.weaverplatform.protocol.weavermodel.ModelClasses;
import com.weaverplatform.protocol.weavermodel.ModelRelation;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ModelDefinition {
    private String name;
    private String version;
    private ModelAuthor author;
    private ModelClasses classes;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ModelAuthor getAuthor() {
        return this.author;
    }

    public void setAuthor(ModelAuthor author) {
        this.author = author;
    }

    public ModelClasses getClasses() {
        return this.classes;
    }

    @JsonProperty(value="classes")
    public void setClasses(ModelClasses classes) {
        this.classes = classes;
    }

    public void setClasses(Map<String, ModelClass> map) {
        ModelClasses classes = new ModelClasses();
        classes.setClasses(map);
        this.classes = classes;
    }

    public void setClasses(Collection<ModelClass> collection) {
        ModelClasses classes = new ModelClasses();
        for (ModelClass item : collection) {
            classes.dynamic(item.getName(), item);
        }
        this.classes = classes;
    }

    public static boolean illegalName(String toExamine) {
        if (toExamine == null || toExamine.isEmpty()) {
            return true;
        }
        if (StringUtils.isNumeric((CharSequence)toExamine.substring(0, 1))) {
            return true;
        }
        Pattern pattern = Pattern.compile("[^A-Za-z0-9_]");
        Matcher matcher = pattern.matcher(toExamine);
        return matcher.find();
    }

    public static ModelDefinition parse(InputStream inputStream) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            return (ModelDefinition)mapper.readValue(inputStream, ModelDefinition.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Was not able to parse config file: " + e.getMessage());
        }
    }

    public static String write(Object configFile) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).disable(YAMLGenerator.Feature.CANONICAL_OUTPUT).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).disable(YAMLGenerator.Feature.INDENT_ARRAYS)).enable(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter("skipOptionalField", new SimpleBeanPropertyFilter(){

            public void serializeAsField(Object object, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
                if (this.include(writer)) {
                    if (object instanceof ModelClass && ((ModelClass)object).unsetOptionalFields().contains(writer.getName())) {
                        return;
                    }
                    if (object instanceof ModelAttribute && ((ModelAttribute)object).unsetOptionalFields().contains(writer.getName())) {
                        return;
                    }
                    if (object instanceof ModelRelation && ((ModelRelation)object).unsetOptionalFields().contains(writer.getName())) {
                        return;
                    }
                    writer.serializeAsField(object, jgen, provider);
                } else if (!jgen.canOmitFields()) {
                    writer.serializeAsOmittedField(object, jgen, provider);
                }
            }

            protected boolean include(BeanPropertyWriter writer) {
                return true;
            }

            protected boolean include(PropertyWriter writer) {
                return true;
            }
        });
        mapper.setFilterProvider((FilterProvider)filterProvider);
        try {
            String yml = mapper.writeValueAsString(configFile);
            yml = yml.replace(" {}", "");
            yml = yml.replace("'[", "[");
            yml = yml.replace("]'", "]");
            yml = yml.trim();
            return yml;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Was not able to map object to yml: " + e.getMessage());
        }
    }
}

