/*
 * Decompiled with CFR 0.152.
 */
package com.weaverplatform.sdk;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.weaverplatform.CliOptions;
import com.weaverplatform.sdk.Project;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class Weaver {
    public static int MAX_OPERATIONS = 5000;
    private CliOptions options;
    private String uri = "http://localhost:9487";
    private String username = "admin";
    private String password = "admin";
    private String project = null;
    private String authToken = null;
    private Gson converter = new Gson();

    public Weaver() {
        this.options = new CliOptions(new String[0]);
    }

    public Weaver(CliOptions options) {
        this.options = options;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String login() {
        if (this.authToken != null) {
            return this.authToken;
        }
        JsonObject signIn = new JsonObject();
        signIn.addProperty("username", this.username);
        signIn.addProperty("password", this.password);
        ClientResponse response = this.send(signIn, "/user/signInUsername", OP.post);
        this.authToken = (String)response.getEntity(String.class);
        return this.authToken;
    }

    public ClientResponse sendProject(JsonObject payload, String target, OP op) {
        payload.addProperty("target", this.project);
        return this.sendAuthenticated(payload, target, op);
    }

    public ClientResponse sendAuthenticated(JsonObject payload, String target, OP op) {
        String authToken = this.login();
        payload.addProperty("authToken", authToken);
        return this.send(payload, target, op);
    }

    public ClientResponse send(JsonObject payload, String target, OP op) {
        ClientResponse soapResponse;
        Client client = Client.create();
        WebResource webResource = client.resource(this.uri + target);
        switch (op) {
            case get: {
                try {
                    String json = URLEncoder.encode(this.converter.toJson((JsonElement)payload), "UTF-8");
                    webResource = webResource.queryParam("payload", json);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                soapResponse = (ClientResponse)webResource.type("application/json; charset=utf-8").get(ClientResponse.class);
                break;
            }
            default: {
                soapResponse = (ClientResponse)webResource.type("application/json; charset=utf-8").post(ClientResponse.class, (Object)this.converter.toJson((JsonElement)payload));
            }
        }
        if (soapResponse.getStatus() != 200) {
            String response = (String)soapResponse.getEntity(String.class);
            throw new RuntimeException("Message delivery failed on " + target + " response: " + response);
        }
        return soapResponse;
    }

    public void createProject(String id) {
        JsonObject payload = new JsonObject();
        payload.addProperty("id", id);
        payload.addProperty("name", id);
        this.sendAuthenticated(payload, "/project/create", OP.post);
    }

    public String projectReady(String id) {
        JsonObject payload = new JsonObject();
        payload.addProperty("id", id);
        return (String)this.sendAuthenticated(payload, "/project/ready", OP.post).getEntity(String.class);
    }

    public String getVersion() {
        JsonObject payload = new JsonObject();
        return (String)this.sendProject(payload, "/application/version", OP.get).getEntity(String.class);
    }

    public void wipe() {
        JsonObject payload = new JsonObject();
        this.sendProject(payload, "/project/wipe", OP.post);
    }

    public void sendCreate(JsonArray operations, boolean quick) {
        JsonArray array = new JsonArray();
        boolean stop = false;
        while (array.size() < MAX_OPERATIONS && operations.size() > 0 && !stop) {
            JsonObject peek = operations.get(0).getAsJsonObject();
            if (peek.get("action").getAsString().equals("increment-attribute")) {
                stop = true;
                if (array.size() != 0) continue;
                array.add(operations.remove(0));
                continue;
            }
            array.add(operations.remove(0));
        }
        if (operations.size() > 0) {
            System.out.println("will send " + array.size() + " (" + operations.size() + " to go)");
        } else {
            System.out.println("will send " + array.size());
        }
        this.reallySendCreate(array, quick);
        if (operations.size() > 0) {
            this.sendCreate(operations, quick);
        }
    }

    public void reallySendCreate(JsonArray operations, boolean quick) {
        JsonObject payload = new JsonObject();
        payload.add("operations", (JsonElement)operations);
        String target = "/write";
        if (quick) {
            target = "/write/quick";
        }
        this.sendProject(payload, target, OP.post);
    }

    public JsonObject createNode(String id) {
        JsonObject payload = new JsonObject();
        payload.addProperty("timestamp", (Number)System.currentTimeMillis());
        payload.addProperty("action", "create-node");
        payload.addProperty("id", id);
        return payload;
    }

    public JsonObject createAttribute(String id, String key, String value) {
        JsonObject payload = new JsonObject();
        payload.addProperty("timestamp", (Number)System.currentTimeMillis());
        payload.addProperty("action", "create-attribute");
        payload.addProperty("id", id);
        payload.addProperty("key", key);
        payload.addProperty("value", value);
        return payload;
    }

    public JsonObject createRelation(String from, String key, String to, String id) {
        JsonObject payload = new JsonObject();
        payload.addProperty("timestamp", (Number)System.currentTimeMillis());
        payload.addProperty("action", "create-relation");
        payload.addProperty("from", from);
        payload.addProperty("key", key);
        payload.addProperty("to", to);
        payload.addProperty("id", id);
        return payload;
    }

    public Project[] getProjects() {
        ClientResponse res = this.sendAuthenticated(new JsonObject(), "/project", OP.get);
        String s = (String)res.getEntity(String.class);
        JsonArray o = (JsonArray)this.converter.fromJson(s, JsonArray.class);
        Project[] result = new Project[o.size()];
        for (int i = 0; i < o.size(); ++i) {
            JsonObject jsonElement = o.get(i).getAsJsonObject();
            result[i] = new Project(jsonElement.get("id").getAsString(), jsonElement.get("name").getAsString());
        }
        return result;
    }

    public String getSnapshot(boolean zipped) {
        JsonObject payload = new JsonObject();
        payload.addProperty("zipped", Boolean.valueOf(zipped));
        ClientResponse soapResponse = this.sendProject(payload, "/snapshot", OP.get);
        return (String)soapResponse.getEntity(String.class);
    }

    public String getSnapshotGraph(String graph, boolean zipped) {
        JsonObject payload = new JsonObject();
        if (graph != null) {
            payload.addProperty("graph", graph);
        }
        payload.addProperty("zipped", Boolean.valueOf(zipped));
        ClientResponse soapResponse = this.sendProject(payload, "/snapshotGraph", OP.get);
        return (String)soapResponse.getEntity(String.class);
    }

    public String getHistory() {
        ClientResponse soapResponse = this.sendProject(new JsonObject(), "/history", OP.get);
        return (String)soapResponse.getEntity(String.class);
    }

    public void restore(InputStream operationsStream) {
        JsonArray ops = (JsonArray)this.converter.fromJson((Reader)new InputStreamReader(operationsStream), JsonArray.class);
        System.out.println("Going to write " + ops.size() + " operations.");
        this.sendCreate(ops, false);
    }

    private static enum OP {
        get,
        post;

    }
}

