/*
 * Decompiled with CFR 0.152.
 */
package com.weaverplatform.util;

import com.weaverplatform.protocol.model.AttributeDataType;
import com.weaverplatform.protocol.model.PrimitiveDataType;

public class DataTypeUtil {
    public static final String XML_NAMESPACE = "http://www.w3.org/2001/XMLSchema#";
    public static final String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    public static String getDatatypeCode(AttributeDataType dataType) {
        switch (dataType) {
            case STRING: {
                return "string";
            }
            case DOUBLE: {
                return "double";
            }
            case DATE: {
                return "date";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case RDF_LANGSTRING: {
                return "rdf:langString";
            }
            case XSD_DURATION: {
                return "xsd:duration";
            }
            case XSD_DATETIME: {
                return "xsd:dateTime";
            }
            case XSD_DAYTIMEDURATION: {
                return "xsd:dayTimeDuration";
            }
            case XSD_TIME: {
                return "xsd:time";
            }
            case XSD_DATE: {
                return "xsd:date";
            }
            case XSD_GYEARMONTH: {
                return "xsd:gYearMonth";
            }
            case XSD_GYEAR: {
                return "xsd:gYear";
            }
            case XSD_GMONTHDAY: {
                return "xsd:gMonthDay";
            }
            case XSD_GDAY: {
                return "xsd:gDay";
            }
            case XSD_GMONTH: {
                return "xsd:gMonth";
            }
            case XSD_STRING: {
                return "xsd:string";
            }
            case XSD_BOOLEAN: {
                return "xsd:boolean";
            }
            case XSD_BASE64BINARY: {
                return "xsd:base64Binary";
            }
            case XSD_HEXBINARY: {
                return "xsd:hexBinary";
            }
            case XSD_FLOAT: {
                return "xsd:float";
            }
            case XSD_DECIMAL: {
                return "xsd:decimal";
            }
            case XSD_DOUBLE: {
                return "xsd:double";
            }
            case XSD_ANYURI: {
                return "xsd:anyURI";
            }
            case XSD_QNAME: {
                return "xsd:QName";
            }
            case XSD_NOTATION: {
                return "xsd:NOTATION";
            }
            case XSD_NORMALIZEDSTRING: {
                return "xsd:normalizedString";
            }
            case XSD_TOKEN: {
                return "xsd:token";
            }
            case XSD_LANGUAGE: {
                return "xsd:language";
            }
            case XSD_NMTOKEN: {
                return "xsd:NMTOKEN";
            }
            case XSD_NMTOKENS: {
                return "xsd:NMTOKENS";
            }
            case XSD_NAME: {
                return "xsd:Name";
            }
            case XSD_NCNAME: {
                return "xsd:NCName";
            }
            case XSD_ID: {
                return "xsd:ID";
            }
            case XSD_IDREF: {
                return "xsd:IDREF";
            }
            case XSD_IDREFS: {
                return "xsd:IDREFS";
            }
            case XSD_ENTITY: {
                return "xsd:ENTITY";
            }
            case XSD_ENTITIES: {
                return "xsd:ENTITIES";
            }
            case XSD_INTEGER: {
                return "xsd:integer";
            }
            case XSD_LONG: {
                return "xsd:long";
            }
            case XSD_INT: {
                return "xsd:int";
            }
            case XSD_SHORT: {
                return "xsd:short";
            }
            case XSD_BYTE: {
                return "xsd:byte";
            }
            case XSD_NON_POSITIVE_INTEGER: {
                return "xsd:nonPositiveInteger";
            }
            case XSD_NEGATIVE_INTEGER: {
                return "xsd:negativeInteger";
            }
            case XSD_NON_NEGATIVE_INTEGER: {
                return "xsd:nonNegativeInteger";
            }
            case XSD_POSITIVE_INTEGER: {
                return "xsd:positiveInteger";
            }
            case XSD_UNSIGNED_LONG: {
                return "xsd:unsignedLong";
            }
            case XSD_UNSIGNED_INT: {
                return "xsd:unsignedInt";
            }
            case XSD_UNSIGNED_SHORT: {
                return "xsd:unsignedShort";
            }
            case XSD_UNSIGNED_BYTE: {
                return "xsd:unsignedByte";
            }
            case XSD_YEARMONTHDURATION: {
                return "xsd:yearMonthDuration";
            }
        }
        throw new RuntimeException("This dataType is not supported: " + (Object)((Object)dataType));
    }

    public static AttributeDataType parse(String code) {
        if (code.startsWith(RDF_NAMESPACE)) {
            code.replace(RDF_NAMESPACE, "rdf:");
        }
        if (code.startsWith(XML_NAMESPACE)) {
            code.replace(RDF_NAMESPACE, "xsd:");
        }
        switch (code) {
            case "string": {
                return AttributeDataType.STRING;
            }
            case "double": {
                return AttributeDataType.DOUBLE;
            }
            case "date": {
                return AttributeDataType.DATE;
            }
            case "boolean": {
                return AttributeDataType.BOOLEAN;
            }
            case "rdf:langString": {
                return AttributeDataType.RDF_LANGSTRING;
            }
            case "xsd:duration": {
                return AttributeDataType.XSD_DURATION;
            }
            case "xsd:dateTime": {
                return AttributeDataType.XSD_DATETIME;
            }
            case "xsd:dayTimeDuration": {
                return AttributeDataType.XSD_DAYTIMEDURATION;
            }
            case "xsd:time": {
                return AttributeDataType.XSD_TIME;
            }
            case "xsd:date": {
                return AttributeDataType.XSD_DATE;
            }
            case "xsd:gYearMonth": {
                return AttributeDataType.XSD_GYEARMONTH;
            }
            case "xsd:gYear": {
                return AttributeDataType.XSD_GYEAR;
            }
            case "xsd:gMonthDay": {
                return AttributeDataType.XSD_GMONTHDAY;
            }
            case "xsd:gDay": {
                return AttributeDataType.XSD_GDAY;
            }
            case "xsd:gMonth": {
                return AttributeDataType.XSD_GMONTH;
            }
            case "xsd:string": {
                return AttributeDataType.XSD_STRING;
            }
            case "xsd:boolean": {
                return AttributeDataType.XSD_BOOLEAN;
            }
            case "xsd:base64Binary": {
                return AttributeDataType.XSD_BASE64BINARY;
            }
            case "xsd:hexBinary": {
                return AttributeDataType.XSD_HEXBINARY;
            }
            case "xsd:float": {
                return AttributeDataType.XSD_FLOAT;
            }
            case "xsd:decimal": {
                return AttributeDataType.XSD_DECIMAL;
            }
            case "xsd:double": {
                return AttributeDataType.XSD_DOUBLE;
            }
            case "xsd:anyURI": {
                return AttributeDataType.XSD_ANYURI;
            }
            case "xsd:QName": {
                return AttributeDataType.XSD_QNAME;
            }
            case "xsd:NOTATION": {
                return AttributeDataType.XSD_NOTATION;
            }
            case "xsd:normalizedString": {
                return AttributeDataType.XSD_NORMALIZEDSTRING;
            }
            case "xsd:token": {
                return AttributeDataType.XSD_TOKEN;
            }
            case "xsd:language": {
                return AttributeDataType.XSD_LANGUAGE;
            }
            case "xsd:NMTOKEN": {
                return AttributeDataType.XSD_NMTOKEN;
            }
            case "xsd:NMTOKENS": {
                return AttributeDataType.XSD_NMTOKENS;
            }
            case "xsd:Name": {
                return AttributeDataType.XSD_NAME;
            }
            case "xsd:NCName": {
                return AttributeDataType.XSD_NCNAME;
            }
            case "xsd:ID": {
                return AttributeDataType.XSD_ID;
            }
            case "xsd:IDREF": {
                return AttributeDataType.XSD_IDREF;
            }
            case "xsd:IDREFS": {
                return AttributeDataType.XSD_IDREFS;
            }
            case "xsd:ENTITY": {
                return AttributeDataType.XSD_ENTITY;
            }
            case "xsd:ENTITIES": {
                return AttributeDataType.XSD_ENTITIES;
            }
            case "xsd:integer": {
                return AttributeDataType.XSD_INTEGER;
            }
            case "xsd:long": {
                return AttributeDataType.XSD_LONG;
            }
            case "xsd:int": {
                return AttributeDataType.XSD_INT;
            }
            case "xsd:short": {
                return AttributeDataType.XSD_SHORT;
            }
            case "xsd:byte": {
                return AttributeDataType.XSD_BYTE;
            }
            case "xsd:nonPositiveInteger": {
                return AttributeDataType.XSD_NON_POSITIVE_INTEGER;
            }
            case "xsd:negativeInteger": {
                return AttributeDataType.XSD_NEGATIVE_INTEGER;
            }
            case "xsd:nonNegativeInteger": {
                return AttributeDataType.XSD_NON_NEGATIVE_INTEGER;
            }
            case "xsd:positiveInteger": {
                return AttributeDataType.XSD_POSITIVE_INTEGER;
            }
            case "xsd:unsignedLong": {
                return AttributeDataType.XSD_UNSIGNED_LONG;
            }
            case "xsd:unsignedInt": {
                return AttributeDataType.XSD_UNSIGNED_INT;
            }
            case "xsd:unsignedShort": {
                return AttributeDataType.XSD_UNSIGNED_SHORT;
            }
            case "xsd:unsignedByte": {
                return AttributeDataType.XSD_UNSIGNED_BYTE;
            }
            case "xsd:yearMonthDuration": {
                return AttributeDataType.XSD_YEARMONTHDURATION;
            }
        }
        throw new RuntimeException("This dataType IRI is not supported: " + code);
    }

    public static String getUri(AttributeDataType dataType) {
        switch (dataType) {
            case BOOLEAN: 
            case XSD_BOOLEAN: {
                return "http://www.w3.org/2001/XMLSchema#boolean";
            }
            case DATE: 
            case XSD_DATETIME: {
                return "http://www.w3.org/2001/XMLSchema#dateTime";
            }
            case DOUBLE: 
            case XSD_DOUBLE: {
                return "http://www.w3.org/2001/XMLSchema#double";
            }
            case STRING: 
            case XSD_STRING: {
                return "http://www.w3.org/2001/XMLSchema#string";
            }
            case RDF_LANGSTRING: {
                return "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
            }
            case XSD_DURATION: {
                return "http://www.w3.org/2001/XMLSchema#duration";
            }
            case XSD_DAYTIMEDURATION: {
                return "http://www.w3.org/2001/XMLSchema#dayTimeDuration";
            }
            case XSD_TIME: {
                return "http://www.w3.org/2001/XMLSchema#time";
            }
            case XSD_DATE: {
                return "http://www.w3.org/2001/XMLSchema#date";
            }
            case XSD_GYEARMONTH: {
                return "http://www.w3.org/2001/XMLSchema#gYearMonth";
            }
            case XSD_GYEAR: {
                return "http://www.w3.org/2001/XMLSchema#gYear";
            }
            case XSD_GMONTHDAY: {
                return "http://www.w3.org/2001/XMLSchema#gMonthDay";
            }
            case XSD_GDAY: {
                return "http://www.w3.org/2001/XMLSchema#gDay";
            }
            case XSD_GMONTH: {
                return "http://www.w3.org/2001/XMLSchema#gMonth";
            }
            case XSD_BASE64BINARY: {
                return "http://www.w3.org/2001/XMLSchema#base64Binary";
            }
            case XSD_HEXBINARY: {
                return "http://www.w3.org/2001/XMLSchema#hexBinary";
            }
            case XSD_FLOAT: {
                return "http://www.w3.org/2001/XMLSchema#float";
            }
            case XSD_DECIMAL: {
                return "http://www.w3.org/2001/XMLSchema#decimal";
            }
            case XSD_ANYURI: {
                return "http://www.w3.org/2001/XMLSchema#anyURI";
            }
            case XSD_QNAME: {
                return "http://www.w3.org/2001/XMLSchema#QName";
            }
            case XSD_NOTATION: {
                return "http://www.w3.org/2001/XMLSchema#NOTATION";
            }
            case XSD_NORMALIZEDSTRING: {
                return "http://www.w3.org/2001/XMLSchema#normalizedString";
            }
            case XSD_TOKEN: {
                return "http://www.w3.org/2001/XMLSchema#token";
            }
            case XSD_LANGUAGE: {
                return "http://www.w3.org/2001/XMLSchema#language";
            }
            case XSD_NMTOKEN: {
                return "http://www.w3.org/2001/XMLSchema#NMTOKEN";
            }
            case XSD_NMTOKENS: {
                return "http://www.w3.org/2001/XMLSchema#NMTOKENS";
            }
            case XSD_NAME: {
                return "http://www.w3.org/2001/XMLSchema#Name";
            }
            case XSD_NCNAME: {
                return "http://www.w3.org/2001/XMLSchema#NCName";
            }
            case XSD_ID: {
                return "http://www.w3.org/2001/XMLSchema#ID";
            }
            case XSD_IDREF: {
                return "http://www.w3.org/2001/XMLSchema#IDREF";
            }
            case XSD_IDREFS: {
                return "http://www.w3.org/2001/XMLSchema#IDREFS";
            }
            case XSD_ENTITY: {
                return "http://www.w3.org/2001/XMLSchema#ENTITY";
            }
            case XSD_ENTITIES: {
                return "http://www.w3.org/2001/XMLSchema#ENTITIES";
            }
            case XSD_INTEGER: {
                return "http://www.w3.org/2001/XMLSchema#integer";
            }
            case XSD_LONG: {
                return "http://www.w3.org/2001/XMLSchema#long";
            }
            case XSD_INT: {
                return "http://www.w3.org/2001/XMLSchema#int";
            }
            case XSD_SHORT: {
                return "http://www.w3.org/2001/XMLSchema#short";
            }
            case XSD_BYTE: {
                return "http://www.w3.org/2001/XMLSchema#byte";
            }
            case XSD_NON_POSITIVE_INTEGER: {
                return "http://www.w3.org/2001/XMLSchema#nonPositiveInteger";
            }
            case XSD_NEGATIVE_INTEGER: {
                return "http://www.w3.org/2001/XMLSchema#negativeInteger";
            }
            case XSD_NON_NEGATIVE_INTEGER: {
                return "http://www.w3.org/2001/XMLSchema#nonNegativeInteger";
            }
            case XSD_POSITIVE_INTEGER: {
                return "http://www.w3.org/2001/XMLSchema#positiveInteger";
            }
            case XSD_UNSIGNED_LONG: {
                return "http://www.w3.org/2001/XMLSchema#unsignedLong";
            }
            case XSD_UNSIGNED_INT: {
                return "http://www.w3.org/2001/XMLSchema#unsignedInt";
            }
            case XSD_UNSIGNED_SHORT: {
                return "http://www.w3.org/2001/XMLSchema#unsignedShort";
            }
            case XSD_UNSIGNED_BYTE: {
                return "http://www.w3.org/2001/XMLSchema#unsignedByte";
            }
            case XSD_YEARMONTHDURATION: {
                return "http://www.w3.org/2001/XMLSchema#yearMonthDuration";
            }
        }
        throw new RuntimeException("This dataType is not supported: " + (Object)((Object)dataType));
    }

    public static PrimitiveDataType primitiveDataType(AttributeDataType dataType) {
        switch (dataType) {
            case BOOLEAN: 
            case XSD_BOOLEAN: {
                return PrimitiveDataType.BOOLEAN;
            }
            case DATE: 
            case XSD_DATETIME: {
                return PrimitiveDataType.DATE;
            }
            case DOUBLE: 
            case XSD_FLOAT: 
            case XSD_DECIMAL: 
            case XSD_DOUBLE: 
            case XSD_LONG: 
            case XSD_INT: 
            case XSD_SHORT: 
            case XSD_BYTE: 
            case XSD_NON_POSITIVE_INTEGER: 
            case XSD_NEGATIVE_INTEGER: 
            case XSD_NON_NEGATIVE_INTEGER: 
            case XSD_POSITIVE_INTEGER: 
            case XSD_UNSIGNED_LONG: 
            case XSD_UNSIGNED_INT: 
            case XSD_UNSIGNED_SHORT: 
            case XSD_UNSIGNED_BYTE: {
                return PrimitiveDataType.DOUBLE;
            }
            case STRING: 
            case RDF_LANGSTRING: 
            case XSD_DURATION: 
            case XSD_DAYTIMEDURATION: 
            case XSD_TIME: 
            case XSD_DATE: 
            case XSD_GYEARMONTH: 
            case XSD_GYEAR: 
            case XSD_GMONTHDAY: 
            case XSD_GDAY: 
            case XSD_GMONTH: 
            case XSD_STRING: 
            case XSD_BASE64BINARY: 
            case XSD_HEXBINARY: 
            case XSD_ANYURI: 
            case XSD_QNAME: 
            case XSD_NOTATION: 
            case XSD_NORMALIZEDSTRING: 
            case XSD_TOKEN: 
            case XSD_LANGUAGE: 
            case XSD_NMTOKEN: 
            case XSD_NMTOKENS: 
            case XSD_NAME: 
            case XSD_NCNAME: 
            case XSD_ID: 
            case XSD_IDREF: 
            case XSD_IDREFS: 
            case XSD_ENTITY: 
            case XSD_ENTITIES: 
            case XSD_INTEGER: 
            case XSD_YEARMONTHDURATION: {
                return PrimitiveDataType.STRING;
            }
        }
        throw new RuntimeException("This dataType is not supported: " + (Object)((Object)dataType));
    }
}

