/*
 * Decompiled with CFR 0.152.
 */
package com.zenlayercloud.common;

import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.interceptor.InterceptorChain;
import com.aliyun.tea.interceptor.RequestInterceptor;
import com.aliyun.tea.interceptor.ResponseInterceptor;
import com.aliyun.tea.interceptor.RuntimeOptionsInterceptor;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import com.zenlayercloud.common.ApiUtil;
import com.zenlayercloud.common.Config;
import com.zenlayercloud.common.Credential;
import com.zenlayercloud.common.ZenlayerSdkException;
import java.io.InputStream;
import java.util.Map;

public class AbstractClient {
    private final InterceptorChain interceptorChain = InterceptorChain.create();
    public static final String SDK_VERSION = "0.6.7";
    private final Credential _credential;
    private final String _endpoint;
    private final String _protocol;
    private final String _method;
    private final String _userAgent;
    private final Integer _readTimeout;
    private final Integer _connectTimeout;
    private final String _httpProxy;
    private final String _httpsProxy;
    private final String _noProxy;
    private final String _socks5Proxy;
    private final String _socks5NetWork;
    private final Integer _maxIdleConns;
    private final String _signatureVersion;
    private final String _signatureAlgorithm;
    private final String _service;
    private final String _apiVersion;
    private final String _path;

    public AbstractClient(Credential credential, Config config, String endpoint, String apiVersion, String path) {
        this._credential = credential;
        this._protocol = config.protocol;
        this._method = config.method;
        this._userAgent = config.userAgent;
        this._readTimeout = config.readTimeout;
        this._connectTimeout = config.connectTimeout;
        this._httpProxy = config.httpProxy;
        this._httpsProxy = config.httpsProxy;
        this._noProxy = config.noProxy;
        this._socks5Proxy = config.socks5Proxy;
        this._socks5NetWork = config.socks5NetWork;
        this._maxIdleConns = config.maxIdleConns;
        this._signatureVersion = config.signatureVersion;
        this._signatureAlgorithm = config.signatureAlgorithm;
        this._endpoint = endpoint;
        this._apiVersion = apiVersion;
        this._service = path.replace("/api/v2/", "");
        this._path = path;
    }

    protected Map<String, ?> callApi(TeaModel request, String actionName, RuntimeOptions runtime) {
        if (Common.isUnset((Object)TeaModel.buildMap((TeaModel)request))) {
            throw new ZenlayerSdkException("'request' can not be unset");
        }
        this.validateParams(request);
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("socks5Proxy", (Object)Common.defaultString((String)runtime.socks5Proxy, (String)this._socks5Proxy)), new TeaPair("socks5NetWork", (Object)Common.defaultString((String)runtime.socks5NetWork, (String)this._socks5NetWork)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        TeaResponse _lastResponse = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaResponse response_;
                TeaRequest request_ = new TeaRequest();
                request_.protocol = this._protocol;
                request_.method = this._method;
                request_.pathname = this._path;
                request_.headers = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("date", (Object)Common.getDateUTCString()), new TeaPair("host", (Object)this._endpoint), new TeaPair("accept", (Object)"application/json"), new TeaPair("x-zc-signature-method", (Object)this._signatureAlgorithm), new TeaPair("x-zc-signature-version", (Object)this._signatureVersion), new TeaPair("x-zc-version", (Object)this._apiVersion), new TeaPair("x-zc-action", (Object)actionName), new TeaPair("x-zc-service", (Object)this._service), new TeaPair("x-zc-sdk-lang", (Object)"java"), new TeaPair("x-zc-sdk-version", (Object)SDK_VERSION), new TeaPair("user-agent", (Object)Common.getUserAgent((String)this._userAgent))});
                Map param = request.toMap();
                String bodyString = Common.toJSONString((Object)param);
                request_.body = Tea.toReadable((String)bodyString);
                request_.headers.put("content-type", "application/json; charset=utf-8");
                String authorization = ApiUtil.getAuthorization(request_, this._endpoint, this._signatureAlgorithm, bodyString, this._credential.getAccessKeyId(), this._credential.getAccessKeyPassword());
                request_.headers.put("Authorization", authorization);
                _lastRequest = request_;
                _lastResponse = response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_, (InterceptorChain)this.interceptorChain);
                if (Common.equalNumber((Number)response_.statusCode, (Number)204)) {
                    Map map = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
                    return map;
                }
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Object _res = Common.readAsJSON((InputStream)response_.body);
                    Map err = Common.assertAsMap((Object)_res);
                    Object errorCode = err.get("code");
                    Object requestId = err.get("requestId");
                    throw new ZenlayerSdkException(requestId + "", "HTTP Status: " + response_.statusCode + ", ErrorCode: " + errorCode + ", Message: " + err.get("message") + ", RequestId: " + requestId, errorCode + "");
                }
                Object obj = Common.readAsJSON((InputStream)response_.body);
                Map res = Common.assertAsMap((Object)obj);
                Map map = (Map)res.get("response");
                return map;
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw new ZenlayerSdkException(e);
            }
            finally {
                if (Common.isUnset(_lastResponse) || Common.isUnset((Object)_lastResponse.response) || Common.isUnset((Object)_lastResponse.response.body())) continue;
                _lastResponse.response.close();
            }
        }
        throw new ZenlayerSdkException("request is unreachable", _lastException);
    }

    private void validateParams(TeaModel request) {
        try {
            request.validate();
        }
        catch (Exception e) {
            throw new ZenlayerSdkException("Parameter illegal", e);
        }
    }

    public void addRuntimeOptionsInterceptor(RuntimeOptionsInterceptor interceptor) {
        this.interceptorChain.addRuntimeOptionsInterceptor(interceptor);
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        this.interceptorChain.addRequestInterceptor(interceptor);
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        this.interceptorChain.addResponseInterceptor(interceptor);
    }
}

