/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.queue;

import dk.cloudcreate.essentials.components.queue.QueueEntryId;
import dk.cloudcreate.essentials.components.queue.QueueName;
import dk.cloudcreate.essentials.shared.FailFast;
import java.time.OffsetDateTime;
import java.util.Objects;

public class QueuedMessage {
    public final QueueEntryId id;
    public final QueueName queueName;
    public final Object payload;
    public final OffsetDateTime addedTimestamp;
    public final OffsetDateTime nextDeliveryTimestamp;
    public final String lastDeliveryError;
    public final int totalDeliveryAttempts;
    public final int redeliveryAttempts;
    public final boolean isDeadLetterMessage;

    public QueuedMessage(QueueEntryId id, QueueName queueName, Object payload, OffsetDateTime addedTimestamp, OffsetDateTime nextDeliveryTimestamp, String lastDeliveryError, int totalDeliveryAttempts, int redeliveryAttempts, boolean isDeadLetterMessage) {
        this.id = (QueueEntryId)((Object)FailFast.requireNonNull((Object)((Object)id), (String)"No queue entry id provided"));
        this.queueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided"));
        this.payload = FailFast.requireNonNull((Object)payload, (String)"No payload provided");
        this.addedTimestamp = (OffsetDateTime)FailFast.requireNonNull((Object)addedTimestamp, (String)"No addedTimestamp provided");
        this.nextDeliveryTimestamp = nextDeliveryTimestamp;
        this.lastDeliveryError = lastDeliveryError;
        this.totalDeliveryAttempts = totalDeliveryAttempts;
        this.redeliveryAttempts = redeliveryAttempts;
        this.isDeadLetterMessage = isDeadLetterMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueuedMessage)) {
            return false;
        }
        QueuedMessage that = (QueuedMessage)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id});
    }

    public String toString() {
        return "QueuedMessage{id=" + this.id + ", queueName=" + this.queueName + ", payload-type=" + this.payload.getClass().getName() + ", addedTimestamp=" + this.addedTimestamp + ", nextDeliveryTimestamp=" + this.nextDeliveryTimestamp + ", totalDeliveryAttempts=" + this.totalDeliveryAttempts + ", redeliveryAttempts=" + this.redeliveryAttempts + ", isDeadLetterMessage=" + this.isDeadLetterMessage + ", lastDeliveryError='" + this.lastDeliveryError + "'}";
    }
}

