/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.queue;

import dk.cloudcreate.essentials.components.queue.QueueEntryId;
import dk.cloudcreate.essentials.components.queue.QueueName;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.Optional;

public class DurableQueueException
extends RuntimeException {
    public final QueueName queueName;
    public final Optional<QueueEntryId> queueEntryId;

    public DurableQueueException(String message, QueueName queueName) {
        this(message, null, queueName, null);
    }

    public DurableQueueException(String message, Throwable cause, QueueName queueName) {
        this(message, cause, queueName, null);
    }

    public DurableQueueException(Throwable cause, QueueName queueName) {
        this(null, cause, queueName, null);
    }

    public DurableQueueException(String message, QueueName queueName, QueueEntryId queueEntryId) {
        this(message, null, queueName, queueEntryId);
    }

    public DurableQueueException(Throwable cause, QueueName queueName, QueueEntryId queueEntryId) {
        this(null, cause, queueName, queueEntryId);
    }

    public DurableQueueException(String message, Throwable cause, QueueName queueName, QueueEntryId queueEntryId) {
        super(DurableQueueException.enrichMessage(message, queueName, queueEntryId), cause);
        this.queueName = queueName;
        this.queueEntryId = Optional.of(queueEntryId);
    }

    private static String enrichMessage(String message, QueueName queueName, QueueEntryId queueEntryId) {
        Object messageToLog;
        FailFast.requireNonNull((Object)((Object)queueEntryId), (String)"queueEntryId option is missing");
        Object object = messageToLog = message != null ? " " + message : "";
        if (queueEntryId != null) {
            return MessageFormatter.msg((String)"[{}:{}]{}", (Object[])new Object[]{FailFast.requireNonNull((Object)((Object)queueName), (String)"queueName missing"), queueEntryId, messageToLog});
        }
        return MessageFormatter.msg((String)"[{}]{}", (Object[])new Object[]{FailFast.requireNonNull((Object)((Object)queueName), (String)"queueName missing"), messageToLog});
    }
}

