/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.queue;

import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Duration;

public class QueueRedeliveryPolicy {
    public final Duration initialRedeliveryDelay;
    public final Duration followupRedeliveryDelay;
    public final double followupRedeliveryDelayMultiplier;
    public final Duration maximumFollowupRedeliveryThreshold;
    public final int maximumNumberOfRedeliveries;

    public QueueRedeliveryPolicy(Duration initialRedeliveryDelay, Duration followupRedeliveryDelay, double followupRedeliveryDelayMultiplier, Duration maximumFollowupRedeliveryDelayThreshold, int maximumNumberOfRedeliveries) {
        this.initialRedeliveryDelay = (Duration)FailFast.requireNonNull((Object)initialRedeliveryDelay, (String)"You must specify an initialRedeliveryDelay");
        this.followupRedeliveryDelay = (Duration)FailFast.requireNonNull((Object)followupRedeliveryDelay, (String)"You must specify an followupRedeliveryDelay");
        this.followupRedeliveryDelayMultiplier = followupRedeliveryDelayMultiplier;
        this.maximumFollowupRedeliveryThreshold = (Duration)FailFast.requireNonNull((Object)maximumFollowupRedeliveryDelayThreshold, (String)"You must specify an maximumFollowupRedeliveryDelayThreshold");
        this.maximumNumberOfRedeliveries = maximumNumberOfRedeliveries;
    }

    public Duration calculateNextRedeliveryDelay(int currentNumberOfRedeliveryAttempts) {
        FailFast.requireTrue((currentNumberOfRedeliveryAttempts >= 0 ? 1 : 0) != 0, (String)"currentNumberOfRedeliveryAttempts must be 0 or larger");
        if (currentNumberOfRedeliveryAttempts == 0) {
            return this.initialRedeliveryDelay;
        }
        Duration calculatedRedeliveryDelay = this.initialRedeliveryDelay.plus(Duration.ofMillis((long)((double)this.followupRedeliveryDelay.toMillis() * this.followupRedeliveryDelayMultiplier)));
        if (calculatedRedeliveryDelay.compareTo(this.maximumFollowupRedeliveryThreshold) >= 0) {
            return this.maximumFollowupRedeliveryThreshold;
        }
        return calculatedRedeliveryDelay;
    }

    public static QueueRedeliveryPolicy fixedBackoff(Duration redeliveryDelay, int maximumNumberOfRedeliveries) {
        return new QueueRedeliveryPolicy(redeliveryDelay, redeliveryDelay, 1.0, redeliveryDelay, maximumNumberOfRedeliveries);
    }

    public static QueueRedeliveryPolicy linearBackoff(Duration redeliveryDelay, Duration maximumFollowupRedeliveryDelayThreshold, int maximumNumberOfRedeliveries) {
        return new QueueRedeliveryPolicy(redeliveryDelay, redeliveryDelay, 1.0, maximumFollowupRedeliveryDelayThreshold, maximumNumberOfRedeliveries);
    }

    public static QueueRedeliveryPolicy exponentialBackoff(Duration initialRedeliveryDelay, Duration followupRedeliveryDelay, double followupRedeliveryDelayMultiplier, Duration maximumFollowupRedeliveryDelayThreshold, int maximumNumberOfRedeliveries) {
        return new QueueRedeliveryPolicy(initialRedeliveryDelay, followupRedeliveryDelay, followupRedeliveryDelayMultiplier, maximumFollowupRedeliveryDelayThreshold, maximumNumberOfRedeliveries);
    }
}

