/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.crypto;

import im.actor.api.crypto.Crypto;
import im.actor.api.crypto.Utils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FileCipher {
    private static final int AES_KEY_SIZE = 32;
    private static final int MAC_KEY_SIZE = 32;
    private final Cipher cipher = Crypto.createAESCipher();
    private final Mac mac = Crypto.createHmacSHA256();
    private final byte[] cipherKey;
    private final byte[] macKey;
    private final SecretKeySpec cipherKeySpec;
    private final SecretKeySpec macKeySpec;

    public FileCipher() {
        this.cipherKey = Crypto.generateSeed(32);
        this.macKey = Crypto.generateSeed(32);
        this.cipherKeySpec = new SecretKeySpec(this.cipherKey, "AES");
        this.macKeySpec = new SecretKeySpec(this.macKey, "HmacSHA256");
    }

    public FileCipher(byte[] key) {
        if (key.length != 64) {
            throw new IllegalArgumentException("key.length != 64");
        }
        byte[][] sKey = Utils.split(key, 32, 32);
        this.cipherKey = sKey[0];
        this.macKey = sKey[1];
        this.cipherKeySpec = new SecretKeySpec(this.cipherKey, "AES");
        this.macKeySpec = new SecretKeySpec(this.macKey, "HmacSHA256");
    }

    public byte[] getKey() {
        return Utils.concat(this.cipherKey, this.macKey);
    }

    public synchronized byte[] encrypt(byte[] plainText) {
        try {
            this.cipher.init(1, this.cipherKeySpec);
            this.mac.init(this.macKeySpec);
            byte[] ciphertext = this.cipher.doFinal(plainText);
            byte[] iv = this.cipher.getIV();
            this.mac.update(iv);
            byte[] macValue = this.mac.doFinal(ciphertext);
            return Utils.concat(iv, ciphertext, macValue);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized byte[] decrypt(byte[] cipherText) {
        try {
            if (cipherText.length <= this.cipher.getBlockSize() + this.mac.getMacLength()) {
                throw new IllegalArgumentException("Message is too short");
            }
            this.mac.init(this.macKeySpec);
            byte[][] ciphertextParts = Utils.split(cipherText, this.cipher.getBlockSize(), cipherText.length - this.cipher.getBlockSize() - this.mac.getMacLength(), this.mac.getMacLength());
            this.mac.update(cipherText, 0, cipherText.length - this.mac.getMacLength());
            byte[] ourMac = this.mac.doFinal();
            if (!Utils.equals(ourMac, ciphertextParts[2])) {
                throw new IllegalArgumentException("Mac doesn't match!");
            }
            this.cipher.init(2, (Key)this.cipherKeySpec, new IvParameterSpec(ciphertextParts[0]));
            return this.cipher.doFinal(ciphertextParts[1]);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new AssertionError((Object)e);
        }
        catch (BadPaddingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized void encrypt(String srcFile, String destFile) throws IOException {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int count;
            inputStream = new FileInputStream(srcFile);
            outputStream = new FileOutputStream(destFile);
            this.cipher.init(1, this.cipherKeySpec);
            this.mac.init(this.macKeySpec);
            byte[] iv = this.cipher.getIV();
            this.mac.update(iv);
            outputStream.write(iv);
            byte[] buffer = new byte[1024];
            byte[] out = new byte[this.cipher.getOutputSize(1024)];
            while ((count = inputStream.read(buffer)) > 0) {
                byte[] oB;
                int obSize;
                try {
                    obSize = this.cipher.update(buffer, 0, count, out, 0);
                    oB = out;
                }
                catch (ShortBufferException e) {
                    e.printStackTrace();
                    oB = this.cipher.update(buffer, 0, count);
                    obSize = oB.length;
                }
                this.mac.update(oB, 0, obSize);
                outputStream.write(oB, 0, obSize);
            }
            out = this.cipher.doFinal();
            this.mac.update(out);
            outputStream.write(out);
            byte[] macValue = this.mac.doFinal();
            outputStream.write(macValue);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void decrypt(String srcFile, String destFile) throws IOException {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int count;
            inputStream = new FileInputStream(srcFile);
            outputStream = new FileOutputStream(destFile);
            int fileSize = inputStream.available();
            int contentSize = fileSize - this.mac.getMacLength() - this.cipher.getBlockSize();
            byte[] iv = Utils.readBytes(this.cipher.getBlockSize(), inputStream);
            this.cipher.init(2, (Key)this.cipherKeySpec, new IvParameterSpec(iv));
            this.mac.init(this.macKeySpec);
            this.mac.update(iv);
            byte[] buffer = new byte[1024];
            byte[] out = new byte[this.cipher.getOutputSize(1024)];
            int readSize = 0;
            while ((count = inputStream.read(buffer, 0, Math.min(contentSize - readSize, buffer.length))) > 0) {
                byte[] oB;
                int obSize;
                readSize += count;
                this.mac.update(buffer, 0, count);
                try {
                    obSize = this.cipher.update(buffer, 0, count, out, 0);
                    oB = out;
                }
                catch (ShortBufferException e) {
                    e.printStackTrace();
                    oB = this.cipher.update(buffer, 0, count);
                    obSize = oB.length;
                }
                outputStream.write(oB, 0, obSize);
            }
            out = this.cipher.doFinal();
            outputStream.write(out);
            byte[] ourMac = this.mac.doFinal();
            byte[] msgMac = Utils.readBytes(this.mac.getMacLength(), inputStream);
            if (!Utils.equals(ourMac, msgMac)) {
                throw new RuntimeException("Incorrect MAC");
            }
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

