/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.crypto;

import im.actor.api.crypto.Crypto;
import im.actor.api.crypto.Utils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class ObsoleteFileCipher {
    private final Cipher cipher = Crypto.createAESCipher();
    private final byte[] cipherAesKey;
    private final byte[] cipherAesIv;

    public ObsoleteFileCipher(byte[] key) {
        byte[][] sKey = Utils.split(key, 32, 16);
        this.cipherAesKey = sKey[0];
        this.cipherAesIv = sKey[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void decrypt(String srcFile, String destFile) throws IOException {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int count;
            inputStream = new FileInputStream(srcFile);
            outputStream = new FileOutputStream(destFile);
            this.cipher.init(2, (Key)new SecretKeySpec(this.cipherAesKey, "AES"), new IvParameterSpec(this.cipherAesIv));
            byte[] buffer = new byte[1024];
            byte[] out = new byte[this.cipher.getOutputSize(1024)];
            while ((count = inputStream.read(buffer)) > 0) {
                byte[] oB;
                int obSize;
                try {
                    obSize = this.cipher.update(buffer, 0, count, out, 0);
                    oB = out;
                }
                catch (ShortBufferException e) {
                    e.printStackTrace();
                    oB = this.cipher.update(buffer, 0, count);
                    obSize = oB.length;
                }
                outputStream.write(oB, 0, obSize);
            }
            out = this.cipher.doFinal();
            outputStream.write(out);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

