/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.actors;

import com.droidkit.actors.Actor;
import com.droidkit.actors.ActorCreator;
import com.droidkit.actors.ActorRef;
import com.droidkit.actors.ActorSelection;
import com.droidkit.actors.Props;
import im.actor.api.LogInterface;
import im.actor.api.mtp.MTProto;
import im.actor.api.mtp._internal.MTUids;
import im.actor.api.mtp._internal.actors.SenderActor;
import im.actor.api.mtp._internal.entity.ProtoMessage;
import im.actor.api.mtp._internal.entity.ProtoSerializer;
import im.actor.api.mtp._internal.entity.ProtoStruct;
import im.actor.api.mtp._internal.entity.message.Container;
import im.actor.api.mtp._internal.entity.message.Drop;
import im.actor.api.mtp._internal.entity.message.MessageAck;
import im.actor.api.mtp._internal.entity.message.NewSession;
import im.actor.api.mtp._internal.entity.message.Ping;
import im.actor.api.mtp._internal.entity.message.Pong;
import im.actor.api.mtp._internal.entity.message.RequestResend;
import im.actor.api.mtp._internal.entity.message.RpcResponseBox;
import im.actor.api.mtp._internal.entity.message.UnsentMessage;
import im.actor.api.mtp._internal.entity.message.UnsentResponse;
import im.actor.api.mtp._internal.entity.message.UpdateBox;
import im.actor.api.mtp._internal.entity.message.rpc.RpcError;
import im.actor.api.mtp._internal.entity.message.rpc.RpcOk;
import im.actor.api.mtp.messages.AuthIdInvalidated;
import im.actor.api.mtp.messages.Confirmed;
import im.actor.api.mtp.messages.NewSessionCreated;
import im.actor.api.mtp.messages.RpcMessage;
import im.actor.api.mtp.messages.Update;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class ReceiverActor
extends Actor {
    private static final String TAG = "ProtoReceiver";
    private static final int MAX_RECEIVED_BUFFER = 1000;
    private final LogInterface LOG;
    private final boolean DEBUG;
    private ActorRef sender;
    private ActorRef stateBroker;
    private MTProto proto;
    private MTUids uids;
    private ArrayList<Long> receivedMessages = new ArrayList();

    public static ActorSelection receiver(final MTProto proto) {
        return new ActorSelection(Props.create(ReceiverActor.class, (ActorCreator)new ActorCreator<ReceiverActor>(){

            public ReceiverActor create() {
                return new ReceiverActor(proto);
            }
        }), proto.getPath() + "/receiver");
    }

    public ReceiverActor(MTProto proto) {
        this.proto = proto;
        this.stateBroker = proto.getStateBroker();
        this.uids = proto.getUids();
        this.LOG = proto.getParams().getConfig().getLogInterface();
        this.DEBUG = proto.getParams().getConfig().isDebugProto();
    }

    public void preStart() {
        this.sender = this.system().actorOf(SenderActor.senderActor(this.proto));
    }

    public void onReceive(Object message) {
        if (message instanceof ProtoMessage) {
            this.onReceive((ProtoMessage)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReceive(ProtoMessage message) {
        block51: {
            boolean disableConfirm = false;
            try {
                ProtoStruct obj;
                if (this.LOG != null && this.DEBUG) {
                    this.LOG.d(TAG, "Received message #" + message.messageId);
                }
                if (this.receivedMessages.contains(message.messageId)) {
                    if (this.LOG != null) {
                        this.LOG.w(TAG, "Already received message #" + message.messageId + ": ignoring");
                    }
                    return;
                }
                if (this.receivedMessages.size() >= 1000) {
                    this.receivedMessages.remove(0);
                    this.receivedMessages.add(message.messageId);
                }
                try {
                    obj = ProtoSerializer.readMessagePayload(message.payload);
                }
                catch (IOException e) {
                    if (this.LOG != null) {
                        this.LOG.w(TAG, "Unable to parse message: ignoring");
                    }
                    e.printStackTrace();
                    if (!disableConfirm) {
                        this.sender.send((Object)new SenderActor.ConfirmMessage(message.messageId));
                    }
                    return;
                }
                if (this.LOG != null && this.DEBUG) {
                    this.LOG.d(TAG, "Loaded " + obj);
                }
                if (obj instanceof Pong) {
                    break block51;
                }
                if (obj instanceof Ping) {
                    Ping ping = (Ping)obj;
                    this.sender.send((Object)new SenderActor.SendMessage(this.uids.nextId(), new Pong(ping.getRandomId()), false));
                    break block51;
                }
                if (obj instanceof Drop) {
                    Drop drop = (Drop)obj;
                    if (drop.message != null) {
                        String dropMessage = drop.message.toLowerCase();
                        if (dropMessage.contains("unknown") && dropMessage.contains("auth")) {
                            this.stateBroker.send((Object)new AuthIdInvalidated());
                        }
                        if (this.LOG != null) {
                            this.LOG.w(TAG, "DROP:" + drop.getMessage());
                        }
                    }
                    break block51;
                }
                if (obj instanceof NewSession) {
                    this.sender.send((Object)new SenderActor.NewSession());
                    this.stateBroker.send((Object)new NewSessionCreated());
                    break block51;
                }
                if (obj instanceof Container) {
                    Container container = (Container)obj;
                    for (ProtoMessage m : container.getMessages()) {
                        this.self().send((Object)m, this.sender());
                    }
                    break block51;
                }
                if (obj instanceof RpcResponseBox) {
                    RpcResponseBox responseBox = (RpcResponseBox)obj;
                    if (this.LOG != null && this.DEBUG) {
                        this.LOG.d(TAG, "Response #" + responseBox.getMessageId());
                    }
                    this.sender.send((Object)new SenderActor.RpcResponseReceived(responseBox.getMessageId()));
                    try {
                        ProtoStruct payload = ProtoSerializer.readRpcResponsePayload(responseBox.getPayload());
                        if (this.LOG != null && this.DEBUG) {
                            this.LOG.d(TAG, "Loaded " + payload + " from RpcResponseBox");
                        }
                        if (payload instanceof RpcOk) {
                            RpcOk rpcOk = (RpcOk)payload;
                            this.stateBroker.send((Object)new RpcMessage(responseBox.getMessageId(), rpcOk.responseType, rpcOk.payload));
                        } else if (payload instanceof RpcError) {
                            RpcError rpcError = (RpcError)payload;
                            this.stateBroker.send((Object)new im.actor.api.mtp.messages.RpcError(responseBox.getMessageId(), rpcError.errorCode, rpcError.errorTag, rpcError.userMessage, rpcError.canTryAgain, rpcError.relatedData));
                        } else if (this.LOG != null) {
                            this.LOG.w(TAG, "Unsupported RpcResponse type");
                        }
                        break block51;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (this.LOG != null) {
                            this.LOG.w(TAG, "Unable to load data from UpdateBox");
                        }
                        break block51;
                    }
                }
                if (obj instanceof MessageAck) {
                    MessageAck ack = (MessageAck)obj;
                    if (this.LOG != null && this.DEBUG) {
                        this.LOG.d(TAG, "Ack " + Arrays.toString(ack.messagesIds));
                    }
                    for (long ackMsgId : ack.messagesIds) {
                        this.sender.send((Object)new SenderActor.ForgetMessage(ackMsgId));
                        this.stateBroker.send((Object)new Confirmed(message.messageId));
                    }
                } else if (obj instanceof UpdateBox) {
                    UpdateBox box = (UpdateBox)obj;
                    try {
                        im.actor.api.mtp._internal.entity.message.rpc.Update update = ProtoSerializer.readUpdate(box.getPayload());
                        this.stateBroker.send((Object)new Update(update.updateType, update.body));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (this.LOG != null) {
                            this.LOG.w(TAG, "Unable to load data from UpdateBox");
                        }
                    }
                } else if (obj instanceof UnsentResponse) {
                    UnsentResponse unsent = (UnsentResponse)obj;
                    if (!this.receivedMessages.contains(unsent.getResponseMessageId())) {
                        disableConfirm = true;
                        this.sender.send((Object)new SenderActor.SendMessage(this.uids.nextId(), new RequestResend(unsent.getMessageId()), false));
                    }
                } else if (obj instanceof UnsentMessage) {
                    UnsentMessage unsent = (UnsentMessage)obj;
                    if (!this.receivedMessages.contains(unsent.getMessageId())) {
                        disableConfirm = true;
                        this.sender.send((Object)new SenderActor.SendMessage(this.uids.nextId(), new RequestResend(unsent.getMessageId()), false));
                    }
                } else if (this.LOG != null) {
                    this.LOG.w(TAG, "Unsupported package " + obj.getClass().getCanonicalName());
                }
            }
            finally {
                if (!disableConfirm) {
                    this.sender.send((Object)new SenderActor.ConfirmMessage(message.messageId));
                }
            }
        }
    }
}

