/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.entity.message;

import im.actor.api.mtp._internal.entity.ProtoMessage;
import im.actor.api.mtp._internal.entity.ProtoStruct;
import im.actor.api.util.StreamingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Container
extends ProtoStruct {
    public static final byte HEADER = 10;
    private ProtoMessage[] messages;

    public Container(InputStream stream) throws IOException {
        super(stream);
    }

    public Container(ProtoMessage[] messages) {
        this.messages = messages;
    }

    public ProtoMessage[] getMessages() {
        return this.messages;
    }

    @Override
    public int getLength() {
        int messagesLength = 0;
        if (this.messages.length > 0) {
            for (ProtoMessage m : this.messages) {
                messagesLength += m.getLength();
            }
        }
        return 1 + StreamingUtils.varintSize(this.messages.length) + messagesLength;
    }

    @Override
    protected byte getHeader() {
        return 10;
    }

    @Override
    protected void writeBody(OutputStream bs) throws IOException {
        if (this.messages != null && this.messages.length > 0) {
            StreamingUtils.writeVarInt(this.messages.length, bs);
            for (ProtoMessage m : this.messages) {
                m.writeObject(bs);
            }
        } else {
            StreamingUtils.writeVarInt(0L, bs);
        }
    }

    @Override
    protected void readBody(InputStream bs) throws IOException {
        int size = (int)StreamingUtils.readVarInt(bs);
        this.messages = new ProtoMessage[size];
        for (int i = 0; i < size; ++i) {
            this.messages[i] = new ProtoMessage(bs);
        }
    }

    public String toString() {
        return "Conatiner[" + this.messages.length + " items]";
    }
}

