/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.scheme.rpc;

import com.droidkit.bser.Bser;
import com.droidkit.bser.BserObject;
import com.droidkit.bser.BserValues;
import com.droidkit.bser.BserWriter;
import im.actor.api.parser.Request;
import im.actor.api.scheme.OutPeer;
import im.actor.api.scheme.rpc.ResponseLoadHistory;
import java.io.IOException;

public class RequestLoadHistory
extends Request<ResponseLoadHistory> {
    public static final int HEADER = 118;
    private OutPeer peer;
    private long startDate;
    private int limit;

    public static RequestLoadHistory fromBytes(byte[] data) throws IOException {
        return (RequestLoadHistory)Bser.parse(RequestLoadHistory.class, (byte[])data);
    }

    public RequestLoadHistory(OutPeer peer, long startDate, int limit) {
        this.peer = peer;
        this.startDate = startDate;
        this.limit = limit;
    }

    public RequestLoadHistory() {
    }

    public OutPeer getPeer() {
        return this.peer;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public int getLimit() {
        return this.limit;
    }

    public void parse(BserValues values) throws IOException {
        this.peer = (OutPeer)values.getObj(1, OutPeer.class);
        this.startDate = values.getLong(3);
        this.limit = values.getInt(4);
    }

    public void serialize(BserWriter writer) throws IOException {
        if (this.peer == null) {
            throw new IOException();
        }
        writer.writeObject(1, (BserObject)this.peer);
        writer.writeLong(3, this.startDate);
        writer.writeInt(4, this.limit);
    }

    @Override
    public int getHeaderKey() {
        return 118;
    }
}

