/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class StreamingUtils {
    public static byte[] intToBytes(int v) {
        return new byte[]{(byte)(v >> 24 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v & 0xFF)};
    }

    public static void writeByte(int v, OutputStream stream) throws IOException {
        stream.write(v);
    }

    public static void writeByte(byte v, OutputStream stream) throws IOException {
        stream.write(v);
    }

    public static void writeInt(int v, OutputStream stream) throws IOException {
        StreamingUtils.writeByte((byte)(v >> 24 & 0xFF), stream);
        StreamingUtils.writeByte((byte)(v >> 16 & 0xFF), stream);
        StreamingUtils.writeByte((byte)(v >> 8 & 0xFF), stream);
        StreamingUtils.writeByte((byte)(v & 0xFF), stream);
    }

    public static void writeLong(long v, OutputStream stream) throws IOException {
        StreamingUtils.writeByte((byte)(v >> 56 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 48 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 40 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 32 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 24 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 16 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v >> 8 & 0xFFL), stream);
        StreamingUtils.writeByte((byte)(v & 0xFFL), stream);
    }

    public static void writeDouble(double v, OutputStream stream) throws IOException {
        StreamingUtils.writeLong(Double.doubleToLongBits(v), stream);
    }

    public static void writeBytes(byte[] data, OutputStream stream) throws IOException {
        stream.write(data);
    }

    public static void writeBytes(byte[] data, int offset, int len, OutputStream stream) throws IOException {
        stream.write(data, offset, len);
    }

    public static int readInt(InputStream stream) throws IOException {
        int a = stream.read();
        if (a < 0) {
            throw new IOException();
        }
        int b = stream.read();
        if (b < 0) {
            throw new IOException();
        }
        int c = stream.read();
        if (c < 0) {
            throw new IOException();
        }
        int d = stream.read();
        if (d < 0) {
            throw new IOException();
        }
        return d + (c << 8) + (b << 16) + (a << 24);
    }

    public static long readUInt(InputStream stream) throws IOException {
        long a = stream.read();
        if (a < 0L) {
            throw new IOException();
        }
        long b = stream.read();
        if (b < 0L) {
            throw new IOException();
        }
        long c = stream.read();
        if (c < 0L) {
            throw new IOException();
        }
        long d = stream.read();
        if (d < 0L) {
            throw new IOException();
        }
        return d + (c << 8) + (b << 16) + (a << 24);
    }

    public static long readLong(InputStream stream) throws IOException {
        long a = StreamingUtils.readUInt(stream);
        long b = StreamingUtils.readUInt(stream);
        return b + (a << 32);
    }

    public static double readDouble(InputStream stream) throws IOException {
        return Double.longBitsToDouble(StreamingUtils.readLong(stream));
    }

    public static byte[] readBytes(int count, InputStream stream) throws IOException {
        byte[] res = new byte[count];
        int offset = 0;
        while (offset < res.length) {
            int readed = stream.read(res, offset, res.length - offset);
            if (readed > 0) {
                offset += readed;
                continue;
            }
            if (readed < 0) {
                throw new IOException();
            }
            Thread.yield();
        }
        return res;
    }

    public static byte[] readBytes(int count, RandomAccessFile file) throws IOException {
        byte[] res = new byte[count];
        int offset = 0;
        while (offset < res.length) {
            int readed = file.read(res, offset, res.length - offset);
            if (readed > 0) {
                offset += readed;
                continue;
            }
            if (readed < 0) {
                throw new IOException();
            }
            Thread.yield();
        }
        return res;
    }

    public static void skipBytes(int count, InputStream stream) throws IOException {
        stream.skip(count);
    }

    public static void readBytes(byte[] buffer, int offset, int count, InputStream stream) throws IOException {
        int woffset = 0;
        while (woffset < count) {
            int readed = stream.read(buffer, woffset + offset, count - woffset);
            if (readed > 0) {
                woffset += readed;
                continue;
            }
            if (readed < 0) {
                throw new IOException();
            }
            Thread.yield();
        }
    }

    public static byte readByte(InputStream stream) throws IOException {
        int res = stream.read();
        if (res < 0) {
            throw new IOException();
        }
        return (byte)res;
    }

    public static int readInt(byte[] src) {
        return StreamingUtils.readInt(src, 0);
    }

    public static int readInt(byte[] src, int offset) {
        int a = src[offset + 0] & 0xFF;
        int b = src[offset + 1] & 0xFF;
        int c = src[offset + 2] & 0xFF;
        int d = src[offset + 3] & 0xFF;
        return a + (b << 8) + (c << 16) + (d << 24);
    }

    public static long readUInt(byte[] src) {
        return StreamingUtils.readUInt(src, 0);
    }

    public static long readUInt(byte[] src, int offset) {
        long a = src[offset + 0] & 0xFF;
        long b = src[offset + 1] & 0xFF;
        long c = src[offset + 2] & 0xFF;
        long d = src[offset + 3] & 0xFF;
        return d + (c << 8) + (b << 16) + (a << 24);
    }

    public static long readLong(byte[] src, int offset) {
        long a = StreamingUtils.readUInt(src, offset);
        long b = StreamingUtils.readUInt(src, offset + 4);
        return (b & 0xFFFFFFFFFFFFFFFFL) + ((a & 0xFFFFFFFFFFFFFFFFL) << 32);
    }

    public static long readVarInt(InputStream stream) throws IOException {
        byte b;
        long value = 0L;
        long i = 0L;
        while (((b = StreamingUtils.readByte(stream)) & 0x80) != 0) {
            value |= (long)((b & 0x7F) << (int)i);
            if ((i += 7L) <= 70L) continue;
            throw new IOException();
        }
        return value | (long)(b << (int)i);
    }

    public static void writeVarInt(long i, OutputStream stream) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            stream.write((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        stream.write((byte)(i & 0x7FL));
    }

    public static int varintSize(long value) {
        if (value < 0L) {
            throw new RuntimeException("VarInt must be >= 0");
        }
        if (value <= 127L) {
            return 1;
        }
        if (value <= 16383L) {
            return 2;
        }
        if (value <= 0x1FFFFFL) {
            return 3;
        }
        if (value <= 0xFFFFFFFL) {
            return 4;
        }
        if (value <= Integer.MAX_VALUE) {
            return 5;
        }
        if (value <= 0x7FFFFFFFFL) {
            return 6;
        }
        if (value <= 0x3FFFFFFFFFFL) {
            return 7;
        }
        if (value <= 0x1FFFFFFFFFFFFL) {
            return 8;
        }
        if (value <= 0xFFFFFFFFFFFFFFL) {
            return 9;
        }
        return 10;
    }

    public static int stringSize(String s) {
        int stringSize = 0;
        if (s != null) {
            try {
                stringSize = s.getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return StreamingUtils.varintSize(stringSize) + stringSize;
    }

    public static byte[] readProtoBytes(InputStream stream) throws IOException {
        int arrayLength = (int)StreamingUtils.readVarInt(stream);
        return StreamingUtils.readBytes(arrayLength, stream);
    }

    public static void writeProtoBytes(byte[] data, OutputStream stream) throws IOException {
        StreamingUtils.writeVarInt(data.length, stream);
        StreamingUtils.writeBytes(data, stream);
    }

    public static long[] readProtoLongs(InputStream stream) throws IOException {
        int len = (int)StreamingUtils.readVarInt(stream);
        long[] res = new long[len];
        for (int i = 0; i < res.length; ++i) {
            res[i] = StreamingUtils.readLong(stream);
        }
        return res;
    }

    public static void writeProtoLongs(long[] values, OutputStream stream) throws IOException {
        StreamingUtils.writeVarInt(values.length, stream);
        for (long l : values) {
            StreamingUtils.writeLong(l, stream);
        }
    }

    public static String readProtoString(InputStream stream) throws IOException {
        byte[] data = StreamingUtils.readProtoBytes(stream);
        return new String(data, "UTF-8");
    }

    public static void writeProtoString(String value, OutputStream stream) throws IOException {
        byte[] data = value.getBytes("UTF-8");
        StreamingUtils.writeProtoBytes(data, stream);
    }

    public static boolean readProtoBool(InputStream stream) throws IOException {
        return StreamingUtils.readByte(stream) != 0;
    }

    public static void writeProtoBool(boolean v, OutputStream stream) throws IOException {
        StreamingUtils.writeByte(v ? 1 : 0, stream);
    }
}

