/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.crypto;

import im.actor.api.crypto.Crypto;
import im.actor.api.crypto.KeyTools;
import im.actor.api.crypto.Utils;
import im.actor.api.util.StreamingUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class RsaEncryptCipher {
    private ArrayList<Destination> destinations = new ArrayList();
    private byte[] aesKey;
    private byte[] aesIv;

    public RsaEncryptCipher(byte[] aesKey, byte[] aesIv) {
        this.aesKey = aesKey;
        this.aesIv = aesIv;
    }

    public RsaEncryptCipher() {
        this.aesKey = Crypto.generateSeed(32);
        this.aesIv = Crypto.generateSeed(16);
    }

    public void addDestination(int uid, long keyHash, byte[] key) {
        this.destinations.add(new Destination(uid, keyHash, key));
    }

    public EncryptedMessage encrypt(byte[] message) {
        byte[] encryptedMessage;
        byte[] srcData = Utils.align(Utils.concat(StreamingUtils.intToBytes(message.length), message), 16);
        byte[] key = Utils.concat(this.aesKey, this.aesIv);
        Cipher aes = Crypto.createAESCipher();
        IvParameterSpec ivSpec = new IvParameterSpec(this.aesIv);
        SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
        try {
            aes.init(1, (Key)keySpec, ivSpec);
            encryptedMessage = aes.doFinal(srcData, 0, srcData.length);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        HashMap<Integer, ArrayList<EncryptedPart>> res = new HashMap<Integer, ArrayList<EncryptedPart>>();
        Cipher cipher = Crypto.createRSACipher();
        for (Destination destination : this.destinations) {
            EncryptedPart encryptedPart;
            try {
                PublicKey pk = KeyTools.decodeRsaPublicKey(destination.getKey());
                cipher.init(1, pk);
                byte[] encryptedKey = cipher.doFinal(key);
                encryptedPart = new EncryptedPart(destination.getKeyHash(), true, encryptedKey);
            }
            catch (Throwable t) {
                encryptedPart = new EncryptedPart(destination.getKeyHash(), false, new byte[0]);
            }
            if (!res.containsKey(destination.getUid())) {
                res.put(destination.getUid(), new ArrayList());
            }
            res.get(destination.getUid()).add(encryptedPart);
        }
        return new EncryptedMessage(encryptedMessage, res);
    }

    public static class EncryptedPart {
        public long keyHash;
        public boolean isSuccessful;
        public byte[] encrypted;

        public EncryptedPart(long keyHash, boolean isSuccessful, byte[] encrypted) {
            this.keyHash = keyHash;
            this.isSuccessful = isSuccessful;
            this.encrypted = encrypted;
        }

        public long getKeyHash() {
            return this.keyHash;
        }

        public boolean isSuccessful() {
            return this.isSuccessful;
        }

        public byte[] getEncrypted() {
            return this.encrypted;
        }
    }

    public static class EncryptedMessage {
        private byte[] encryptedMessage;
        private HashMap<Integer, ArrayList<EncryptedPart>> result = new HashMap();

        public EncryptedMessage(byte[] encryptedMessage, HashMap<Integer, ArrayList<EncryptedPart>> result) {
            this.encryptedMessage = encryptedMessage;
            this.result = result;
        }

        public byte[] getEncryptedMessage() {
            return this.encryptedMessage;
        }

        public HashMap<Integer, ArrayList<EncryptedPart>> getResult() {
            return this.result;
        }
    }

    private class Destination {
        private int uid;
        private long keyHash;
        private byte[] key;

        public Destination(int uid, long keyHash, byte[] key) {
            this.uid = uid;
            this.keyHash = keyHash;
            this.key = key;
        }

        public int getUid() {
            return this.uid;
        }

        public long getKeyHash() {
            return this.keyHash;
        }

        public byte[] getKey() {
            return this.key;
        }
    }
}

