/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp;

import im.actor.api.ActorApiConfig;
import im.actor.api.mtp.MTProtoEndpoint;
import im.actor.api.mtp._internal.EndpointProvider;
import im.actor.api.mtp._internal.entity.ProtoMessage;
import im.actor.api.mtp._internal.entity.ProtoPackage;
import im.actor.api.mtp._internal.entity.ProtoSerializer;
import im.actor.api.mtp._internal.entity.ProtoStruct;
import im.actor.api.mtp._internal.entity.message.RequestAuthId;
import im.actor.api.mtp._internal.entity.message.ResponseAuthId;
import im.actor.api.util.StreamingUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.zip.CRC32;
import javax.net.ssl.SSLSocketFactory;

public class AuthIdRetreiver {
    private static final String TAG = "AuthIdRetriever";

    public static void requestAuthId(final ActorApiConfig config, final AuthIdCallback callback) {
        new Thread(){

            @Override
            public void run() {
                block7: {
                    try {
                        MTProtoEndpoint connectionInfo = new EndpointProvider(config.getEndpoints()).fetchEndpoint();
                        Socket socket = connectionInfo.getEndpointType() == MTProtoEndpoint.EndpointType.PLAIN_TCP ? new Socket() : SSLSocketFactory.getDefault().createSocket();
                        socket.connect(new InetSocketAddress(connectionInfo.getHost(), connectionInfo.getPort()), 15000);
                        if (!config.isChromeEnabled()) {
                            socket.setKeepAlive(true);
                            socket.setTcpNoDelay(true);
                        }
                        RequestAuthId requestAuthId = new RequestAuthId();
                        ProtoPackage authReqPackage = new ProtoPackage(0L, 0L, new ProtoMessage(0L, requestAuthId.toByteArray()));
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(authReqPackage.getLength());
                        authReqPackage.writeObject(baos);
                        byte[] data = baos.toByteArray();
                        OutputStream outputStream = socket.getOutputStream();
                        int length = data.length + 8;
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        StreamingUtils.writeInt(length, os);
                        StreamingUtils.writeInt(0, os);
                        StreamingUtils.writeBytes(data, os);
                        CRC32 crc32 = new CRC32();
                        crc32.update(os.toByteArray());
                        StreamingUtils.writeInt((int)crc32.getValue(), os);
                        StreamingUtils.writeBytes(os.toByteArray(), outputStream);
                        outputStream.flush();
                        InputStream inputStream = socket.getInputStream();
                        int pkgLen = StreamingUtils.readInt(inputStream);
                        StreamingUtils.readInt(inputStream);
                        byte[] pkg = AuthIdRetreiver.readBytes(pkgLen - 8, inputStream);
                        StreamingUtils.readInt(inputStream);
                        ProtoPackage protoPackage = new ProtoPackage(new ByteArrayInputStream(pkg));
                        ProtoMessage mtpMessage = protoPackage.getPayload();
                        ProtoStruct payload = ProtoSerializer.readMessagePayload(mtpMessage.payload);
                        if (payload != null) {
                            if (payload instanceof ResponseAuthId) {
                                ResponseAuthId responseAuthId = (ResponseAuthId)payload;
                                callback.onSuccess(responseAuthId.authId);
                            } else {
                                callback.onFailure(new Exception(payload.toString()));
                            }
                        } else {
                            callback.onFailure(new Exception("Got null answer"));
                        }
                        socket.close();
                    }
                    catch (IOException e) {
                        callback.onFailure(e);
                        if (config.getLogInterface() == null) break block7;
                        config.getLogInterface().e(AuthIdRetreiver.TAG, e);
                    }
                }
            }
        }.start();
    }

    private static byte[] readBytes(int count, InputStream stream) throws IOException {
        byte[] res = new byte[count];
        int offset = 0;
        while (offset < count) {
            int readed = stream.read(res, offset, count - offset);
            Thread.yield();
            if (readed > 0) {
                offset += readed;
                continue;
            }
            if (readed < 0) {
                throw new IOException();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new IOException();
            }
        }
        return res;
    }

    public static interface AuthIdCallback {
        public void onSuccess(long var1);

        public void onFailure(Exception var1);
    }
}

