/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.actors;

import com.droidkit.actors.Actor;
import com.droidkit.actors.ActorCreator;
import com.droidkit.actors.ActorRef;
import com.droidkit.actors.ActorSelection;
import com.droidkit.actors.Props;
import com.droidkit.actors.tasks.AskCallback;
import im.actor.api.LogInterface;
import im.actor.api.mtp.MTProto;
import im.actor.api.mtp._internal.EndpointProvider;
import im.actor.api.mtp._internal.actors.ReceiverActor;
import im.actor.api.mtp._internal.actors.SenderActor;
import im.actor.api.mtp._internal.entity.ProtoPackage;
import im.actor.api.mtp._internal.tcp.CreateTcpConnectionActor;
import im.actor.api.mtp._internal.tcp.RawTcpConnection;
import im.actor.api.mtp._internal.tcp.TcpConnection;
import im.actor.api.util.ExponentialBackoff;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public class ManagerActor
extends Actor {
    private static final String TAG = "Manager";
    private static final AtomicInteger NEXT_CONNECTION = new AtomicInteger(1);
    private final ArrayList<RawTcpConnection> connections = new ArrayList();
    private final LogInterface LOG;
    private final boolean DEBUG;
    private int desiredConnections;
    private boolean isCheckingConnections;
    private int roundRobin = 0;
    private MTProto proto;
    private ActorRef receiver;
    private ActorRef sender;
    private EndpointProvider endpointProvider;
    private ExponentialBackoff backoff;

    public static ActorSelection manager(final MTProto proto) {
        return new ActorSelection(Props.create(ManagerActor.class, (ActorCreator)new ActorCreator<ManagerActor>(){

            public ManagerActor create() {
                return new ManagerActor(proto);
            }
        }), proto.getPath() + "/manager");
    }

    public ManagerActor(MTProto proto) {
        this.desiredConnections = proto.getConnectionCount();
        this.proto = proto;
        this.endpointProvider = proto.getEndpointProvider();
        this.LOG = proto.getParams().getConfig().getLogInterface();
        this.DEBUG = proto.getParams().getConfig().isDebugProto();
        this.backoff = new ExponentialBackoff();
    }

    public void preStart() {
        this.receiver = this.system().actorOf(ReceiverActor.receiver(this.proto));
        this.sender = this.system().actorOf(SenderActor.senderActor(this.proto));
        this.self().send((Object)new PerformConnectionCheck());
    }

    public void onReceive(Object message) {
        if (message instanceof TcpConnection.ConnectionDie) {
            this.onConnectionDie((TcpConnection.ConnectionDie)message);
        } else if (message instanceof TcpConnection.RawMessage) {
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Received #" + ((TcpConnection.RawMessage)message).getId());
            }
            this.onRawMessage((TcpConnection.RawMessage)message);
        } else if (message instanceof SendMessage) {
            this.onSendMessage((SendMessage)message);
        } else if (message instanceof NetworkChanged) {
            if (!this.isCheckingConnections) {
                this.self().sendOnce((Object)new PerformConnectionCheck());
            }
            this.backoff.reset();
        } else if (message instanceof PerformConnectionCheck) {
            if (this.isCheckingConnections) {
                return;
            }
            if (this.connections.size() < this.desiredConnections) {
                this.isCheckingConnections = true;
                if (this.LOG != null && this.DEBUG) {
                    this.LOG.d(TAG, "Checking connection");
                }
                this.ask(new ActorSelection(CreateTcpConnectionActor.props(this.endpointProvider.fetchEndpoint(), this.proto.getParams(), this.self()), this.getPath() + "/connect/" + NEXT_CONNECTION.getAndIncrement()), (AskCallback)new AskCallback<RawTcpConnection>(){

                    public void onResult(RawTcpConnection result) {
                        if (ManagerActor.this.LOG != null && ManagerActor.this.DEBUG) {
                            ManagerActor.this.LOG.d(ManagerActor.TAG, "Connection created");
                        }
                        ManagerActor.this.isCheckingConnections = false;
                        ManagerActor.this.connections.add(result);
                        ManagerActor.this.backoff.onSuccess();
                        ManagerActor.this.self().send((Object)new PerformConnectionCheck(), ManagerActor.this.self());
                        ManagerActor.this.sender.send((Object)new SenderActor.ConnectionCreated(result.getConnectionId()), ManagerActor.this.self());
                    }

                    public void onError(Throwable throwable) {
                        if (ManagerActor.this.LOG != null) {
                            ManagerActor.this.LOG.d(ManagerActor.TAG, "Connection creation error");
                        }
                        ManagerActor.this.isCheckingConnections = false;
                        ManagerActor.this.backoff.onFailure();
                        ManagerActor.this.self().send((Object)new PerformConnectionCheck(), ManagerActor.this.backoff.exponentialWait(), ManagerActor.this.self());
                    }
                });
            }
        }
    }

    private void onRawMessage(TcpConnection.RawMessage rawMessage) {
        ProtoPackage protoPackage;
        if (this.LOG != null && this.DEBUG) {
            this.LOG.d(TAG, "Received raw message");
        }
        try {
            protoPackage = new ProtoPackage(new ByteArrayInputStream(rawMessage.getData()));
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Received raw message: " + protoPackage.getPayload().messageId);
            }
        }
        catch (IOException e) {
            if (this.LOG != null) {
                this.LOG.e(TAG, e);
            }
            this.self().send((Object)new SenderActor.ConnectionDies(rawMessage.getContextId()));
            return;
        }
        this.receiver.send((Object)protoPackage.getPayload(), this.self());
    }

    private void onSendMessage(SendMessage sendMessage) {
        if (this.LOG != null && this.DEBUG) {
            this.LOG.d(TAG, "Send message #" + sendMessage.getRid());
        }
        if (this.connections.size() == 0) {
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "No connections");
            }
            return;
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            int index;
            RawTcpConnection connection;
            if ((connection = this.connections.get(index = this.roundRobin++ % this.connections.size())).isClosed()) continue;
            connection.postMessage(sendMessage.getMessage());
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Posted to connection #" + connection.getConnectionId());
            }
            this.reply(new MessageSent(sendMessage.rid, connection.getConnectionId()));
            return;
        }
    }

    private void onConnectionDie(TcpConnection.ConnectionDie connectionDie) {
        if (this.LOG != null && this.DEBUG) {
            this.LOG.d(TAG, "Connection dies #" + connectionDie.getContextId());
        }
        Iterator<RawTcpConnection> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            RawTcpConnection connection = iterator.next();
            if (connection.getConnectionId() != connectionDie.getContextId()) continue;
            iterator.remove();
        }
        this.sender.send((Object)new SenderActor.ConnectionDies(connectionDie.getContextId()));
        this.self().send((Object)new PerformConnectionCheck());
    }

    public void postStop() {
        for (RawTcpConnection connection : this.connections) {
            connection.close();
        }
        this.connections.clear();
    }

    private static class PerformConnectionCheck {
        private PerformConnectionCheck() {
        }
    }

    public static class NetworkChanged {
    }

    public static class MessageSent {
        private long rid;
        private int connectionId;

        public MessageSent(long rid, int connectionId) {
            this.rid = rid;
            this.connectionId = connectionId;
        }

        public long getRid() {
            return this.rid;
        }

        public int getConnectionId() {
            return this.connectionId;
        }
    }

    public static class SendMessage {
        private long rid;
        private byte[] message;

        public SendMessage(long rid, byte[] message) {
            this.rid = rid;
            this.message = message;
        }

        public long getRid() {
            return this.rid;
        }

        public byte[] getMessage() {
            return this.message;
        }
    }
}

