/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.entity.message.rpc;

import im.actor.api.mtp._internal.entity.ProtoStruct;
import im.actor.api.util.StreamingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RpcOk
extends ProtoStruct {
    public static final byte HEADER = 1;
    public int responseType;
    public byte[] payload;

    public RpcOk(InputStream stream) throws IOException {
        super(stream);
    }

    public RpcOk(int responseType, byte[] payload) {
        this.responseType = responseType;
        this.payload = payload;
    }

    public int getResponseType() {
        return this.responseType;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public int getLength() {
        return 5 + StreamingUtils.varintSize(this.payload.length) + this.payload.length;
    }

    @Override
    protected byte getHeader() {
        return 1;
    }

    @Override
    protected void writeBody(OutputStream bs) throws IOException {
        StreamingUtils.writeInt(this.responseType, bs);
        StreamingUtils.writeProtoBytes(this.payload, bs);
    }

    @Override
    protected void readBody(InputStream bs) throws IOException {
        this.responseType = StreamingUtils.readInt(bs);
        this.payload = StreamingUtils.readProtoBytes(bs);
    }

    public String toString() {
        return "RpcOk{" + this.responseType + "]";
    }
}

