/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.scheme.rpc;

import com.droidkit.bser.Bser;
import com.droidkit.bser.BserValues;
import com.droidkit.bser.BserWriter;
import im.actor.api.parser.Request;
import im.actor.api.scheme.UserOutPeer;
import im.actor.api.scheme.rpc.ResponseCreateGroup;
import java.io.IOException;
import java.util.List;

public class RequestCreateGroup
extends Request<ResponseCreateGroup> {
    public static final int HEADER = 65;
    private long rid;
    private String title;
    private List<UserOutPeer> users;

    public static RequestCreateGroup fromBytes(byte[] data) throws IOException {
        return (RequestCreateGroup)Bser.parse(RequestCreateGroup.class, (byte[])data);
    }

    public RequestCreateGroup(long rid, String title, List<UserOutPeer> users) {
        this.rid = rid;
        this.title = title;
        this.users = users;
    }

    public RequestCreateGroup() {
    }

    public long getRid() {
        return this.rid;
    }

    public String getTitle() {
        return this.title;
    }

    public List<UserOutPeer> getUsers() {
        return this.users;
    }

    public void parse(BserValues values) throws IOException {
        this.rid = values.getLong(1);
        this.title = values.getString(2);
        this.users = values.getRepeatedObj(3, UserOutPeer.class);
    }

    public void serialize(BserWriter writer) throws IOException {
        writer.writeLong(1, this.rid);
        if (this.title == null) {
            throw new IOException();
        }
        writer.writeString(2, this.title);
        writer.writeRepeatedObj(3, this.users);
    }

    @Override
    public int getHeaderKey() {
        return 65;
    }
}

