/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.scheme.rpc;

import com.droidkit.bser.Bser;
import com.droidkit.bser.BserObject;
import com.droidkit.bser.BserValues;
import com.droidkit.bser.BserWriter;
import im.actor.api.parser.Response;
import im.actor.api.scheme.Config;
import im.actor.api.scheme.User;
import java.io.IOException;

public class ResponseAuth
extends Response {
    public static final int HEADER = 5;
    private long publicKeyHash;
    private User user;
    private Config config;

    public static ResponseAuth fromBytes(byte[] data) throws IOException {
        return (ResponseAuth)Bser.parse(ResponseAuth.class, (byte[])data);
    }

    public ResponseAuth(long publicKeyHash, User user, Config config) {
        this.publicKeyHash = publicKeyHash;
        this.user = user;
        this.config = config;
    }

    public ResponseAuth() {
    }

    public long getPublicKeyHash() {
        return this.publicKeyHash;
    }

    public User getUser() {
        return this.user;
    }

    public Config getConfig() {
        return this.config;
    }

    public void parse(BserValues values) throws IOException {
        this.publicKeyHash = values.getLong(1);
        this.user = (User)values.getObj(2, User.class);
        this.config = (Config)values.getObj(3, Config.class);
    }

    public void serialize(BserWriter writer) throws IOException {
        writer.writeLong(1, this.publicKeyHash);
        if (this.user == null) {
            throw new IOException();
        }
        writer.writeObject(2, (BserObject)this.user);
        if (this.config == null) {
            throw new IOException();
        }
        writer.writeObject(3, (BserObject)this.config);
    }

    @Override
    public int getHeaderKey() {
        return 5;
    }
}

