/*
 * Decompiled with CFR 0.152.
 */
package io.cloudboost;

import io.cloudboost.ACL;
import io.cloudboost.CloudApp;
import io.cloudboost.CloudException;
import io.cloudboost.CloudFileArrayCallback;
import io.cloudboost.CloudFileCallback;
import io.cloudboost.CloudQuery;
import io.cloudboost.CloudStringCallback;
import io.cloudboost.FileUploadCallback;
import io.cloudboost.ObjectCallback;
import io.cloudboost.beans.CBResponse;
import io.cloudboost.json.JSONException;
import io.cloudboost.json.JSONObject;
import io.cloudboost.util.CBParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Blob;
import java.util.regex.Pattern;

public class CloudFile {
    private JSONObject document;
    private File file = null;
    private Blob blobFile = null;
    private Object data = null;

    public void setDocument(JSONObject document) {
        this.document = document;
    }

    public CloudFile(File fileObj, String contentType) throws CloudException {
        if (fileObj == null) {
            throw new CloudException("File is null");
        }
        this.file = fileObj;
        this.document = new JSONObject();
        try {
            this.document.put("_id", JSONObject.NULL);
            this.document.put("_type", "file");
            this.document.put("ACL", new ACL().getACL());
            this.document.put("name", this.file.getName());
            this.document.put("size", this.file.length());
            this.document.put("url", JSONObject.NULL);
            this.document.put("expires", JSONObject.NULL);
            this.document.put("contentType", contentType);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getId() {
        try {
            return this.document.getString("_id");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CloudFile(File fileObj) throws CloudException {
        if (fileObj == null) {
            throw new CloudException("File is null");
        }
        this.file = fileObj;
        this.document = new JSONObject();
        try {
            this.document.put("_id", JSONObject.NULL);
            this.document.put("_type", "file");
            this.document.put("ACL", new ACL().getACL());
            this.document.put("name", this.file.getName());
            this.document.put("size", this.file.length());
            this.document.put("url", JSONObject.NULL);
            this.document.put("expires", JSONObject.NULL);
            this.document.put("contentType", this.getFileExtension(this.file));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public CloudFile(Blob fileObj) throws CloudException {
        if (fileObj == null) {
            throw new CloudException("File is null");
        }
        this.blobFile = fileObj;
        this.document = new JSONObject();
        try {
            this.document.put("_type", "file");
            this.document.put("name", ((File)((Object)this.blobFile)).getName());
            try {
                this.document.put("size", this.file.length());
            }
            catch (JSONException e) {
                this.document.put("size", (Object)null);
                e.printStackTrace();
            }
            this.document.put("url", (Object)null);
            this.document.put("contentType", (Object)null);
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
    }

    public CloudFile(String url) throws CloudException {
        if (url.isEmpty()) {
            throw new CloudException("Enter valid URL");
        }
        this.document = new JSONObject();
        Pattern pattern = Pattern.compile("https?:\\/\\/(?:www\\.|(?!www))[^\\s\\.]+\\.[^\\s]{2,}|www\\.[^\\s]+\\.[^\\s]{2,}");
        if (pattern.matcher(url).find()) {
            try {
                this.document.put("_type", "file");
                this.document.put("expires", JSONObject.NULL);
                this.document.put("ACL", new ACL());
                this.document.put("name", JSONObject.NULL);
                this.document.put("size", JSONObject.NULL);
                this.document.put("url", url);
                this.document.put("contentType", JSONObject.NULL);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            throw new CloudException("Invalid URL");
        }
    }

    public CloudFile(String fileName, Object data, String type) throws CloudException {
        this.document = new JSONObject();
        if (fileName.isEmpty()) {
            throw new CloudException("file name is required");
        }
        if (type.isEmpty()) {
            throw new CloudException("file type is required");
        }
        this.data = data;
        try {
            this.document.put("_id", JSONObject.NULL);
            this.document.put("_type", "file");
            this.document.put("expires", JSONObject.NULL);
            this.document.put("ACL", new ACL().getACL());
            this.document.put("name", fileName);
            this.document.put("size", (Object)null);
            this.document.put("url", JSONObject.NULL);
            this.document.put("contentType", type);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public CloudFile(JSONObject jsonObject) {
        this.setDocument(jsonObject);
    }

    public void setFileType(String type) {
        try {
            this.document.put("_type", type);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getFileType() {
        try {
            return this.document.getString("_type");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFileUrl() {
        try {
            return this.document.getString("url");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setFileName(String name) {
        try {
            this.document.put("name", name);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getFileName() {
        try {
            return this.document.getString("name");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getFileSize() {
        try {
            return this.document.getInt("size");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return null;
        }
        return name.substring(lastIndexOf);
    }

    public void save(CloudFileCallback callbackObject, FileUploadCallback uploadCallback) throws CloudException, IOException, JSONException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        String url = CloudApp.getApiUrl() + "/file/" + CloudApp.getAppId();
        CBResponse response = null;
        if (this.data == null) {
            response = CBParser.postFormData(url, "POST", this.document, this.file, uploadCallback);
        } else {
            JSONObject params = new JSONObject();
            params.put("key", CloudApp.getAppKey());
            params.put("fileObj", this.document);
            params.put("data", this.data);
            response = CBParser.callJson(url, "POST", params);
        }
        if (response.getStatusCode() == 200) {
            String responseBody = response.getResponseBody();
            JSONObject body = null;
            try {
                body = new JSONObject(responseBody);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.document = body;
            callbackObject.done(this, null);
        } else {
            CloudException e = new CloudException(response.getStatusMessage());
            callbackObject.done(null, e);
        }
    }

    public void save(CloudFileCallback callbackObject) throws CloudException, IOException, JSONException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        String url = CloudApp.getApiUrl() + "/file/" + CloudApp.getAppId();
        CBResponse response = null;
        if (this.data == null) {
            response = CBParser.postFormData(url, "POST", this.document, new FileInputStream(this.file));
        } else {
            JSONObject params = new JSONObject();
            params.put("key", CloudApp.getAppKey());
            params.put("fileObj", this.document);
            params.put("data", this.data);
            response = CBParser.callJson(url, "POST", params);
        }
        if (response.getStatusCode() == 200) {
            String responseBody = response.getResponseBody();
            JSONObject body = null;
            try {
                body = new JSONObject(responseBody);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.document = body;
            callbackObject.done(this, null);
        } else {
            CloudException e = new CloudException(response.getStatusMessage());
            callbackObject.done(null, e);
        }
    }

    public JSONObject getDocument() {
        return this.document;
    }

    public void delete(CloudStringCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        try {
            if (this.document.getString("url") == null) {
                throw new CloudException("You cannot delete a file which does not have an URL");
            }
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        JSONObject params = new JSONObject();
        try {
            params.put("fileObj", this.document);
            params.put("key", CloudApp.getAppKey());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        String url = CloudApp.getApiUrl() + "/file/" + CloudApp.getAppId() + "/" + this.getId();
        CBResponse response = CBParser.callJson(url, "DELETE", params);
        if (response.getStatusCode() == 200) {
            callbackObject.done(response.getStatusMessage(), null);
        } else {
            CloudException e = new CloudException(response.getStatusMessage());
            callbackObject.done(null, e);
        }
    }

    public void getFileContent(ObjectCallback callback) {
        String url = CloudApp.getServerUrl() + "/file/" + CloudApp.getAppId() + "/" + this.getId();
        JSONObject params = new JSONObject();
        try {
            params.put("key", CloudApp.getAppKey());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        CBResponse response = CBParser.callJson(url, "POST", params);
        if (response.getStatusCode() == 200) {
            try {
                callback.done(response.getResponseBody(), null);
            }
            catch (CloudException e) {
                e.printStackTrace();
            }
        } else {
            try {
                callback.done((Object)null, new CloudException(response.getStatusMessage()));
            }
            catch (CloudException e) {
                e.printStackTrace();
            }
        }
    }

    public ACL getAcl() {
        try {
            JSONObject ob = (JSONObject)this.document.get("ACL");
            ACL acl = new ACL();
            acl.acl = ob;
            return acl;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public void setAcl(ACL acl) {
        try {
            this.document.put("ACL", acl.getACL());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void fetch(final CloudFileArrayCallback callback) throws CloudException {
        CloudQuery query = new CloudQuery("_File");
        query.equalTo("id", this.getId());
        query.setLimit(1);
        query.find(new CloudFileArrayCallback(){

            @Override
            public void done(CloudFile[] x, CloudException t) throws CloudException {
                callback.done(x, t);
            }
        });
    }
}

