/*
 * Decompiled with CFR 0.152.
 */
package io.cloudboost;

import io.cloudboost.CloudApp;
import io.cloudboost.CloudException;
import io.cloudboost.CloudFile;
import io.cloudboost.CloudFileArrayCallback;
import io.cloudboost.CloudGeoPoint;
import io.cloudboost.CloudIntegerCallback;
import io.cloudboost.CloudObject;
import io.cloudboost.CloudObjectArrayCallback;
import io.cloudboost.CloudObjectCallback;
import io.cloudboost.CloudRole;
import io.cloudboost.PrivateMethod;
import io.cloudboost.beans.CBResponse;
import io.cloudboost.json.JSONArray;
import io.cloudboost.json.JSONException;
import io.cloudboost.json.JSONObject;
import io.cloudboost.util.CBParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CloudQuery {
    private String tableName;
    private JSONObject query;
    private JSONObject select;
    ArrayList<String> includeList;
    ArrayList<String> include;
    private JSONObject sort;
    private int skip;
    private int limit;
    private ArrayList<String> $include;
    private ArrayList<String> $includeList;
    public JSONObject body = new JSONObject();

    public CloudQuery(String tableName) {
        this.tableName = tableName;
        this.query = new JSONObject();
        this.select = new JSONObject();
        this.include = new ArrayList();
        this.includeList = new ArrayList();
        this.$include = new ArrayList();
        this.$includeList = new ArrayList();
        try {
            this.query.put("$include", this.$include);
            this.query.put("$includeList", this.$includeList);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.sort = new JSONObject();
        this.skip = 0;
        this.limit = 10;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public JSONObject getSelect() {
        return this.select;
    }

    public void setSelect(JSONObject select) {
        this.select = select;
    }

    public ArrayList<String> getIncludeList() {
        return this.includeList;
    }

    public void setIncludeList(ArrayList<String> includeList) {
        this.includeList = includeList;
    }

    public ArrayList<String> getInclude() {
        return this.include;
    }

    public void setInclude(ArrayList<String> include) {
        this.include = include;
    }

    public JSONObject getSort() {
        return this.sort;
    }

    public void setSort(JSONObject sort) {
        this.sort = sort;
    }

    public ArrayList<String> get$include() {
        return this.$include;
    }

    public void set$include(ArrayList<String> $include) {
        this.$include = $include;
    }

    public ArrayList<String> get$includeList() {
        return this.$includeList;
    }

    public void set$includeList(ArrayList<String> $includeList) {
        this.$includeList = $includeList;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getLimit() {
        return this.limit;
    }

    public JSONObject getQuery() {
        return this.query;
    }

    public void setQuery(JSONObject query) {
        this.query = query;
    }

    public boolean hasQuery() {
        return this.query != null;
    }

    public static CloudQuery or(CloudQuery object1, CloudQuery object2) throws CloudException {
        String tableName1 = object1.tableName;
        String tableName2 = object2.tableName;
        if (!tableName1.toLowerCase().equals(tableName2.toLowerCase())) {
            throw new CloudException("Table names are not same");
        }
        JSONArray array = new JSONArray();
        array.put(object1.query);
        array.put(object2.query);
        CloudQuery object = new CloudQuery(tableName1);
        try {
            object.query.put("$or", array);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }

    public static boolean validateQuery(CloudObject co, JSONObject query) throws JSONException {
        String[] names = JSONObject.getNames(query);
        if (names == null) {
            return false;
        }
        for (String key : names) {
            String realVal;
            if (key.equals("$include") || key.equals("$includeList")) continue;
            Object val = query.get(key);
            if (val instanceof JSONObject || val instanceof JSONArray) {
                if (key.equals("$or")) {
                    JSONArray arr = query.getJSONArray(key);
                    boolean valid = false;
                    if (arr.length() > 0) {
                        for (int i = 0; i < arr.length(); ++i) {
                            if (!CloudQuery.validateQuery(co, arr.getJSONObject(i))) continue;
                            valid = true;
                            break;
                        }
                        if (!valid) {
                            return false;
                        }
                    }
                }
                if (!(val instanceof JSONObject)) continue;
                String[] subkeys = JSONObject.getNames((JSONObject)val);
                List<String> subk = Arrays.asList(subkeys);
                for (String subkey : subkeys) {
                    int i;
                    Object value;
                    Object subval;
                    String options;
                    if (subkey.equals("$regex") && co.hasKey(key) && subk.contains("$options") && (options = ((JSONObject)val).getString("$options")).equals("im")) {
                        String value2;
                        String reg = ((JSONObject)val).getString("$regex");
                        reg = reg.replace("^", "");
                        if (co.hasKey(key) && !String.valueOf((value2 = co.getString(key)).charAt(0)).equals(reg)) {
                            return false;
                        }
                    }
                    if (subkey.equals("$ne")) {
                        subval = ((JSONObject)val).get(subkey);
                        if (co.hasKey(key) && (subval instanceof Double ? co.getDouble(key).doubleValue() == ((JSONObject)val).getDouble(subkey) : (subval instanceof Integer ? co.getInteger(key).intValue() == ((JSONObject)val).getInt(subkey) : subval instanceof String && co.getString(key).equals(((JSONObject)val).getString(subkey))))) {
                            return false;
                        }
                    }
                    if (subkey.equals("$gt") && co.hasKey(key) && ((subval = ((JSONObject)val).get(subkey)) instanceof Double ? co.getDouble(key) <= ((JSONObject)val).getDouble(subkey) : subval instanceof Integer && co.getInteger(key) <= ((JSONObject)val).getInt(subkey))) {
                        return false;
                    }
                    if (subkey.equals("$gte")) {
                        subval = ((JSONObject)val).get(subkey);
                        if (co.hasKey(key) && (subval instanceof Double ? co.getDouble(key) < ((JSONObject)val).getDouble(subkey) : subval instanceof Integer && co.getInteger(key) < ((JSONObject)val).getInt(subkey))) {
                            return false;
                        }
                    }
                    if (subkey.equals("$lt") && co.hasKey(key) && ((subval = ((JSONObject)val).get(subkey)) instanceof Double ? co.getDouble(key) >= ((JSONObject)val).getDouble(subkey) : subval instanceof Integer && co.getInteger(key) >= ((JSONObject)val).getInt(subkey))) {
                        return false;
                    }
                    if (subkey.equals("$lte")) {
                        subval = ((JSONObject)val).get(subkey);
                        if (co.hasKey(key) && subval instanceof Double) {
                            if (co.getDouble(key) > ((JSONObject)val).getDouble(subkey)) {
                                return false;
                            }
                            if (subval instanceof Integer && co.getInteger(key) > ((JSONObject)val).getInt(subkey)) {
                                return false;
                            }
                        }
                    }
                    if (subkey.equals("$exists")) {
                        boolean exists = ((JSONObject)val).getBoolean(subkey);
                        if (co.hasKey(key) && (exists && !co.hasKey(key) || !exists && co.hasKey(key))) {
                            return false;
                        }
                    }
                    if (subkey.equals("$in")) {
                        JSONArray arr = ((JSONObject)val).getJSONArray(subkey);
                        value = null;
                        if (key.indexOf(".") != -1 && !co.hasKey(key)) {
                            if (co.hasKey(key.substring(0, key.indexOf(".")))) {
                                value = co.get(key.substring(0, key.indexOf(".")));
                            }
                        } else if (co.hasKey(key)) {
                            value = co.get(key);
                        }
                        boolean vali = false;
                        for (i = 0; i < arr.length(); ++i) {
                            if (!arr.get(i).equals("" + value)) continue;
                            vali = true;
                            break;
                        }
                        if (!vali) {
                            return vali;
                        }
                    }
                    if (subkey.equals("$nin")) {
                        JSONArray arr = ((JSONObject)val).getJSONArray(subkey);
                        value = null;
                        if (key.indexOf(".") != -1 && !co.hasKey(key)) {
                            if (co.hasKey(key.substring(0, key.indexOf(".")))) {
                                value = co.get(key.substring(0, key.indexOf(".")));
                            } else if (co.hasKey(key)) {
                                value = co.get(key);
                            }
                        }
                        boolean vali = true;
                        for (i = 0; i < arr.length(); ++i) {
                            if (!arr.get(i).equals("" + value)) continue;
                            vali = false;
                            break;
                        }
                        if (!vali) {
                            return vali;
                        }
                    }
                    if (!subkey.equals("$all")) continue;
                }
                continue;
            }
            String makey = key;
            if (makey.indexOf(".") != -1 && !co.hasKey(makey)) {
                makey = makey.substring(0, makey.indexOf("."));
            }
            if (!co.hasKey(makey)) {
                return false;
            }
            String queryVal = val + "";
            if (queryVal.equals(realVal = co.get(makey) + "")) continue;
            return false;
        }
        return true;
    }

    public CloudQuery equalTo(String columnName, Object obj) {
        if (columnName.equals("id")) {
            columnName = "_id";
        }
        if (obj != null) {
            try {
                if (obj instanceof CloudObject || obj instanceof CloudRole) {
                    columnName = columnName + "._id";
                    obj = ((CloudObject)obj).document.getString("_id");
                }
                this.query.put(columnName, obj);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            this.doesNotExists(columnName);
        }
        return this;
    }

    public CloudQuery notEqualTo(String columnName, Object obj) {
        if (columnName.equals("id")) {
            columnName = "_id";
        }
        if (obj != null) {
            try {
                if (obj instanceof CloudObject) {
                    columnName = columnName + "._id";
                    obj = ((CloudObject)obj).document.getString("_id");
                }
                JSONObject $ne = new JSONObject("{ $ne: " + obj + " }");
                this.query.put(columnName, $ne);
            }
            catch (JSONException e) {
                try {
                    JSONObject $ne = new JSONObject("{ $ne:  }");
                    this.query.put(columnName, $ne);
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
        } else {
            this.exists(columnName);
        }
        return this;
    }

    public CloudQuery exists(String columnName) {
        if (columnName == "id" || columnName == "expires") {
            columnName = "_" + columnName;
        }
        try {
            this.query.put(columnName, JSONObject.NULL);
            JSONObject exists = new JSONObject();
            exists.put("$exists", true);
            this.query.put(columnName, exists);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery doesNotExists(String columnName) {
        if (columnName == "id" || columnName == "expires") {
            columnName = "_" + columnName;
        }
        try {
            this.query.put(columnName, JSONObject.NULL);
            JSONObject exists = new JSONObject();
            exists.put("$exists", false);
            this.query.put(columnName, exists);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery includeList(String columnName) {
        if (columnName == "id" || columnName == "expires") {
            columnName = "_" + columnName;
        }
        this.includeList.add(columnName);
        JSONObject $includeList = new JSONObject();
        try {
            $includeList.put("$includeList", this.includeList);
            this.query.put("$includeList", this.includeList);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery include(String columnName) {
        if (columnName == "id" || columnName == "expires") {
            columnName = "_" + columnName;
        }
        this.include.add(columnName);
        JSONObject $include = new JSONObject();
        try {
            $include.put("$include", this.include);
            this.query.put("$include", this.include);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery all(String columnName) {
        if (columnName == "id") {
            columnName = "_" + columnName;
        }
        try {
            this.query.put("$all", columnName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery any(String columnName) {
        if (columnName == "id") {
            columnName = "_" + columnName;
        }
        try {
            this.query.put("$any", columnName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery first(String columnName) {
        if (columnName == "id") {
            columnName = "_" + columnName;
        }
        try {
            this.query.put("$first", columnName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery greaterThan(String columnName, Object data) {
        if (columnName == "id") {
            columnName = "_" + columnName;
        }
        try {
            if (this.query.isNull(columnName)) {
                this.query.put(columnName, JSONObject.NULL);
            }
            JSONObject $gt = new JSONObject();
            $gt.put("$gt", data);
            this.query.put(columnName, $gt);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery greaterThanEqualTo(String columnName, Object data) {
        if (columnName == "id") {
            columnName = "_" + columnName;
        }
        try {
            if (this.query.isNull(columnName)) {
                this.query.put(columnName, JSONObject.NULL);
            }
            JSONObject $gte = new JSONObject();
            $gte.put("$gte", data);
            this.query.put(columnName, $gte);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery lessThan(String columnName, Object data) {
        if (columnName == "id") {
            columnName = "_" + columnName;
        }
        try {
            if (this.query.isNull(columnName)) {
                this.query.put(columnName, JSONObject.NULL);
            }
            JSONObject $lt = new JSONObject();
            $lt.put("$lt", data);
            this.query.put(columnName, $lt);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery lessThanEqualTo(String columnName, Object data) {
        if (columnName == "id") {
            columnName = "_" + columnName;
        }
        try {
            if (this.query.isNull(columnName)) {
                this.query.put(columnName, JSONObject.NULL);
            }
            JSONObject $lte = new JSONObject();
            $lte.put("$lte", data);
            this.query.put(columnName, $lte);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery orderByAsc(String columnName) {
        if (columnName == "id") {
            columnName = "_" + columnName;
        }
        try {
            this.sort.put(columnName, 1);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery orderByDesc(String columnName) {
        if (columnName == "id") {
            columnName = "_" + columnName;
        }
        try {
            this.sort.put(columnName, -1);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery setLimit(int data) {
        this.limit = data;
        return this;
    }

    public CloudQuery setSkip(int data) {
        this.skip = data;
        return this;
    }

    public CloudQuery selectColumn(String[] columnNames) {
        try {
            if (this.select.length() == 0) {
                this.select.put("_id", 1);
                this.select.put("createdAt", 1);
                this.select.put("updatedAt", 1);
                this.select.put("ACL", 1);
                this.select.put("_type", 1);
                this.select.put("_tableName", 1);
            }
            for (int i = 0; i < columnNames.length; ++i) {
                this.select.put(columnNames[i], 1);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery doNotSelectColumn(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            try {
                this.select.put(columnNames[i], 0);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public CloudQuery containedIn(String columnName, Object[] data) throws CloudException {
        block21: {
            if (columnName.equals("id") || columnName.equals("expires")) {
                columnName = "_" + columnName;
            }
            JSONObject column = new JSONObject();
            try {
                column = this.query.getJSONObject(columnName);
            }
            catch (JSONException e) {
                try {
                    this.query.put(columnName, (Object)null);
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
            ArrayList<String> $in = new ArrayList<String>();
            ArrayList<String> $nin = new ArrayList<String>();
            if (data instanceof CloudObject[] || data instanceof Integer[] || data instanceof String[] || data instanceof Double[]) {
                CloudObject[] object = new CloudObject[data.length];
                columnName = columnName.equals("_id") ? columnName : columnName + "._id";
                try {
                    this.query.put("$include", this.$include);
                    this.query.put("$includeList", this.$includeList);
                    if (data instanceof CloudObject[]) {
                        int i;
                        Object[] dataz = new Object[data.length];
                        for (int i2 = 0; i2 < data.length; ++i2) {
                            object[i2] = (CloudObject)data[i2];
                            if (object[i2].getId() == null) {
                                throw new CloudException("CloudObject passed should be saved and should have an id before being passed to containedIn");
                            }
                            dataz[i2] = object[i2].getId();
                        }
                        data = dataz;
                        if (!column.has("$in")) {
                            column.put("$in", new ArrayList());
                        }
                        if (column.get("$in") == null) {
                            $in = new ArrayList();
                            column.put("$in", $in);
                        }
                        if (!column.has("$nin")) {
                            column.put("$nin", new ArrayList());
                        }
                        if (column.get("$nin") == null) {
                            $nin = new ArrayList();
                            column.put("$nin", $nin);
                        }
                        JSONArray in = (JSONArray)column.get("$in");
                        JSONArray nin = (JSONArray)column.get("$nin");
                        for (i = 0; i < in.length(); ++i) {
                            $in.add(in.getString(i));
                        }
                        for (i = 0; i < in.length(); ++i) {
                            $nin.add(nin.getString(i));
                        }
                        for (i = 0; i < data.length; ++i) {
                            if (!$in.contains(data[i].toString())) {
                                $in.add(data[i].toString());
                                column.put("$in", $in);
                                this.query.put(columnName, column);
                            }
                            if (!$nin.contains(data[i].toString())) continue;
                            $nin.remove(data[i].toString());
                            column.put("$nin", $nin);
                            this.query.put(columnName, column);
                        }
                        break block21;
                    }
                    this.query.put(columnName, JSONObject.NULL);
                    $in = new ArrayList();
                    column.put("$in", $in);
                    $nin = new ArrayList();
                    column.put("$nin", $nin);
                    for (int i = 0; i < data.length; ++i) {
                        $in.add(data[i].toString());
                        if (!$nin.contains(data[i].toString())) continue;
                        $nin.remove(data[i].toString());
                    }
                    column.put("$in", $in);
                    column.put("$nin", $nin);
                    this.query.put(columnName, column);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                throw new CloudException("Pass only Integer, Double, String or CloudObject as an argument");
            }
        }
        return this;
    }

    public CloudQuery notContainedIn(String columnName, Object[] data) throws CloudException {
        block19: {
            if (columnName.equals("id") || columnName.equals("expires")) {
                columnName = "_" + columnName;
            }
            JSONObject column = new JSONObject();
            try {
                this.query.put("$include", this.$include);
                this.query.put("$includeList", this.$includeList);
                if (this.query.has(columnName)) {
                    column = this.query.getJSONObject(columnName);
                }
                ArrayList $in = new ArrayList();
                ArrayList $nin = new ArrayList();
                if (data instanceof CloudObject[] || data instanceof Integer[] || data instanceof String[] || data instanceof Double[]) {
                    CloudObject[] object = new CloudObject[data.length];
                    if (data instanceof CloudObject[]) {
                        int i;
                        columnName = columnName + "._id";
                        for (int i2 = 0; i2 < data.length; ++i2) {
                            object[i2] = (CloudObject)data[i2];
                            if (object[i2].getId() == null) {
                                throw new CloudException("CloudObject passed should be saved and should have an id before being passed to containedIn");
                            }
                            data[i2] = object[i2].getId();
                        }
                        if (this.query.isNull(columnName)) {
                            this.query.put(columnName, JSONObject.NULL);
                        }
                        if (column.get("$in") == null) {
                            $in = new ArrayList();
                        }
                        if (column.get("$nin") == null) {
                            $nin = new ArrayList();
                            column.put("$nin", $nin);
                        }
                        JSONArray nin = column.getJSONArray("$nin");
                        for (i = 0; i < nin.length(); ++i) {
                            $nin.add(nin.get(i).toString());
                        }
                        $in = (ArrayList)column.get("$in");
                        $nin = (ArrayList)column.get("$nin");
                        for (i = 0; i < data.length; ++i) {
                            if (!$nin.contains(data[i].toString())) {
                                $nin.add(data[i].toString());
                                column.put("$nin", $nin);
                                this.query.put(columnName, column);
                            }
                            if (!$in.contains(data[i].toString())) continue;
                            $in.remove(data[i].toString());
                            column.remove("$in");
                            this.query.put(columnName, column);
                        }
                    } else {
                        if (this.query.isNull(columnName)) {
                            this.query.put(columnName, (Object)null);
                        }
                        if (column.isNull("$in")) {
                            $in = new ArrayList();
                            column.put("$in", $in);
                        }
                        if (column.isNull("$nin")) {
                            $nin = new ArrayList();
                            column.put("$nin", $nin);
                        }
                        for (int i = 0; i < data.length; ++i) {
                            $nin.add(data[i].toString());
                            if (!$in.contains(data[i].toString())) continue;
                            $in.remove(data[i].toString());
                        }
                        column.put("$in", $in);
                        column.remove("$in");
                        column.put("$nin", $nin);
                        this.query.put(columnName, column);
                    }
                    break block19;
                }
                throw new CloudException("Pass only Integer, Double, String or CloudObject as an argument");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public CloudQuery containsAll(String columnName, Object[] data) throws CloudException {
        block15: {
            if (columnName.equals("id") || columnName.equals("expires")) {
                columnName = "_" + columnName;
            }
            try {
                this.query.put("$include", this.$include);
                this.query.put("$includeList", this.$includeList);
                if (data instanceof CloudObject[] || data instanceof Integer[] || data instanceof String[] || data instanceof Double[]) {
                    CloudObject[] object = new CloudObject[data.length];
                    JSONObject column = new JSONObject();
                    if (this.query.has(columnName)) {
                        column = this.query.getJSONObject(columnName);
                    }
                    if (data instanceof CloudObject[]) {
                        int i;
                        for (i = 0; i < data.length; ++i) {
                            object[i] = (CloudObject)data[i];
                            if (object[i].getId() == null) {
                                throw new CloudException("CloudObject passed should be saved and should have an id before being passed to containedIn");
                            }
                            data[i] = object[i].getId();
                        }
                        if (this.query.has(columnName)) {
                            this.query.put(columnName, JSONObject.NULL);
                        }
                        if (column.has("$all")) {
                            ArrayList arrayList = new ArrayList();
                        }
                        ArrayList $all = (ArrayList)column.get("$all");
                        for (i = 0; i < data.length; ++i) {
                            if ($all.contains(data[i])) continue;
                            $all.add(data[i]);
                        }
                        column.put("$all", $all);
                        this.query.put(columnName, column);
                    } else {
                        if (this.query.has(columnName)) {
                            this.query.put(columnName, JSONObject.NULL);
                        }
                        ArrayList<Object> $all = new ArrayList();
                        if (column.has("$all")) {
                            $all = PrivateMethod._toObjectArray(column.getJSONArray("$all"));
                        }
                        for (int i = 0; i < data.length; ++i) {
                            $all.add(data[i]);
                        }
                        column.put("$all", $all);
                        this.query.put(columnName, column);
                    }
                    break block15;
                }
                throw new CloudException("Pass only Integer, Double, String or CloudObject as an argument");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public CloudQuery startsWith(String columnName, Object value) {
        if (columnName.equals("id") || columnName.equals("expires")) {
            columnName = "_" + columnName;
        }
        String regex = "^" + value.toString();
        try {
            this.query.put(columnName, JSONObject.NULL);
            JSONObject args = new JSONObject();
            args.put("$regex", regex);
            args.put("$options", "im");
            this.query.put(columnName, args);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery near(String columnName, CloudGeoPoint geoPoint, Double maxDistance, Double minDistance) {
        try {
            this.query.put(columnName, JSONObject.NULL);
            String $near = "{ '$geometry': {coordinates:" + geoPoint.document.get("coordinates") + " , type:'Point' }, '$maxDistance': " + maxDistance + ", '$minDistance': " + minDistance + "}";
            this.query.put(columnName, $near);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery geoWithin(String columnName, CloudGeoPoint geoPoint, Double radius) {
        try {
            this.query.put(columnName, JSONObject.NULL);
            String $geoWithin = "{ '$centerSphere':[" + geoPoint.document.get("coordinates") + ", " + radius / 3963.2 + "] }";
            this.query.put(columnName, $geoWithin);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public CloudQuery geoWithin(String columnName, CloudGeoPoint[] geoPoint) {
        JSONArray coordinates = new JSONArray();
        try {
            for (int i = 0; i < geoPoint.length; ++i) {
                if (geoPoint[i].document.get("coordinates") == null) continue;
                JSONArray point = new JSONArray(geoPoint[i].document.get("coordinates").toString());
                coordinates.put(point.get(0));
                coordinates.put(point.get(1));
            }
            this.query.put(columnName, JSONObject.NULL);
            String $geoWithin = "{ '$geometry':{ 'type': 'Polygon', 'coordinates': " + coordinates.toString() + "} }";
            this.query.put(columnName, $geoWithin);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void count(CloudIntegerCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        JSONObject params = new JSONObject();
        try {
            params.put("query", this.query);
            params.put("limit", this.limit);
            params.put("skip", this.skip);
            params.put("key", CloudApp.getAppKey());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        String url = CloudApp.getApiUrl() + "/data/" + CloudApp.getAppId() + "/" + this.tableName + "/count";
        CBResponse response = CBParser.callJson(url, "POST", params);
        if (response.getStatusCode() == 200) {
            callbackObject.done(Integer.valueOf(response.getResponseBody()), null);
        } else {
            callbackObject.done(null, new CloudException(response.getStatusMessage()));
        }
    }

    public void distinct(String[] keys, CloudObjectArrayCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        JSONObject params = new JSONObject();
        try {
            params.put("query", this.query);
            params.put("onKey", keys);
            params.put("select", this.select);
            params.put("limit", this.limit);
            params.put("skip", this.skip);
            params.put("key", CloudApp.getAppKey());
            String url = CloudApp.getApiUrl() + "/data/" + CloudApp.getAppId() + "/" + this.tableName + "/distinct";
            CBResponse response = CBParser.callJson(url, "POST", params);
            if (response.getStatusCode() == 200) {
                JSONArray body = new JSONArray(response.getResponseBody());
                CloudObject[] object = new CloudObject[body.length()];
                for (int i = 0; i < object.length; ++i) {
                    object[i] = new CloudObject(body.getJSONObject(i).get("_tableName").toString());
                    object[i].document = body.getJSONObject(i);
                }
                callbackObject.done(object, null);
            } else {
                CloudException e = new CloudException(response.getResponseBody());
                callbackObject.done((CloudObject[])null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException(e.toString());
            callbackObject.done((CloudObject[])null, e1);
            e.printStackTrace();
        }
    }

    public String toString() {
        JSONObject params = new JSONObject();
        try {
            params.put("query", this.query);
            params.put("select", this.select);
            params.put("limit", this.limit);
            params.put("skip", this.skip);
            params.put("sort", this.sort);
            params.put("tableName", this.tableName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return params.toString();
    }

    public void find(CloudFileArrayCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        JSONObject params = new JSONObject();
        try {
            params.put("query", this.query);
            params.put("select", this.select);
            params.put("limit", this.limit);
            params.put("skip", this.skip);
            params.put("sort", this.sort);
            params.put("key", CloudApp.getAppKey());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        String url = CloudApp.getApiUrl() + "/data/" + CloudApp.getAppId() + "/" + this.tableName + "/find";
        CBResponse response = CBParser.callJson(url, "POST", params);
        try {
            if (response.getStatusCode() == 200) {
                JSONArray body = new JSONArray(response.getResponseBody());
                CloudFile[] object = new CloudFile[body.length()];
                for (int i = 0; i < object.length; ++i) {
                    CloudFile file;
                    object[i] = file = new CloudFile(body.getJSONObject(i));
                }
                callbackObject.done(object, null);
            } else {
                CloudException e = new CloudException(response.getResponseBody());
                callbackObject.done((CloudFile[])null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException(e.toString());
            callbackObject.done((CloudFile[])null, e1);
            e.printStackTrace();
        }
    }

    public void find(CloudObjectArrayCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        JSONObject params = new JSONObject();
        try {
            params.put("query", this.query);
            params.put("select", this.select);
            params.put("limit", this.limit);
            params.put("skip", this.skip);
            params.put("sort", this.sort);
            params.put("key", CloudApp.getAppKey());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        String url = CloudApp.getApiUrl() + "/data/" + CloudApp.getAppId() + "/" + this.tableName + "/find";
        CBResponse response = CBParser.callJson(url, "POST", params);
        try {
            if (response.getStatusCode() == 200) {
                JSONArray body = new JSONArray(response.getResponseBody());
                CloudObject[] object = new CloudObject[body.length()];
                for (int i = 0; i < object.length; ++i) {
                    object[i] = new CloudObject(body.getJSONObject(i).getString("_tableName"));
                    object[i].document = body.getJSONObject(i);
                }
                callbackObject.done(object, null);
            } else {
                CloudException e = new CloudException(response.getResponseBody());
                callbackObject.done((CloudObject[])null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException(e.toString());
            callbackObject.done((CloudObject[])null, e1);
            e.printStackTrace();
        }
    }

    public void findById(Object id, CloudObjectCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        this.equalTo("id", id);
        this.sort = new JSONObject();
        JSONObject params = new JSONObject();
        try {
            params.put("query", this.query);
            params.put("select", this.select);
            params.put("limit", 1);
            params.put("skip", 0);
            params.put("sort", this.sort);
            params.put("key", CloudApp.getAppKey());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        String url = CloudApp.getApiUrl() + "/data/" + CloudApp.getAppId() + "/" + this.tableName + "/find";
        CBResponse response = CBParser.callJson(url, "POST", params);
        try {
            if (response.getStatusCode() == 200) {
                JSONArray body = new JSONArray(response.getResponseBody());
                CloudObject[] object = new CloudObject[body.length()];
                for (int i = 0; i < 1; ++i) {
                    object[i] = new CloudObject(body.getJSONObject(i).get("_tableName").toString());
                    object[i].document = body.getJSONObject(i);
                }
                callbackObject.done(object[0], null);
            } else {
                CloudException e = new CloudException(response.getResponseBody());
                callbackObject.done((CloudObject)null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException("No object returned");
            callbackObject.done((CloudObject)null, e1);
        }
    }

    public void findOne(CloudObjectCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        JSONObject params = new JSONObject();
        try {
            params.put("query", this.query);
            params.put("select", this.select);
            params.put("skip", this.skip);
            params.put("sort", this.sort);
            params.put("key", CloudApp.getAppKey());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        String url = CloudApp.getApiUrl() + "/data/" + CloudApp.getAppId() + "/" + this.tableName + "/findOne";
        CBResponse response = CBParser.callJson(url, "POST", params);
        try {
            if (response.getStatusCode() == 200) {
                JSONObject body = new JSONObject(response.getResponseBody());
                CloudObject object = new CloudObject(body.getString("_tableName"));
                object.document = body;
                callbackObject.done(object, null);
            } else {
                CloudException e = new CloudException(response.getResponseBody());
                callbackObject.done((CloudObject)null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException(e.toString());
            callbackObject.done((CloudObject)null, e1);
            e.printStackTrace();
        }
    }
}

