/*
 * Decompiled with CFR 0.152.
 */
package io.cloudboost.util;

import io.cloudboost.CloudApp;
import io.cloudboost.FileUploadCallback;
import io.cloudboost.beans.CBResponse;
import io.cloudboost.json.JSONArray;
import io.cloudboost.json.JSONException;
import io.cloudboost.json.JSONObject;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;

public class CBParser {
    static Random random = new Random();
    static String boundary = "---------------------------" + CBParser.randomString() + CBParser.randomString() + CBParser.randomString();
    public static DataOutputStream dos = null;
    public static HttpURLConnection conn = null;

    public static CBResponse callJson(String myUrl, String httpMethod, JSONObject parameters) {
        try {
            parameters.put("sdk", "java");
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        String params = parameters.toString();
        URL url = null;
        try {
            url = new URL(myUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setReadTimeout(10000);
        try {
            conn.setRequestMethod(httpMethod);
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; rv:26.0) Gecko/20100101 Firefox/26.0");
        conn.setRequestProperty("Content-Type", "application/json");
        if (CloudApp.SESSION_ID != null) {
            conn.setRequestProperty("sessionID", CloudApp.SESSION_ID);
        }
        DataOutputStream dos = null;
        String respMsg = null;
        int respCode = 0;
        String inputString = null;
        String sid = null;
        try {
            dos = new DataOutputStream(conn.getOutputStream());
            dos.writeBytes(params);
            dos.flush();
            dos.close();
            respCode = conn.getResponseCode();
            if (CloudApp.SESSION_ID == null) {
                CloudApp.SESSION_ID = conn.getHeaderField("sessionID");
            }
            respMsg = conn.getResponseMessage();
            if (respCode != 200) {
                String error = CBParser.inputStreamToString(conn.getErrorStream());
                CBResponse response = new CBResponse(error, error, respCode, null);
                response.setError(error);
                return response;
            }
            inputString = CBParser.inputStreamToString(conn.getInputStream());
        }
        catch (IOException e) {
            CBResponse resp = new CBResponse(respMsg, respMsg, respCode, sid);
            return resp;
        }
        CBResponse rr = new CBResponse(inputString, respMsg, respCode, sid);
        return rr;
    }

    private static void writeName(String name) throws IOException {
        CBParser.newline();
        CBParser.write("Content-Disposition: form-data; name=\"");
        CBParser.write(name);
        CBParser.write("\"");
    }

    protected static void newline() throws IOException {
        CBParser.write("\r\n");
    }

    private static void boundary() throws IOException {
        CBParser.write("--");
        CBParser.write(boundary);
    }

    protected static void writeln(String s) throws IOException {
        CBParser.write(s);
        CBParser.newline();
    }

    private static void write(String s) throws IOException {
        dos.writeBytes(s);
    }

    public static void setParameter(String name, String value) throws IOException {
        CBParser.boundary();
        CBParser.writeName(name);
        CBParser.newline();
        CBParser.newline();
        CBParser.writeln(value);
    }

    public static CBResponse postFormData(String myurl, String httpMethod, JSONObject params, File file, FileUploadCallback callback) throws IOException {
        URL url = null;
        try {
            url = new URL(myurl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            conn = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setReadTimeout(10000);
        try {
            conn.setRequestMethod(httpMethod);
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; rv:26.0) Gecko/20100101 Firefox/26.0");
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        dos = new DataOutputStream(conn.getOutputStream());
        CBParser.setParameter("key", CloudApp.getAppKey());
        CBParser.setParameter("fileObj", params.toString());
        CBParser.setParameter("sdk", "java");
        CBParser.setFile("fileToUpload", "blob", file, callback);
        InputStream stream = CBParser.post();
        int code = conn.getResponseCode();
        String msg = conn.getResponseMessage();
        String response = CBParser.inputStreamToString(stream);
        CBResponse resp = new CBResponse(response, msg, code, null);
        return resp;
    }

    public static CBResponse postFormData(String myurl, String httpMethod, JSONObject params, InputStream is) throws IOException {
        URL url = null;
        try {
            url = new URL(myurl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            conn = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setReadTimeout(10000);
        try {
            conn.setRequestMethod(httpMethod);
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; rv:26.0) Gecko/20100101 Firefox/26.0");
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        dos = new DataOutputStream(conn.getOutputStream());
        CBParser.setParameter("key", CloudApp.getAppKey());
        CBParser.setParameter("fileObj", params.toString());
        CBParser.setParameter("sdk", "java");
        CBParser.setFile("fileToUpload", "blob", is);
        InputStream stream = CBParser.post();
        int code = conn.getResponseCode();
        String msg = conn.getResponseMessage();
        String response = CBParser.inputStreamToString(stream);
        CBResponse resp = new CBResponse(response, msg, code, null);
        return resp;
    }

    public static InputStream post() throws IOException {
        CBParser.boundary();
        CBParser.writeln("--");
        dos.close();
        return conn.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pipe(File file, OutputStream out, FileUploadCallback callback) throws IOException {
        byte[] buf = new byte[500000];
        long contentLength = file.length();
        FileInputStream in = new FileInputStream(file);
        long total = 0L;
        int percentCompleted = 0;
        FileInputStream fileInputStream = in;
        synchronized (fileInputStream) {
            int nread;
            while ((nread = in.read(buf, 0, buf.length)) >= 0) {
                percentCompleted = (int)((total += (long)nread) * 100L / contentLength);
                callback.setProgress(percentCompleted);
                out.write(buf, 0, nread);
            }
        }
        out.flush();
        buf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pipe(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[500000];
        long total = 0L;
        InputStream inputStream = in;
        synchronized (inputStream) {
            int nread;
            while ((nread = in.read(buf, 0, buf.length)) >= 0) {
                total += (long)nread;
                out.write(buf, 0, nread);
            }
        }
        out.flush();
        buf = null;
    }

    public static void setFile(String name, String filename, File file, FileUploadCallback callback) throws IOException {
        CBParser.boundary();
        CBParser.writeName(name);
        CBParser.write("; filename=\"");
        CBParser.write(filename);
        CBParser.write("\"");
        CBParser.newline();
        CBParser.write("Content-Type: ");
        String type = HttpURLConnection.guessContentTypeFromName(filename);
        if (type == null) {
            type = "application/octet-stream";
        }
        CBParser.writeln(type);
        CBParser.newline();
        CBParser.pipe(file, dos, callback);
        CBParser.newline();
    }

    public static void setFile(String name, String filename, InputStream is) throws IOException {
        CBParser.boundary();
        CBParser.writeName(name);
        CBParser.write("; filename=\"");
        CBParser.write(filename);
        CBParser.write("\"");
        CBParser.newline();
        CBParser.write("Content-Type: ");
        String type = HttpURLConnection.guessContentTypeFromName(filename);
        if (type == null) {
            type = "application/octet-stream";
        }
        CBParser.writeln(type);
        CBParser.newline();
        CBParser.pipe(is, dos);
        CBParser.newline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStreamToString(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    protected static String randomString() {
        return Long.toString(random.nextLong(), 36);
    }

    public static ArrayList<String> jsonToList(JSONArray array) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < array.length(); ++i) {
            try {
                list.add(array.getString(i));
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

