/*
 * Decompiled with CFR 0.152.
 */
package io.cloudboost;

import io.cloudboost.CloudApp;
import io.cloudboost.CloudException;
import io.cloudboost.CloudNotificationCallback;
import io.cloudboost.CloudStringCallback;
import io.cloudboost.util.CloudSocket;
import io.socket.emitter.Emitter;

public class CloudNotification {
    public static void on(String channelName, final CloudNotificationCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("CloudApp id is null");
        }
        if (CloudApp.getAppKey() == null) {
            throw new CloudException("CloudApp key is null");
        }
        CloudSocket.getSocket().connect();
        CloudSocket.getSocket().on(CloudApp.getAppId() + channelName, new Emitter.Listener(){

            public void call(Object ... args) {
                System.out.println("callback called");
                try {
                    callbackObject.done(args[0], null);
                }
                catch (CloudException e) {
                    e.printStackTrace();
                }
            }
        });
        CloudSocket.getSocket().emit("join-custom-channel", new Object[]{CloudApp.getAppId() + channelName});
    }

    public static void publish(String channelName, Object data) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("CloudApp id is null");
        }
        if (CloudApp.getAppKey() == null) {
            throw new CloudException("CloudApp key is null");
        }
        CloudSocket.getSocket().emit("publish-custom-channel", new Object[]{"{\"channel\":\"" + CloudApp.getAppId() + channelName + "\",\"data\":\"" + data + "\""});
    }

    public static void off(String channelName, final CloudStringCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("CloudApp id is null");
        }
        if (CloudApp.getAppKey() == null) {
            throw new CloudException("CloudApp key is null");
        }
        CloudSocket.getSocket().disconnect();
        CloudSocket.getSocket().emit("leave-custom-channel", new Object[]{CloudApp.getAppId() + channelName});
        CloudSocket.getSocket().disconnect();
        CloudSocket.getSocket().off(CloudApp.getAppId() + channelName, new Emitter.Listener(){

            public void call(Object ... args) {
                try {
                    callbackObject.done(null, null);
                }
                catch (CloudException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

