/*
 * Decompiled with CFR 0.152.
 */
package io.cloudboost;

import io.cloudboost.CloudApp;
import io.cloudboost.CloudException;
import io.cloudboost.CloudObject;
import io.cloudboost.CloudRole;
import io.cloudboost.CloudStringCallback;
import io.cloudboost.CloudUserCallback;
import io.cloudboost.beans.CBResponse;
import io.cloudboost.json.JSONArray;
import io.cloudboost.json.JSONException;
import io.cloudboost.json.JSONObject;
import io.cloudboost.util.CBParser;
import java.util.ArrayList;
import java.util.HashMap;

public class CloudUser
extends CloudObject {
    private static CloudUser current;

    public CloudUser() {
        super("User");
        try {
            this.document.put("_type", "user");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void setCurrentUser(CloudUser user) {
        current = user;
    }

    public static CloudUser getcurrentUser() {
        return current;
    }

    public void setUserName(String username) {
        try {
            this.set("username", username);
        }
        catch (CloudException e) {
            e.printStackTrace();
        }
    }

    public String getUserName() {
        try {
            return this.document.getString("username");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setPassword(String password) {
        try {
            this.set("password", password);
        }
        catch (CloudException e) {
            e.printStackTrace();
        }
    }

    public String getPassword() {
        try {
            return this.document.getString("password");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setEmail(String email) {
        try {
            this.set("email", email);
        }
        catch (CloudException e) {
            e.printStackTrace();
        }
    }

    public String getEmail() {
        try {
            return this.document.getString("email");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void signUp(CloudUserCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        CloudUser thisObj = null;
        JSONObject data = null;
        try {
            if (this.document.get("username") == null) {
                throw new CloudException("Username is not set");
            }
            if (this.document.get("password") == null) {
                throw new CloudException("Password is not set");
            }
            if (this.document.get("email") == null) {
                throw new CloudException("Email is not set");
            }
            data = new JSONObject();
            thisObj = this;
            data.put("document", this.document);
            data.put("key", CloudApp.getAppKey());
            String url = CloudApp.getApiUrl() + "/user/" + CloudApp.getAppId() + "/signup";
            CBResponse response = CBParser.callJson(url, "POST", data);
            if (response.getStatusCode() == 200) {
                JSONObject body;
                thisObj.document = body = new JSONObject(response.getResponseBody());
                current = thisObj;
                callbackObject.done(thisObj, null);
            } else {
                JSONObject obj = new JSONObject(response.getError());
                CloudException e = new CloudException(obj.getString("error"));
                callbackObject.done(null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException(e.toString());
            callbackObject.done(null, e1);
            e.printStackTrace();
        }
    }

    public void logIn(CloudUserCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        try {
            if (this.document.get("username") == null) {
                throw new CloudException("Username is not set");
            }
            if (this.document.get("password") == null) {
                throw new CloudException("Password is not set");
            }
            JSONObject data = new JSONObject();
            CloudUser thisObj = this;
            data.put("document", this.document);
            data.put("key", CloudApp.getAppKey());
            String url = CloudApp.getApiUrl() + "/user/" + CloudApp.getAppId() + "/login";
            CBResponse response = CBParser.callJson(url, "POST", data);
            if (response.getStatusCode() == 200) {
                JSONObject body;
                thisObj.document = body = new JSONObject(response.getResponseBody());
                current = thisObj;
                callbackObject.done(thisObj, null);
            } else {
                JSONObject obj = new JSONObject(response.getError());
                CloudException e = new CloudException(obj.getString("error"));
                callbackObject.done(null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException(e.toString());
            callbackObject.done(null, e1);
            e.printStackTrace();
        }
    }

    public void logOut(CloudUserCallback callbackObject) throws CloudException {
        try {
            if (CloudApp.getAppId() == null) {
                throw new CloudException("App Id is null");
            }
            if (this.document.get("username") == null) {
                throw new CloudException("Username is not set");
            }
            if (this.document.get("password") == null) {
                throw new CloudException("Password is not set");
            }
            JSONObject data = new JSONObject();
            CloudUser thisObj = this;
            data.put("document", this.document);
            data.put("key", CloudApp.getAppKey());
            String url = CloudApp.getApiUrl() + "/user/" + CloudApp.getAppId() + "/logout";
            CBResponse response = CBParser.callJson(url, "POST", data);
            response.toString();
            if (response.getStatusCode() == 200) {
                JSONObject body;
                thisObj.document = body = new JSONObject(response.getResponseBody());
                CloudApp.SESSION_ID = null;
                current = null;
                callbackObject.done(thisObj, null);
            } else {
                JSONObject obj = new JSONObject(response.getError());
                CloudException e = new CloudException(obj.toString());
                callbackObject.done(null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException(e.toString());
            callbackObject.done(null, e1);
        }
    }

    public void addToRole(CloudRole role, CloudUserCallback callbackObject) throws CloudException {
        if (role == null) {
            throw new CloudException("role is null");
        }
        JSONObject data = new JSONObject();
        CloudUser thisObj = this;
        try {
            data.put("user", thisObj.document);
            data.put("role", role.document);
            data.put("key", CloudApp.getAppKey());
            String url = CloudApp.getApiUrl() + "/user/" + CloudApp.getAppId() + "/addToRole";
            CBResponse response = CBParser.callJson(url, "PUT", data);
            if (response.getStatusCode() == 200) {
                JSONObject body;
                thisObj.document = body = new JSONObject(response.getResponseBody());
                current = null;
                callbackObject.done(thisObj, null);
            } else {
                System.out.println("resp:" + response);
                JSONObject obj = new JSONObject(response.getError());
                CloudException e = new CloudException(obj.getString("error"));
                callbackObject.done(null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException(e.toString());
            callbackObject.done(null, e1);
            e.printStackTrace();
        }
    }

    public boolean isInRole(CloudRole role) throws CloudException {
        if (role == null) {
            throw new CloudException("role is null");
        }
        try {
            ArrayList roles = (ArrayList)this.document.get("roles");
            return roles.contains(role.document.get("_id"));
        }
        catch (JSONException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public void changePassword(String oldPassword, String newPassword, CloudUserCallback callback) throws CloudException {
        if (oldPassword == null) {
            callback.done(null, new CloudException("oldPassword is required"));
        }
        if (newPassword == null) {
            callback.done(null, new CloudException("newPassword is required"));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oldPassword", oldPassword);
        params.put("newPassword", newPassword);
        params.put("key", CloudApp.getAppKey());
        JSONObject ob = new JSONObject(params);
        String url = CloudApp.getApiUrl() + "/user/" + CloudApp.getAppId() + "/changePassword";
        CBResponse response = CBParser.callJson(url, "PUT", ob);
        if (response.getStatusCode() == 200) {
            this.document = new JSONObject(response.getResponseBody());
            callback.done(this, null);
        } else {
            callback.done(null, new CloudException(response.getError()));
        }
    }

    public static void resetPassword(String email, CloudStringCallback callback) throws CloudException {
        if (email == null) {
            callback.done(null, new CloudException("Email is required"));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        params.put("key", CloudApp.getAppKey());
        JSONObject ob = new JSONObject(params);
        String url = CloudApp.getApiUrl() + "/user/" + CloudApp.getAppId() + "/resetPassword";
        CBResponse response = CBParser.callJson(url, "POST", ob);
        if (response.getStatusCode() == 200) {
            callback.done(response.getResponseBody(), null);
        } else {
            callback.done(null, new CloudException(response.getError()));
        }
    }

    public void removeFromRole(CloudRole role, CloudUserCallback callbackObject) throws CloudException {
        if (role == null) {
            throw new CloudException("role is null");
        }
        JSONObject data = new JSONObject();
        CloudUser thisObj = this;
        try {
            data.put("user", thisObj.document);
            data.put("role", role.document);
            data.put("key", CloudApp.getAppKey());
            String url = CloudApp.getApiUrl() + "/user/" + CloudApp.getAppId() + "/removeFromRole";
            CBResponse response = CBParser.callJson(url, "PUT", data);
            if (response.getStatusCode() == 200) {
                JSONObject body;
                String resp = response.getResponseBody();
                JSONArray arr = null;
                arr = resp.charAt(0) == '[' ? new JSONArray(resp) : new JSONArray("[" + resp + "]");
                thisObj.document = body = arr.getJSONObject(0);
                current = null;
                callbackObject.done(thisObj, null);
            } else {
                JSONObject obj = new JSONObject(response.getError());
                CloudException e = new CloudException(obj.getString("error"));
                callbackObject.done(null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException(e.toString());
            callbackObject.done(null, e1);
            e.printStackTrace();
            e.printStackTrace();
        }
    }
}

