/*
 * Decompiled with CFR 0.152.
 */
package io.cloudboost;

import io.cloudboost.CloudException;
import io.cloudboost.CloudTable;
import io.cloudboost.PrivateMethod;
import io.cloudboost.json.JSONException;
import io.cloudboost.json.JSONObject;

public class Column {
    protected JSONObject document;

    public JSONObject getDocument() {
        return this.document;
    }

    public void setDocument(JSONObject document) {
        this.document = document;
    }

    public Column(String columnName, DataType dataType) {
        if (!PrivateMethod._columnNameValidation(columnName)) {
            try {
                throw new CloudException("Invalid Column Name");
            }
            catch (CloudException e) {
                e.printStackTrace();
            }
        }
        this.document = new JSONObject();
        try {
            this.document.put("name", columnName);
            this.document.put("dataType", (Object)dataType);
            this.document.put("_type", "column");
            this.document.put("required", false);
            this.document.put("unique", false);
            this.document.put("relatedTo", JSONObject.NULL);
            this.document.put("relationType", JSONObject.NULL);
            this.document.put("isDeletable", true);
            this.document.put("isEditable", true);
            this.document.put("isRenamable", false);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public Column(String columnName, DataType dataType, boolean required, boolean unique) {
        if (!PrivateMethod._columnNameValidation(columnName)) {
            try {
                throw new CloudException("Invalid Column Name");
            }
            catch (CloudException e) {
                e.printStackTrace();
            }
        }
        this.document = new JSONObject();
        try {
            this.document.put("name", columnName);
            this.document.put("dataType", (Object)dataType);
            this.document.put("_type", "column");
            this.document.put("required", required);
            this.document.put("unique", unique);
            this.document.put("relatedTo", JSONObject.NULL);
            this.document.put("relationType", JSONObject.NULL);
            this.document.put("isDeletable", true);
            this.document.put("isEditable", true);
            this.document.put("isRenamable", false);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getColumnName() {
        try {
            return this.document.getString("name");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setColumnName(String value) {
        try {
            this.document.put("name", value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public DataType getDataType() {
        try {
            return (DataType)((Object)this.document.get("dataType"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setDataType(DataType type) {
        try {
            this.document.put("dataType", (Object)type);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setRequired(boolean required) {
        try {
            this.document.put("required", required);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public boolean getRequired() {
        try {
            return this.document.getBoolean("required");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setUnique(boolean unique) {
        try {
            this.document.put("unique", unique);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public boolean getUnique() {
        try {
            return this.document.getBoolean("unique");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setRelatedTo(CloudTable table) {
        try {
            this.document.put("relatedTo", table.document.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setRelatedTo(String tableName) {
        try {
            this.document.put("relatedTo", tableName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setRelatedTo(DataType type) {
        try {
            this.document.put("relatedTo", (Object)type);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public CloudTable getRelatedTo() {
        JSONObject table = null;
        CloudTable object = null;
        try {
            table = (JSONObject)this.document.get("relatedTo");
            object = new CloudTable(table.getString("name"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        object.document = table;
        return object;
    }

    public void setRelatedToType(String value) {
        try {
            this.document.put("relatedTotype", value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getRelatedToType() {
        try {
            return this.document.getString("relatedToType");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setRelationType(String value) {
        try {
            this.document.put("relationType", value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String setRelationType() {
        try {
            return this.document.getString("relationType");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    void setIsDeletable(boolean value) {
        try {
            this.document.put("isDeletable", value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    boolean getIsDeletable() {
        try {
            return this.document.getBoolean("isDeletable");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    void setIsEditable(boolean value) {
        try {
            this.document.put("isEditable", value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    boolean getIsEditable() {
        try {
            return this.document.getBoolean("isEditable");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    void setIsRenamable(boolean value) {
        try {
            this.document.put("isRenamable", value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    boolean getIsRenamable() {
        try {
            return this.document.getBoolean("isRenamable");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static enum DataType {
        Text,
        Email,
        URL,
        Number,
        Boolean,
        DateTime,
        GeoPoint,
        File,
        List,
        Relation,
        Object,
        Id,
        EncryptedText,
        ACL;

    }
}

