/*
 * Decompiled with CFR 0.152.
 */
package io.cloudboost;

import io.cloudboost.json.JSONArray;
import io.cloudboost.json.JSONException;
import io.cloudboost.json.JSONObject;
import io.cloudboost.util.CBParser;
import java.util.ArrayList;

public class ACL {
    private ArrayList<String> allowedReadUser = new ArrayList();
    private ArrayList<String> allowedReadRole = new ArrayList();
    private ArrayList<String> deniedReadUser = new ArrayList();
    private ArrayList<String> deniedReadRole = new ArrayList();
    private ArrayList<String> allowedWriteUser = new ArrayList();
    private ArrayList<String> allowedWriteRole = new ArrayList();
    private ArrayList<String> deniedWriteUser = new ArrayList();
    private ArrayList<String> deniedWriteRole = new ArrayList();
    JSONObject allowRead;
    JSONObject denyRead;
    JSONObject allowWrite;
    JSONObject denyWrite;
    JSONObject read;
    JSONObject write;
    JSONObject acl;

    public ACL() {
        this.allowedReadUser.add("all");
        this.allowedWriteUser.add("all");
        this.allowRead = new JSONObject();
        this.denyRead = new JSONObject();
        this.allowWrite = new JSONObject();
        this.denyWrite = new JSONObject();
        try {
            this.allowRead.put("user", this.allowedReadUser);
            this.allowRead.put("role", this.allowedReadRole);
            this.allowWrite.put("user", this.allowedWriteUser);
            this.allowWrite.put("role", this.allowedWriteRole);
            this.denyRead.put("user", this.deniedReadUser);
            this.denyRead.put("role", this.deniedReadRole);
            this.denyWrite.put("user", this.deniedWriteUser);
            this.denyWrite.put("role", this.deniedWriteRole);
            this.read = new JSONObject();
            this.read.put("allow", this.allowRead);
            this.read.put("deny", this.denyRead);
            this.write = new JSONObject();
            this.write.put("allow", this.allowWrite);
            this.write.put("deny", this.denyWrite);
            this.acl = new JSONObject();
            this.acl.put("read", this.read);
            this.acl.put("write", this.write);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject getACL() {
        return this.acl;
    }

    public ArrayList<String> getAllowedWriteRole() {
        try {
            this.write = (JSONObject)this.acl.get("write");
            this.allowWrite = (JSONObject)this.write.get("allow");
            JSONArray role = new JSONArray(this.allowWrite.get("role").toString());
            this.allowedWriteUser.clear();
            for (int i = 0; i < role.length(); ++i) {
                this.allowedWriteUser.add(i, role.getString(i));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.allowedWriteUser;
    }

    public ArrayList<String> getAllowedReadRole() {
        try {
            this.read = (JSONObject)this.acl.get("read");
            this.allowRead = (JSONObject)this.read.get("allow");
            JSONArray role = new JSONArray(this.allowRead.get("role").toString());
            this.allowedReadUser.clear();
            for (int i = 0; i < role.length(); ++i) {
                this.allowedReadUser.add(i, role.getString(i));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.allowedReadUser;
    }

    public ArrayList<String> getAllowedWriteUser() {
        try {
            this.write = (JSONObject)this.acl.get("write");
            this.allowWrite = (JSONObject)this.write.get("allow");
            JSONArray user = new JSONArray(this.allowWrite.get("user").toString());
            this.allowedWriteUser.clear();
            for (int i = 0; i < user.length(); ++i) {
                this.allowedWriteUser.add(i, user.getString(i));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.allowedWriteUser;
    }

    public ArrayList<String> getAllowedReadUser() {
        try {
            this.read = (JSONObject)this.acl.get("read");
            this.allowRead = (JSONObject)this.read.get("allow");
            this.allowedReadUser.clear();
            JSONArray user = new JSONArray(this.allowRead.get("user").toString());
            for (int i = 0; i < user.length(); ++i) {
                this.allowedReadUser.add(i, user.getString(i));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.allowedReadUser;
    }

    private ArrayList<String> getDeniedWriteList(JSONObject acl) {
        try {
            this.write = (JSONObject)acl.get("write");
            this.denyWrite = (JSONObject)this.write.get("deny");
            JSONArray user = new JSONArray(this.denyWrite.get("user").toString());
            this.deniedWriteUser.clear();
            for (int i = 0; i < user.length(); ++i) {
                this.deniedWriteUser.add(i, user.getString(i));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.deniedWriteUser;
    }

    public ArrayList<String> getDeniedReadUser() {
        try {
            this.read = (JSONObject)this.acl.get("read");
            this.denyRead = (JSONObject)this.read.get("deny");
            JSONArray user = new JSONArray(this.denyRead.get("user").toString());
            this.deniedReadUser.clear();
            for (int i = 0; i < user.length(); ++i) {
                this.deniedReadUser.add(i, user.getString(i));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.deniedReadUser;
    }

    public void setPublicWriteAccess(boolean value) {
        this.allowedWriteUser = this.getAllowedWriteUser();
        if (value) {
            this.allowedWriteUser.clear();
            this.allowedWriteUser.add("all");
        } else {
            int index = this.allowedWriteUser.indexOf("all");
            if (index >= 0) {
                this.allowedWriteUser.remove("all");
            }
        }
        try {
            this.allowWrite.put("user", this.allowedWriteUser);
            this.write.put("allow", this.allowWrite);
            this.acl.put("write", this.write);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setPublicReadAccess(boolean value) {
        this.allowedReadUser = this.getAllowedReadUser();
        if (value) {
            this.allowedReadUser.clear();
            this.allowedReadUser.add("all");
        } else {
            int index = this.allowedReadUser.indexOf("all");
            if (index > -1) {
                this.allowedReadUser.remove("all");
            }
        }
        try {
            this.allowRead.put("user", this.allowedReadUser);
            this.read.put("allow", this.allowRead);
            this.acl.put("read", this.read);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setUserWriteAccess(String userId, boolean value) {
        this.allowedWriteUser = this.getAllowedWriteUser();
        this.deniedWriteUser = this.getDeniedWriteList(this.acl);
        if (value) {
            int index = this.allowedWriteUser.indexOf("all");
            if (index > -1) {
                this.allowedWriteUser.remove(index);
            }
            if ((index = this.allowedWriteUser.indexOf(userId)) <= -1) {
                this.allowedWriteUser.add(userId);
            }
        } else {
            int index = this.allowedWriteUser.indexOf(userId);
            if (index > -1) {
                this.allowedWriteUser.remove(index);
            }
            this.deniedWriteUser.add(userId);
        }
        try {
            this.allowWrite.put("user", this.allowedWriteUser);
            this.denyWrite.put("user", this.deniedWriteUser);
            this.write.put("deny", this.denyWrite);
            this.write.put("allow", this.allowWrite);
            this.acl.put("write", this.write);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setUserReadAccess(String userId, boolean value) {
        this.allowedReadUser = this.getAllowedReadUser();
        this.deniedReadUser = this.getDeniedReadUser();
        if (value) {
            int index = this.allowedReadUser.indexOf("all");
            if (index > -1) {
                this.allowedReadUser.remove(index);
            }
            if ((index = this.allowedReadUser.indexOf(userId)) <= -1) {
                this.allowedReadUser.add(userId);
            }
        } else {
            int index = this.allowedReadUser.indexOf(userId);
            if (index > -1) {
                this.allowedReadUser.remove(index);
            }
            this.deniedReadUser.add(userId);
        }
        try {
            this.allowRead.put("user", this.allowedReadUser);
            this.denyRead.put("user", this.deniedReadUser);
            this.read.put("deny", this.denyRead);
            this.read.put("allow", this.allowRead);
            this.acl.put("read", this.read);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setRoleWriteAccess(String roleId, boolean value) {
        this.allowedWriteUser = this.getAllowedWriteUser();
        this.deniedWriteUser = this.getDeniedWriteList(this.acl);
        try {
            this.write = (JSONObject)this.acl.get("write");
            this.allowWrite = (JSONObject)this.write.get("allow");
            this.allowedWriteRole = CBParser.jsonToList((JSONArray)this.allowWrite.get("role"));
            this.denyWrite = (JSONObject)this.write.get("deny");
            this.deniedWriteRole = CBParser.jsonToList((JSONArray)this.denyWrite.get("role"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (value) {
            int index = this.allowedWriteUser.indexOf("all");
            if (index > -1) {
                this.allowedWriteUser.remove(index);
            }
            if ((index = this.allowedWriteRole.indexOf(roleId)) <= -1) {
                this.allowedWriteRole.add(roleId);
            }
        } else {
            int index = this.allowedWriteRole.indexOf(roleId);
            if (index > -1) {
                this.allowedWriteRole.remove(index);
            }
            if ((index = this.allowedWriteUser.indexOf("all")) > -1) {
                this.allowedWriteUser.remove(index);
            }
            this.deniedWriteRole.add(roleId);
        }
        try {
            this.allowWrite.put("user", this.allowedWriteUser);
            this.allowWrite.put("role", this.allowedWriteRole);
            this.denyWrite.put("role", this.deniedWriteRole);
            this.write.put("deny", this.denyWrite);
            this.write.put("allow", this.allowWrite);
            this.acl.put("write", this.write);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setRoleReadAccess(String roleId, boolean value) {
        this.allowedReadUser = this.getAllowedReadUser();
        this.deniedWriteUser = this.getDeniedReadUser();
        try {
            this.write = (JSONObject)this.acl.get("write");
            this.allowRead = (JSONObject)this.read.get("allow");
            this.allowedReadRole = CBParser.jsonToList((JSONArray)this.allowRead.get("role"));
            this.denyRead = (JSONObject)this.read.get("deny");
            this.deniedReadRole = CBParser.jsonToList((JSONArray)this.denyRead.get("role"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (value) {
            int index = this.allowedReadUser.indexOf("all");
            if (index > -1) {
                this.allowedReadUser.remove(index);
            }
            if ((index = this.allowedReadRole.indexOf(roleId)) <= -1) {
                this.allowedReadRole.add(roleId);
            }
        } else {
            int index = this.allowedReadRole.indexOf(roleId);
            if (index > -1) {
                this.allowedReadRole.remove(index);
            }
            if ((index = this.allowedReadUser.indexOf("all")) > -1) {
                this.allowedReadUser.remove(index);
            }
            this.deniedReadRole.add(roleId);
        }
        try {
            this.allowRead.put("user", this.allowedReadUser);
            this.allowRead.put("role", this.allowedReadRole);
            this.denyRead.put("role", this.deniedReadRole);
            this.read.put("deny", this.denyRead);
            this.read.put("allow", this.allowRead);
            this.acl.put("read", this.read);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

